/*
 * Decompiled with CFR 0.152.
 */
package com.rd.animation;

import android.animation.IntEvaluator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.support.annotation.NonNull;
import android.view.animation.DecelerateInterpolator;
import com.rd.animation.AbsAnimation;
import com.rd.animation.ValueAnimation;

public class SlideAnimation
extends AbsAnimation<ValueAnimator> {
    private static final String ANIMATION_X_COORDINATE = "ANIMATION_X_COORDINATE";
    private static final int ANIMATION_DURATION = 350;
    private int xStartCoordinate;
    private int xEndCoordinate;

    public SlideAnimation(@NonNull ValueAnimation.UpdateListener listener) {
        super(listener);
    }

    @Override
    @NonNull
    public ValueAnimator createAnimator() {
        ValueAnimator animator = new ValueAnimator();
        animator.setDuration(350L);
        animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                SlideAnimation.this.onAnimateUpdated(animation);
            }
        });
        return animator;
    }

    @Override
    public SlideAnimation progress(float progress) {
        if (this.animator != null) {
            long playTime = (long)(progress * (float)this.animationDuration);
            ((ValueAnimator)this.animator).setCurrentPlayTime(playTime);
        }
        return this;
    }

    @NonNull
    public SlideAnimation with(int startValue, int endValue) {
        if (this.animator != null && this.hasChanges(startValue, endValue)) {
            this.xStartCoordinate = startValue;
            this.xEndCoordinate = endValue;
            PropertyValuesHolder holder = this.createColorPropertyHolder();
            ((ValueAnimator)this.animator).setValues(new PropertyValuesHolder[]{holder});
        }
        return this;
    }

    private PropertyValuesHolder createColorPropertyHolder() {
        PropertyValuesHolder holder = PropertyValuesHolder.ofInt((String)ANIMATION_X_COORDINATE, (int[])new int[]{this.xStartCoordinate, this.xEndCoordinate});
        holder.setEvaluator((TypeEvaluator)new IntEvaluator());
        return holder;
    }

    private void onAnimateUpdated(@NonNull ValueAnimator animation) {
        int xCoordinate = (Integer)animation.getAnimatedValue(ANIMATION_X_COORDINATE);
        if (this.listener != null) {
            this.listener.onSlideAnimationUpdated(xCoordinate);
        }
    }

    private boolean hasChanges(int startValue, int endValue) {
        if (this.xStartCoordinate != startValue) {
            return true;
        }
        return this.xEndCoordinate != endValue;
    }
}

