/*
 * Decompiled with CFR 0.152.
 */
package com.rd.animation;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.support.annotation.NonNull;
import com.rd.animation.ValueAnimation;

public abstract class AbsAnimation<T extends Animator> {
    public static final int DEFAULT_ANIMATION_TIME = 350;
    protected long animationDuration = 350L;
    protected ValueAnimation.UpdateListener listener;
    protected T animator;

    public AbsAnimation(@NonNull ValueAnimation.UpdateListener listener) {
        this.listener = listener;
        this.animator = this.createAnimator();
    }

    @NonNull
    public abstract T createAnimator();

    public abstract AbsAnimation progress(float var1);

    public AbsAnimation duration(long duration) {
        this.animationDuration = duration;
        if (this.animator instanceof AnimatorSet) {
            int size = ((AnimatorSet)this.animator).getChildAnimations().size();
            long singleDuration = this.animationDuration / (long)size;
            this.animator.setDuration(singleDuration);
        } else {
            this.animator.setDuration(this.animationDuration);
        }
        return this;
    }

    public void start() {
        if (this.animator != null) {
            this.animator.start();
        }
    }

    public void end() {
        if (this.animator != null) {
            this.animator.end();
        }
    }
}

