/*
 * Decompiled with CFR 0.152.
 */
package com.rd.pageindicatorview.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.View;
import com.rd.pageindicatorview.R;
import com.rd.pageindicatorview.utils.DensityUtils;
import com.rd.pageindicatorview.view.animation.AbsAnimation;
import com.rd.pageindicatorview.view.animation.AnimationType;
import com.rd.pageindicatorview.view.animation.ValueAnimation;

public class PageIndicatorView
extends View
implements ViewPager.OnPageChangeListener {
    private static final String DEFAULT_UNSELECTED_COLOR = "#33ffffff";
    private static final String DEFAULT_SELECTED_COLOR = "#ffffff";
    private static final int DEFAULT_CIRCLES_COUNT = 3;
    private static final int DEFAULT_RADIUS_DP = 6;
    private static final int DEFAULT_PADDING_DP = 8;
    private int radiusPx = DensityUtils.dpToPx(6);
    private int paddingPx = DensityUtils.dpToPx(8);
    private int count = 3;
    private int unselectedColor = Color.parseColor((String)"#33ffffff");
    private int selectedColor = Color.parseColor((String)"#ffffff");
    private int frameColor;
    private int frameColorReverse;
    private int frameRadiusPx;
    private int frameRadiusReversePx;
    private float scaleFactor;
    private int frameLeftX;
    private int frameRightX;
    private int frameXCoordinate;
    private int selectedPosition;
    private int selectingPosition;
    private int lastSelectedPosition;
    private boolean interactiveAnimation;
    private long animationDuration;
    private Paint paint = new Paint();
    private RectF rect = new RectF();
    private AnimationType animationType = AnimationType.NONE;
    private ValueAnimation animation;
    private ViewPager viewPager;

    public PageIndicatorView(Context context) {
        super(context);
        this.init(null);
    }

    public PageIndicatorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public PageIndicatorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @TargetApi(value=21)
    public PageIndicatorView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int circleDiameterPx;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int desiredHeight = circleDiameterPx = this.radiusPx * 2;
        int desiredWidth = 0;
        if (this.count != 0) {
            desiredWidth = circleDiameterPx * this.count + this.paddingPx * (this.count - 1);
        }
        int width = widthMode == 0x40000000 ? widthSize : (widthMode == Integer.MIN_VALUE ? Math.min(desiredWidth, widthSize) : desiredWidth);
        int height = heightMode == 0x40000000 ? heightSize : (heightMode == Integer.MIN_VALUE ? Math.min(desiredHeight, heightSize) : desiredHeight);
        if (width < 0) {
            width = 0;
        }
        if (height < 0) {
            height = 0;
        }
        this.setMeasuredDimension(width, height);
    }

    protected void onDraw(Canvas canvas) {
        this.drawIndicatorView(canvas);
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.interactiveAnimation) {
            this.onPageScroll(position, positionOffset);
        }
    }

    public void onPageSelected(int position) {
        if (!this.interactiveAnimation || this.animationType == AnimationType.NONE) {
            this.setSelection(position);
        }
    }

    public void onPageScrollStateChanged(int state) {
    }

    public void setCount(int count) {
        this.count = count;
        this.invalidate();
    }

    public int getCount() {
        return this.count;
    }

    public void setRadius(int radiusDp) {
        if (radiusDp < 0) {
            radiusDp = 0;
        }
        this.radiusPx = DensityUtils.dpToPx(radiusDp);
        this.initFrameValues();
        this.invalidate();
    }

    public int getRadius() {
        return DensityUtils.dpToPx(this.radiusPx);
    }

    public void setPadding(int paddingDp) {
        this.paddingPx = DensityUtils.dpToPx(paddingDp);
        this.initFrameValues();
        this.invalidate();
    }

    public int getPadding() {
        return DensityUtils.dpToPx(this.paddingPx);
    }

    public void setUnselectedColor(int color) {
        this.unselectedColor = color;
        this.initFrameValues();
        this.invalidate();
    }

    public int getUnselectedColor() {
        return this.unselectedColor;
    }

    public void setSelectedColor(int color) {
        this.selectedColor = color;
        this.initFrameValues();
        this.invalidate();
    }

    public int getSelectedColor() {
        return this.selectedColor;
    }

    public void setAnimationDuration(long duration) {
        this.animationDuration = duration;
    }

    public long getAnimationDuration() {
        return this.animationDuration;
    }

    public void setAnimationType(@Nullable AnimationType type) {
        this.animationType = type != null ? type : AnimationType.NONE;
    }

    public void setInteractiveAnimation(boolean isInteractive) {
        this.interactiveAnimation = isInteractive;
    }

    public void setProgress(int selectingPosition, float progress) {
        if (this.interactiveAnimation) {
            if (selectingPosition < 0) {
                selectingPosition = 0;
            } else if (selectingPosition > this.count - 1) {
                selectingPosition = this.count - 1;
            }
            if (progress < 0.0f) {
                progress = 0.0f;
            } else if (progress > 1.0f) {
                progress = 1.0f;
            }
            this.selectingPosition = selectingPosition;
            AbsAnimation animator = this.getSelectedAnimation();
            if (animator != null) {
                animator.progress(progress);
            }
        }
    }

    public void setSelection(int position) {
        if (position < 0) {
            position = 0;
        } else if (position > this.count - 1) {
            position = this.count - 1;
        }
        this.lastSelectedPosition = this.selectedPosition;
        this.selectedPosition = position;
        switch (this.animationType) {
            case NONE: {
                this.invalidate();
                break;
            }
            case COLOR: {
                this.startColorAnimation();
                break;
            }
            case SCALE: {
                this.startScaleAnimation();
                break;
            }
            case WORM: {
                this.startWormAnimation();
                break;
            }
            case SLIDE: {
                this.startSlideAnimation();
            }
        }
    }

    public int getSelection() {
        return this.selectedPosition;
    }

    public void addViewPager(@Nullable ViewPager pager) {
        if (pager != null) {
            this.viewPager = pager;
            this.viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        }
    }

    public void releaseViewPager() {
        if (this.viewPager != null) {
            this.viewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this);
            this.viewPager = null;
        }
    }

    private void onPageScroll(int position, float positionOffset) {
        Pair<Integer, Float> progressPair = this.getProgress(position, positionOffset);
        int selectingPosition = (Integer)progressPair.first;
        float selectingProgress = ((Float)progressPair.second).floatValue();
        if (selectingProgress == 1.0f) {
            this.lastSelectedPosition = this.selectedPosition;
            this.selectedPosition = selectingPosition;
        }
        this.setProgress(selectingPosition, selectingProgress);
    }

    private void drawIndicatorView(@NonNull Canvas canvas) {
        int y = this.getHeight() / 2;
        for (int i = 0; i < this.count; ++i) {
            int x = this.getXCoordinate(i);
            this.drawCircle(canvas, i, x, y);
        }
    }

    private void drawCircle(@NonNull Canvas canvas, int position, int x, int y) {
        boolean selectingItem;
        boolean selectedItem = !this.interactiveAnimation && (position == this.selectedPosition || position == this.lastSelectedPosition);
        boolean isSelectedItem = selectedItem | (selectingItem = this.interactiveAnimation && (position == this.selectingPosition || position == this.selectedPosition));
        if (isSelectedItem) {
            this.drawWithAnimationEffect(canvas, position, x, y);
        } else {
            this.drawWithNoEffect(canvas, position, x, y);
        }
    }

    private void drawWithAnimationEffect(@NonNull Canvas canvas, int position, int x, int y) {
        switch (this.animationType) {
            case COLOR: {
                this.drawWithColorAnimation(canvas, position, x, y);
                break;
            }
            case SCALE: {
                this.drawWithScaleAnimation(canvas, position, x, y);
                break;
            }
            case WORM: {
                this.drawWithWormAnimation(canvas, x, y);
                break;
            }
            case SLIDE: {
                this.drawWithSlideAnimation(canvas, position, x, y);
                break;
            }
            case NONE: {
                this.drawWithNoEffect(canvas, position, x, y);
            }
        }
    }

    private void drawWithColorAnimation(@NonNull Canvas canvas, int position, int x, int y) {
        int color = this.unselectedColor;
        if (this.interactiveAnimation) {
            if (position == this.selectingPosition) {
                color = this.frameColor;
            } else if (position == this.selectedPosition) {
                color = this.frameColorReverse;
            }
        } else if (position == this.selectedPosition) {
            color = this.frameColor;
        } else if (position == this.lastSelectedPosition) {
            color = this.frameColorReverse;
        }
        this.paint.setColor(color);
        canvas.drawCircle((float)x, (float)y, (float)this.radiusPx, this.paint);
    }

    private void drawWithScaleAnimation(@NonNull Canvas canvas, int position, int x, int y) {
        int color = this.unselectedColor;
        int radius = this.radiusPx;
        if (this.interactiveAnimation) {
            if (position == this.selectingPosition) {
                radius = this.frameRadiusPx;
                color = this.frameColor;
            } else if (position == this.selectedPosition) {
                radius = this.frameRadiusReversePx;
                color = this.frameColorReverse;
            }
        } else if (position == this.selectedPosition) {
            radius = this.frameRadiusPx;
            color = this.frameColor;
        } else if (position == this.lastSelectedPosition) {
            radius = this.frameRadiusReversePx;
            color = this.frameColorReverse;
        }
        this.paint.setColor(color);
        canvas.drawCircle((float)x, (float)y, (float)radius, this.paint);
    }

    private void drawWithWormAnimation(@NonNull Canvas canvas, int x, int y) {
        int radius = this.radiusPx;
        int left = this.frameLeftX;
        int right = this.frameRightX;
        int top = y - radius;
        int bot = y + radius;
        this.rect.left = left;
        this.rect.right = right;
        this.rect.top = top;
        this.rect.bottom = bot;
        this.paint.setColor(this.unselectedColor);
        canvas.drawCircle((float)x, (float)y, (float)radius, this.paint);
        this.paint.setColor(this.selectedColor);
        canvas.drawRoundRect(this.rect, (float)this.radiusPx, (float)this.radiusPx, this.paint);
    }

    private void drawWithSlideAnimation(@NonNull Canvas canvas, int position, int x, int y) {
        this.paint.setColor(this.unselectedColor);
        canvas.drawCircle((float)x, (float)y, (float)this.radiusPx, this.paint);
        if (this.interactiveAnimation && (position == this.selectingPosition || position == this.selectedPosition)) {
            this.paint.setColor(this.selectedColor);
            canvas.drawCircle((float)this.frameXCoordinate, (float)y, (float)this.radiusPx, this.paint);
        } else if (!(this.interactiveAnimation || position != this.selectedPosition && position != this.lastSelectedPosition)) {
            this.paint.setColor(this.selectedColor);
            canvas.drawCircle((float)this.frameXCoordinate, (float)y, (float)this.radiusPx, this.paint);
        }
    }

    private void drawWithNoEffect(@NonNull Canvas canvas, int position, int x, int y) {
        int radius = this.radiusPx;
        int color = this.unselectedColor;
        if (this.animationType == AnimationType.SCALE) {
            radius = (int)((float)radius / this.scaleFactor);
        }
        if (position == this.selectedPosition) {
            color = this.selectedColor;
        }
        this.paint.setColor(color);
        canvas.drawCircle((float)x, (float)y, (float)radius, this.paint);
    }

    private void init(@Nullable AttributeSet attrs) {
        this.initAttributes(attrs);
        this.initFrameValues();
        this.initAnimation();
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setAntiAlias(true);
    }

    private void initFrameValues() {
        this.frameColor = this.selectedColor;
        this.frameColorReverse = this.unselectedColor;
        this.frameRadiusPx = this.radiusPx;
        this.frameRadiusReversePx = this.radiusPx;
        int xCoordinate = this.getXCoordinate(this.selectedPosition);
        if (xCoordinate - this.radiusPx >= 0) {
            this.frameLeftX = xCoordinate - this.radiusPx;
            this.frameRightX = xCoordinate + this.radiusPx;
        } else {
            this.frameLeftX = xCoordinate;
            this.frameRightX = xCoordinate + this.radiusPx * 2;
        }
        this.frameXCoordinate = xCoordinate;
    }

    private void initAnimation() {
        this.animation = new ValueAnimation(new ValueAnimation.UpdateListener(){

            @Override
            public void onColorAnimationUpdated(int color, int colorReverse) {
                PageIndicatorView.this.frameColor = color;
                PageIndicatorView.this.frameColorReverse = colorReverse;
                PageIndicatorView.this.invalidate();
            }

            @Override
            public void onScaleAnimationUpdated(int color, int colorReverse, int radius, int radiusReverse) {
                PageIndicatorView.this.frameColor = color;
                PageIndicatorView.this.frameColorReverse = colorReverse;
                PageIndicatorView.this.frameRadiusPx = radius;
                PageIndicatorView.this.frameRadiusReversePx = radiusReverse;
                PageIndicatorView.this.invalidate();
            }

            @Override
            public void onWormAnimationUpdated(int leftX, int rightX) {
                PageIndicatorView.this.frameLeftX = leftX;
                PageIndicatorView.this.frameRightX = rightX;
                PageIndicatorView.this.invalidate();
            }

            @Override
            public void onSlideAnimationUpdated(int xCoordinate) {
                PageIndicatorView.this.frameXCoordinate = xCoordinate;
                PageIndicatorView.this.invalidate();
            }
        });
    }

    private void initAttributes(@Nullable AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.PageIndicatorView, 0, 0);
        this.count = typedArray.getInt(R.styleable.PageIndicatorView_count, 3);
        int position = typedArray.getInt(R.styleable.PageIndicatorView_select, 0);
        if (position < 0) {
            position = 0;
        } else if (this.count > 0 && position > this.count - 1) {
            position = this.count - 1;
        }
        this.selectedPosition = position;
        this.selectingPosition = position;
        this.paddingPx = (int)typedArray.getDimension(R.styleable.PageIndicatorView_padding, (float)this.paddingPx);
        this.radiusPx = (int)typedArray.getDimension(R.styleable.PageIndicatorView_radius, (float)this.radiusPx);
        this.scaleFactor = typedArray.getFloat(R.styleable.PageIndicatorView_scaleFactor, 1.7f);
        if (this.scaleFactor < 1.0f) {
            this.scaleFactor = 1.0f;
        } else if (this.scaleFactor > 3.0f) {
            this.scaleFactor = 3.0f;
        }
        this.unselectedColor = typedArray.getColor(R.styleable.PageIndicatorView_unselectedColor, this.unselectedColor);
        this.selectedColor = typedArray.getColor(R.styleable.PageIndicatorView_selectedColor, this.selectedColor);
        this.animationDuration = typedArray.getInt(R.styleable.PageIndicatorView_animationDuration, 350);
        this.interactiveAnimation = typedArray.getBoolean(R.styleable.PageIndicatorView_interactiveAnimation, false);
        int index = typedArray.getInt(R.styleable.PageIndicatorView_animationType, AnimationType.NONE.ordinal());
        this.animationType = this.getAnimationType(index);
        typedArray.recycle();
    }

    private AnimationType getAnimationType(int index) {
        switch (index) {
            case 0: {
                return AnimationType.NONE;
            }
            case 1: {
                return AnimationType.COLOR;
            }
            case 2: {
                return AnimationType.SCALE;
            }
            case 3: {
                return AnimationType.WORM;
            }
            case 4: {
                return AnimationType.SLIDE;
            }
        }
        return AnimationType.NONE;
    }

    private void startColorAnimation() {
        this.animation.color().with(this.unselectedColor, this.selectedColor).duration(this.animationDuration).start();
    }

    private void startScaleAnimation() {
        this.animation.scale().with(this.unselectedColor, this.selectedColor, this.radiusPx, this.scaleFactor).duration(this.animationDuration).start();
    }

    private void startWormAnimation() {
        int fromX = this.getXCoordinate(this.lastSelectedPosition);
        int toX = this.getXCoordinate(this.selectedPosition);
        boolean isRightSide = this.selectedPosition > this.lastSelectedPosition;
        this.animation.worm().end();
        this.animation.worm().with(fromX, toX, this.radiusPx, isRightSide).duration(this.animationDuration).start();
    }

    private void startSlideAnimation() {
        int fromX = this.getXCoordinate(this.lastSelectedPosition);
        int toX = this.getXCoordinate(this.selectedPosition);
        this.animation.slide().with(fromX, toX).duration(this.animationDuration).start();
    }

    @Nullable
    private AbsAnimation getSelectedAnimation() {
        switch (this.animationType) {
            case COLOR: {
                return this.animation.color().with(this.unselectedColor, this.selectedColor);
            }
            case SCALE: {
                return this.animation.scale().with(this.unselectedColor, this.selectedColor, this.radiusPx, this.scaleFactor);
            }
            case WORM: 
            case SLIDE: {
                int fromX = this.getXCoordinate(this.selectedPosition);
                int toX = this.getXCoordinate(this.selectingPosition);
                if (this.animationType == AnimationType.WORM) {
                    boolean isRightSide = this.selectingPosition > this.selectedPosition;
                    return this.animation.worm().with(fromX, toX, this.radiusPx, isRightSide);
                }
                if (this.animationType != AnimationType.SLIDE) break;
                return this.animation.slide().with(fromX, toX);
            }
        }
        return null;
    }

    private int getXCoordinate(int position) {
        int actualViewWidth = this.calculateActualViewWidth();
        int x = (this.getWidth() - actualViewWidth) / 2;
        if (x < 0) {
            x = 0;
        }
        for (int i = 0; i < this.count; ++i) {
            x += this.radiusPx;
            if (position == i) {
                return x;
            }
            x += this.radiusPx + this.paddingPx;
        }
        return x;
    }

    private Pair<Integer, Float> getProgress(int position, float positionOffset) {
        float selectingProgress;
        int selectingPosition;
        boolean isSlideToRightSide;
        boolean isLeftOverScrolled;
        boolean isRightOverScrolled = position > this.selectedPosition;
        boolean bl = isLeftOverScrolled = position + 1 < this.selectedPosition;
        if (isRightOverScrolled || isLeftOverScrolled) {
            this.selectedPosition = position;
        }
        boolean bl2 = isSlideToRightSide = this.selectedPosition == position && positionOffset != 0.0f;
        if (isSlideToRightSide) {
            selectingPosition = position + 1;
            selectingProgress = positionOffset;
        } else {
            selectingPosition = position;
            selectingProgress = 1.0f - positionOffset;
        }
        if (selectingProgress > 1.0f) {
            selectingProgress = 1.0f;
        } else if (selectingProgress < 0.0f) {
            selectingProgress = 0.0f;
        }
        return new Pair((Object)selectingPosition, (Object)Float.valueOf(selectingProgress));
    }

    private int calculateActualViewWidth() {
        int width = 0;
        int diameter = this.radiusPx * 2;
        for (int i = 0; i < this.count; ++i) {
            width += diameter;
            if (i >= this.count - 1) continue;
            width += this.paddingPx;
        }
        return width;
    }
}

