/*
 * Decompiled with CFR 0.152.
 */
package com.rd.pageindicatorview.view.animation;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.support.annotation.NonNull;
import android.view.animation.DecelerateInterpolator;
import com.rd.pageindicatorview.view.animation.AbsAnimation;
import com.rd.pageindicatorview.view.animation.ValueAnimation;

public class WormAnimation
extends AbsAnimation<AnimatorSet> {
    private int fromValue;
    private int toValue;
    private int radius;
    private boolean isRightSide;
    private int rectLeftX;
    private int rectRightX;

    public WormAnimation(@NonNull ValueAnimation.UpdateListener listener) {
        super(listener);
    }

    @Override
    @NonNull
    public AnimatorSet createAnimator() {
        AnimatorSet animator = new AnimatorSet();
        animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        return animator;
    }

    public WormAnimation with(int fromValue, int toValue, int radius, boolean isRightSide) {
        if (this.hasChanges(fromValue, toValue, radius, isRightSide)) {
            this.animator = this.createAnimator();
            this.fromValue = fromValue;
            this.toValue = toValue;
            this.radius = radius;
            this.isRightSide = isRightSide;
            AnimationValues values = this.createAnimationValues(isRightSide);
            ValueAnimator straightAnimator = this.createValueAnimator(values.fromX, values.toX, false);
            ValueAnimator reverseAnimator = this.createValueAnimator(values.reverseFromX, values.reverseToX, true);
            ((AnimatorSet)this.animator).playSequentially(new Animator[]{straightAnimator, reverseAnimator});
        }
        return this;
    }

    @Override
    public WormAnimation progress(float progress) {
        if (this.animator != null) {
            long playTimeLeft = (long)(progress * (float)this.animationDuration);
            for (Animator anim : ((AnimatorSet)this.animator).getChildAnimations()) {
                long currPlayTime;
                ValueAnimator animator = (ValueAnimator)anim;
                if (playTimeLeft < 0L) {
                    playTimeLeft = 0L;
                }
                if ((currPlayTime = playTimeLeft) >= animator.getDuration()) {
                    currPlayTime = animator.getDuration();
                }
                animator.setCurrentPlayTime(currPlayTime);
                playTimeLeft -= currPlayTime;
            }
        }
        return this;
    }

    private ValueAnimator createValueAnimator(int fromX, int toX, final boolean isReverseAnimator) {
        ValueAnimator anim = ValueAnimator.ofInt((int[])new int[]{fromX, toX});
        anim.setDuration(this.animationDuration / 2L);
        anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int value = (Integer)animation.getAnimatedValue();
                if (!isReverseAnimator) {
                    if (WormAnimation.this.isRightSide) {
                        WormAnimation.this.rectRightX = value;
                    } else {
                        WormAnimation.this.rectLeftX = value;
                    }
                } else if (WormAnimation.this.isRightSide) {
                    WormAnimation.this.rectLeftX = value;
                } else {
                    WormAnimation.this.rectRightX = value;
                }
                WormAnimation.this.listener.onWormAnimationUpdated(WormAnimation.this.rectLeftX, WormAnimation.this.rectRightX);
            }
        });
        return anim;
    }

    private boolean hasChanges(int fromValue, int toValue, int radius, boolean isRightSide) {
        if (this.fromValue != fromValue) {
            return true;
        }
        if (this.toValue != toValue) {
            return true;
        }
        if (this.radius != radius) {
            return true;
        }
        return this.isRightSide != isRightSide;
    }

    @NonNull
    private AnimationValues createAnimationValues(boolean isRightSide) {
        int reverseToX;
        int reverseFromX;
        int toX;
        int fromX;
        if (isRightSide) {
            fromX = this.fromValue + this.radius;
            toX = this.toValue + this.radius;
            reverseFromX = this.fromValue - this.radius;
            reverseToX = this.toValue - this.radius;
        } else {
            fromX = this.fromValue - this.radius;
            toX = this.toValue - this.radius;
            reverseFromX = this.fromValue + this.radius;
            reverseToX = this.toValue + this.radius;
        }
        return new AnimationValues(fromX, toX, reverseFromX, reverseToX);
    }

    private class AnimationValues {
        public final int fromX;
        private final int toX;
        private final int reverseFromX;
        private final int reverseToX;

        public AnimationValues(int fromX, int toX, int reverseFromX, int reverseToX) {
            this.fromX = fromX;
            this.toX = toX;
            this.reverseFromX = reverseFromX;
            this.reverseToX = reverseToX;
        }
    }
}

