/*
 * Decompiled with CFR 0.152.
 */
package com.romainpiel.shimmer;

import android.content.res.TypedArray;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import com.romainpiel.shimmer.R;

public class ShimmerViewHelper {
    private static final int DEFAULT_REFLECTION_COLOR = -1;
    private View view;
    private Paint paint;
    private float gradientX;
    private LinearGradient linearGradient;
    private Matrix linearGradientMatrix;
    private int primaryColor;
    private int reflectionColor;
    private boolean isShimmering;
    private boolean isSetUp;
    private AnimationSetupCallback callback;

    public ShimmerViewHelper(View view, Paint paint, AttributeSet attributeSet) {
        this.view = view;
        this.paint = paint;
        this.init(attributeSet);
    }

    public float getGradientX() {
        return this.gradientX;
    }

    public void setGradientX(float gradientX) {
        this.gradientX = gradientX;
        this.view.invalidate();
    }

    public boolean isShimmering() {
        return this.isShimmering;
    }

    public void setShimmering(boolean isShimmering) {
        this.isShimmering = isShimmering;
    }

    public boolean isSetUp() {
        return this.isSetUp;
    }

    public void setAnimationSetupCallback(AnimationSetupCallback callback) {
        this.callback = callback;
    }

    public int getPrimaryColor() {
        return this.primaryColor;
    }

    public void setPrimaryColor(int primaryColor) {
        this.primaryColor = primaryColor;
        if (this.isSetUp) {
            this.resetLinearGradient();
        }
    }

    public int getReflectionColor() {
        return this.reflectionColor;
    }

    public void setReflectionColor(int reflectionColor) {
        this.reflectionColor = reflectionColor;
        if (this.isSetUp) {
            this.resetLinearGradient();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(AttributeSet attributeSet) {
        TypedArray a;
        this.reflectionColor = -1;
        if (attributeSet != null && (a = this.view.getContext().obtainStyledAttributes(attributeSet, R.styleable.ShimmerView, 0, 0)) != null) {
            try {
                this.reflectionColor = a.getColor(R.styleable.ShimmerView_reflectionColor, -1);
            }
            catch (Exception e) {
                Log.e((String)"ShimmerTextView", (String)"Error while creating the view:", (Throwable)e);
            }
            finally {
                a.recycle();
            }
        }
        this.linearGradientMatrix = new Matrix();
    }

    private void resetLinearGradient() {
        this.linearGradient = new LinearGradient((float)(-this.view.getWidth()), 0.0f, 0.0f, 0.0f, new int[]{this.primaryColor, this.reflectionColor, this.primaryColor}, new float[]{0.0f, 0.5f, 1.0f}, Shader.TileMode.CLAMP);
        this.paint.setShader((Shader)this.linearGradient);
    }

    protected void onSizeChanged() {
        this.resetLinearGradient();
        if (!this.isSetUp) {
            this.isSetUp = true;
            if (this.callback != null) {
                this.callback.onSetupAnimation(this.view);
            }
        }
    }

    public void onDraw() {
        if (this.isShimmering) {
            if (this.paint.getShader() == null) {
                this.paint.setShader((Shader)this.linearGradient);
            }
            this.linearGradientMatrix.setTranslate(2.0f * this.gradientX, 0.0f);
            this.linearGradient.setLocalMatrix(this.linearGradientMatrix);
        } else {
            this.paint.setShader(null);
        }
    }

    public static interface AnimationSetupCallback {
        public void onSetupAnimation(View var1);
    }
}

