/*
 * Decompiled with CFR 0.152.
 */
package com.romainpiel.shimmer;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;
import com.romainpiel.shimmer.ShimmerViewBase;
import com.romainpiel.shimmer.ShimmerViewHelper;

public class ShimmerButton
extends Button
implements ShimmerViewBase {
    private ShimmerViewHelper shimmerViewHelper;

    public ShimmerButton(Context context) {
        super(context);
        this.shimmerViewHelper = new ShimmerViewHelper((View)this, (Paint)this.getPaint(), null);
        this.shimmerViewHelper.setPrimaryColor(this.getCurrentTextColor());
    }

    public ShimmerButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.shimmerViewHelper = new ShimmerViewHelper((View)this, (Paint)this.getPaint(), attrs);
        this.shimmerViewHelper.setPrimaryColor(this.getCurrentTextColor());
    }

    public ShimmerButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.shimmerViewHelper = new ShimmerViewHelper((View)this, (Paint)this.getPaint(), attrs);
        this.shimmerViewHelper.setPrimaryColor(this.getCurrentTextColor());
    }

    @Override
    public float getGradientX() {
        return this.shimmerViewHelper.getGradientX();
    }

    @Override
    public void setGradientX(float gradientX) {
        this.shimmerViewHelper.setGradientX(gradientX);
    }

    @Override
    public boolean isShimmering() {
        return this.shimmerViewHelper.isShimmering();
    }

    @Override
    public void setShimmering(boolean isShimmering) {
        this.shimmerViewHelper.setShimmering(isShimmering);
    }

    @Override
    public boolean isSetUp() {
        return this.shimmerViewHelper.isSetUp();
    }

    @Override
    public void setAnimationSetupCallback(ShimmerViewHelper.AnimationSetupCallback callback) {
        this.shimmerViewHelper.setAnimationSetupCallback(callback);
    }

    @Override
    public int getPrimaryColor() {
        return this.shimmerViewHelper.getPrimaryColor();
    }

    @Override
    public void setPrimaryColor(int primaryColor) {
        this.shimmerViewHelper.setPrimaryColor(primaryColor);
    }

    @Override
    public int getReflectionColor() {
        return this.shimmerViewHelper.getReflectionColor();
    }

    @Override
    public void setReflectionColor(int reflectionColor) {
        this.shimmerViewHelper.setReflectionColor(reflectionColor);
    }

    public void setTextColor(int color) {
        super.setTextColor(color);
        if (this.shimmerViewHelper != null) {
            this.shimmerViewHelper.setPrimaryColor(this.getCurrentTextColor());
        }
    }

    public void setTextColor(ColorStateList colors) {
        super.setTextColor(colors);
        if (this.shimmerViewHelper != null) {
            this.shimmerViewHelper.setPrimaryColor(this.getCurrentTextColor());
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.shimmerViewHelper != null) {
            this.shimmerViewHelper.onSizeChanged();
        }
    }

    public void onDraw(Canvas canvas) {
        if (this.shimmerViewHelper != null) {
            this.shimmerViewHelper.onDraw();
        }
        super.onDraw(canvas);
    }
}

