/*
 * Decompiled with CFR 0.152.
 */
package com.romainpiel.shimmer;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.os.Build;
import android.view.View;
import com.romainpiel.shimmer.ShimmerViewBase;
import com.romainpiel.shimmer.ShimmerViewHelper;

public class Shimmer {
    public static final int ANIMATION_DIRECTION_LTR = 0;
    public static final int ANIMATION_DIRECTION_RTL = 1;
    private static final int DEFAULT_REPEAT_COUNT = -1;
    private static final long DEFAULT_DURATION = 1000L;
    private static final long DEFAULT_START_DELAY = 0L;
    private static final int DEFAULT_DIRECTION = 0;
    private int repeatCount = -1;
    private long duration = 1000L;
    private long startDelay = 0L;
    private int direction = 0;
    private Animator.AnimatorListener animatorListener;
    private ObjectAnimator animator;

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public Shimmer setRepeatCount(int repeatCount) {
        this.repeatCount = repeatCount;
        return this;
    }

    public long getDuration() {
        return this.duration;
    }

    public Shimmer setDuration(long duration) {
        this.duration = duration;
        return this;
    }

    public long getStartDelay() {
        return this.startDelay;
    }

    public Shimmer setStartDelay(long startDelay) {
        this.startDelay = startDelay;
        return this;
    }

    public int getDirection() {
        return this.direction;
    }

    public Shimmer setDirection(int direction) {
        if (direction != 0 && direction != 1) {
            throw new IllegalArgumentException("The animation direction must be either ANIMATION_DIRECTION_LTR or ANIMATION_DIRECTION_RTL");
        }
        this.direction = direction;
        return this;
    }

    public Animator.AnimatorListener getAnimatorListener() {
        return this.animatorListener;
    }

    public Shimmer setAnimatorListener(Animator.AnimatorListener animatorListener) {
        this.animatorListener = animatorListener;
        return this;
    }

    public <V extends View> void start(final V shimmerView) {
        if (this.isAnimating()) {
            return;
        }
        final Runnable animate = new Runnable(){

            @Override
            public void run() {
                ((ShimmerViewBase)shimmerView).setShimmering(true);
                float fromX = 0.0f;
                float toX = shimmerView.getWidth();
                if (Shimmer.this.direction == 1) {
                    fromX = shimmerView.getWidth();
                    toX = 0.0f;
                }
                Shimmer.this.animator = ObjectAnimator.ofFloat((Object)shimmerView, (String)"gradientX", (float[])new float[]{fromX, toX});
                Shimmer.this.animator.setRepeatCount(Shimmer.this.repeatCount);
                Shimmer.this.animator.setDuration(Shimmer.this.duration);
                Shimmer.this.animator.setStartDelay(Shimmer.this.startDelay);
                Shimmer.this.animator.addListener(new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                    }

                    public void onAnimationEnd(Animator animation) {
                        ((ShimmerViewBase)shimmerView).setShimmering(false);
                        if (Build.VERSION.SDK_INT < 16) {
                            shimmerView.postInvalidate();
                        } else {
                            shimmerView.postInvalidateOnAnimation();
                        }
                        Shimmer.this.animator = null;
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
                if (Shimmer.this.animatorListener != null) {
                    Shimmer.this.animator.addListener(Shimmer.this.animatorListener);
                }
                Shimmer.this.animator.start();
            }
        };
        if (!((ShimmerViewBase)shimmerView).isSetUp()) {
            ((ShimmerViewBase)shimmerView).setAnimationSetupCallback(new ShimmerViewHelper.AnimationSetupCallback(){

                @Override
                public void onSetupAnimation(View target) {
                    animate.run();
                }
            });
        } else {
            animate.run();
        }
    }

    public void cancel() {
        if (this.animator != null) {
            this.animator.cancel();
        }
    }

    public boolean isAnimating() {
        return this.animator != null && this.animator.isRunning();
    }
}

