/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.android.provider;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.rollbar.api.payload.data.Notifier;
import com.rollbar.notifier.provider.Provider;

public class NotifierProvider
implements Provider<Notifier> {
    private static final String VERSION_METADATA_NAME = "com.rollbar.android._notifier.version";
    private static final String NAME = "rollbar-android";
    private final Notifier notifier;

    public NotifierProvider(Context context) {
        this(NotifierProvider.loadVersionFromContext(context));
    }

    public NotifierProvider(String version) {
        this.notifier = new Notifier.Builder().name(NAME).version(version).build();
    }

    public NotifierProvider(String version, String name) {
        this.notifier = new Notifier.Builder().name(name).version(version).build();
    }

    public Notifier provide() {
        return this.notifier;
    }

    private static String loadVersionFromContext(Context context) {
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle data = ai.metaData;
            return data.getString(VERSION_METADATA_NAME);
        }
        catch (PackageManager.NameNotFoundException e) {
            return "unknown";
        }
    }
}

