/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.android.notifier.sender;

import android.content.Context;
import com.rollbar.android.notifier.sender.ConnectivityDetector;
import com.rollbar.api.payload.Payload;
import com.rollbar.notifier.sender.SenderFailureStrategy;
import com.rollbar.notifier.sender.result.Response;
import com.rollbar.notifier.sender.result.Result;
import com.rollbar.notifier.util.ObjectsUtils;
import java.net.SocketException;
import java.net.UnknownHostException;

public class ConnectionAwareSenderFailureStrategy
implements SenderFailureStrategy {
    private final ConnectivityDetector detector;
    private final NanoTimeProvider timeProvider;
    private volatile boolean isSendingSuspended;
    private volatile long resumeTime;
    private static final long SUSPEND_TIME_NO_NETWORK_MS = 300000L;
    private static final long SUSPEND_TIME_UNKNOWN_ISSUE_MS = 1000L;

    ConnectionAwareSenderFailureStrategy(ConnectivityDetector detector, NanoTimeProvider timeProvider) {
        ObjectsUtils.requireNonNull((Object)detector, (String)"detector cannot be null");
        ObjectsUtils.requireNonNull((Object)timeProvider, (String)"timeProvider cannot be null");
        this.detector = detector;
        this.timeProvider = timeProvider;
        this.detector.setNetworkRestoredSignal(new Runnable(){

            @Override
            public void run() {
                ConnectionAwareSenderFailureStrategy.this.resume();
            }
        });
        this.isSendingSuspended = false;
    }

    public ConnectionAwareSenderFailureStrategy(Context androidContext) {
        this(new ConnectivityDetector(androidContext), new SystemNanoTimeProvider());
    }

    public void updateContext(Context androidContext) {
        this.detector.updateContext(androidContext);
    }

    public SenderFailureStrategy.PayloadAction getAction(Payload payload, Response response) {
        NetworkStatus status = this.getNetworkStatus(response);
        return this.getAction(status);
    }

    public SenderFailureStrategy.PayloadAction getAction(Payload payload, Exception error) {
        NetworkStatus status = this.getNetworkStatus(error);
        return this.getAction(status);
    }

    public boolean isSendingSuspended() {
        if (this.isSendingSuspended && this.timeProvider.nanoTime() >= this.resumeTime) {
            this.resume();
        }
        return this.isSendingSuspended;
    }

    public void close() {
        this.detector.close();
    }

    private SenderFailureStrategy.PayloadAction getAction(NetworkStatus status) {
        switch (status) {
            case OK: {
                return SenderFailureStrategy.PayloadAction.NONE;
            }
            case NO_NETWORK: {
                this.suspend(300000L);
                return SenderFailureStrategy.PayloadAction.CAN_BE_RETRIED;
            }
            case UNKNOWN_NETWORK_ISSUE: {
                this.suspend(1000L);
                return SenderFailureStrategy.PayloadAction.CAN_BE_RETRIED;
            }
        }
        return SenderFailureStrategy.PayloadAction.NONE;
    }

    private void suspend(long suspendTimeMillis) {
        this.isSendingSuspended = true;
        this.resumeTime = this.timeProvider.nanoTime() + suspendTimeMillis * 1000000L;
    }

    private void resume() {
        this.isSendingSuspended = false;
    }

    private NetworkStatus getNetworkStatus(Response response) {
        if (this.isSuccessfulResult(response.getResult())) {
            return NetworkStatus.OK;
        }
        if (this.isSuspiciousHTTPStatus(response.getStatus())) {
            return this.detector.isNetworkAvailable() ? NetworkStatus.OK : NetworkStatus.NO_NETWORK;
        }
        return NetworkStatus.OK;
    }

    private boolean isSuccessfulResult(Result result) {
        if (result == null) {
            return false;
        }
        return !result.isError();
    }

    private NetworkStatus getNetworkStatus(Throwable error) {
        if (error == null) {
            return NetworkStatus.OK;
        }
        if (error instanceof SocketException || error instanceof UnknownHostException) {
            if (this.detector.isNetworkAvailable()) {
                return NetworkStatus.UNKNOWN_NETWORK_ISSUE;
            }
            return NetworkStatus.NO_NETWORK;
        }
        if (error.getCause() != null) {
            return this.getNetworkStatus(error.getCause());
        }
        return NetworkStatus.OK;
    }

    private boolean isSuspiciousHTTPStatus(int status) {
        return status == 301 || status == 302 || status == 307 || status == 308;
    }

    static class SystemNanoTimeProvider
    implements NanoTimeProvider {
        SystemNanoTimeProvider() {
        }

        @Override
        public long nanoTime() {
            return System.nanoTime();
        }
    }

    static interface NanoTimeProvider {
        public long nanoTime();
    }

    private static enum NetworkStatus {
        OK,
        NO_NETWORK,
        UNKNOWN_NETWORK_ISSUE;

    }
}

