/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.android.notifier.sender;

import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Process;
import android.util.Log;
import com.rollbar.notifier.util.ObjectsUtils;
import java.io.Closeable;

class ConnectivityDetector
implements Closeable {
    private final Object receiverLock = new Object();
    private boolean hasNetworkStatePermission;
    private volatile NetworkUpBroadcastReceiver receiver;
    private Context androidContext;
    private Runnable networkRestoredSignal;

    ConnectivityDetector(Context androidContext) {
        this.updateContext(androidContext);
    }

    public void setNetworkRestoredSignal(Runnable networkRestoredSignal) {
        this.networkRestoredSignal = networkRestoredSignal;
    }

    public void updateContext(Context androidContext) {
        ObjectsUtils.requireNonNull((Object)androidContext, (String)"androidContext cannot be null");
        this.unregisterNetworkStateReceiver();
        this.androidContext = androidContext;
        this.hasNetworkStatePermission = this.hasNetworkStatePermission();
        if (this.hasNetworkStatePermission) {
            this.registerNetworkStateReceiver();
        } else {
            String message = "This application is missing the android.permission.ACCESS_NETWORK_STATE permission. The Rollbar notifier will *not* be able to detect when the network is unavailable.";
            Log.w((String)ConnectivityDetector.class.getCanonicalName(), (String)message);
        }
    }

    @Override
    public void close() {
        this.unregisterNetworkStateReceiver();
    }

    boolean isNetworkAvailable() {
        if (!this.hasNetworkStatePermission) {
            return true;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)this.androidContext.getSystemService("connectivity");
        if (connectivityManager == null) {
            return true;
        }
        NetworkInfo network = connectivityManager.getActiveNetworkInfo();
        if (network == null) {
            return false;
        }
        return network.isAvailable() && network.isConnected();
    }

    private boolean hasNetworkStatePermission() {
        String permission2 = "android.permission.ACCESS_NETWORK_STATE";
        int res = this.androidContext.checkPermission(permission2, Process.myPid(), Process.myUid());
        return res == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNetworkStateReceiver() {
        Activity targetActivity;
        Object object = this.receiverLock;
        synchronized (object) {
            this.unregisterNetworkStateReceiver();
            this.receiver = new NetworkUpBroadcastReceiver();
        }
        this.androidContext.registerReceiver((BroadcastReceiver)this.receiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        if (this.androidContext instanceof Activity && (targetActivity = (Activity)this.androidContext).getApplication() != null) {
            ReceiverActivityCallback activityCallback = new ReceiverActivityCallback(targetActivity);
            targetActivity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)activityCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterNetworkStateReceiver() {
        Object object = this.receiverLock;
        synchronized (object) {
            if (this.receiver != null && this.androidContext != null) {
                this.androidContext.unregisterReceiver((BroadcastReceiver)this.receiver);
                this.receiver = null;
            }
        }
    }

    private class ReceiverActivityCallback
    implements Application.ActivityLifecycleCallbacks {
        private final Activity targetActivity;

        public ReceiverActivityCallback(Activity targetActivity) {
            this.targetActivity = targetActivity;
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
            if (activity == this.targetActivity) {
                ConnectivityDetector.this.unregisterNetworkStateReceiver();
            }
        }
    }

    private class NetworkUpBroadcastReceiver
    extends BroadcastReceiver {
        private NetworkUpBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            Runnable signal;
            if (ConnectivityDetector.this.isNetworkAvailable() && (signal = ConnectivityDetector.this.networkRestoredSignal) != null) {
                signal.run();
            }
        }
    }
}

