/*
 * Decompiled with CFR 0.152.
 */
package com.roger.psdloadingview.library.animate;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Handler;
import android.os.Message;
import android.view.animation.AccelerateInterpolator;
import com.roger.psdloadingview.library.PsdLoadingView;
import com.roger.psdloadingview.library.animate.BaseAnimate;

public class EatAnimate
extends BaseAnimate {
    private Paint mEyePaint;
    private float eyeProgress;
    private boolean isBegining = false;
    private boolean isLeftTurn = true;
    private boolean isShowamaze = false;
    private int amazeTimes = 0;
    float radius;
    float left;
    float right;
    float top;
    float bottom;
    float centerX;
    float centerY;
    float eyeX;
    float eyeY;
    float startAngle;
    float sweepAngle;
    private Handler mHandler;

    @Override
    public void init(PsdLoadingView mPsdLoadingView) {
        super.init(mPsdLoadingView);
        this.mEyePaint = new Paint(1);
        this.mEyePaint.setColor(-1);
        this.mEyePaint.setStyle(Paint.Style.FILL);
        this.setDuration(this.duration * 6);
        final PsdLoadingView psdLoadingView = mPsdLoadingView;
        this.mHandler = new Handler(){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                EatAnimate.this.amazeTimes++;
                if (EatAnimate.this.amazeTimes % 2 == 0) {
                    EatAnimate.this.isShowamaze = true;
                } else {
                    EatAnimate.this.isShowamaze = false;
                }
                psdLoadingView.invalidate();
                if (EatAnimate.this.amazeTimes >= 5) {
                    EatAnimate.this.amazeTimes = 0;
                    EatAnimate.this.valueAnimator.resume();
                } else if (EatAnimate.this.amazeTimes == 4) {
                    EatAnimate.this.mHandler.sendEmptyMessageDelayed(0, 300L);
                } else {
                    EatAnimate.this.mHandler.sendEmptyMessageDelayed(0, 100L);
                }
            }
        };
    }

    @Override
    public void startLoading() {
        this.isLeftTurn = true;
        super.startLoading();
        this.isBegining = true;
        this.radius = (float)this.mPsdLoadingView.getHeight() / 8.0f;
        this.centerY = (float)this.mPsdLoadingView.getHeight() / 2.0f;
        this.top = this.centerY - this.radius;
        this.bottom = this.centerY + this.radius;
        this.valueAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
                EatAnimate.this.isLeftTurn = !EatAnimate.this.isLeftTurn;
            }
        });
        ValueAnimator eyeAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f}).setDuration(100L);
        eyeAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        eyeAnimator.setRepeatCount(-1);
        eyeAnimator.setRepeatMode(2);
        eyeAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                EatAnimate.this.eyeProgress = ((Float)animation.getAnimatedValue()).floatValue();
            }
        });
        eyeAnimator.start();
    }

    @Override
    public void stopLoading() {
        super.stopLoading();
    }

    @Override
    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.isStop) {
            this.drawEater(canvas);
            if (this.distance * 2.0f >= this.centerX && this.isBegining) {
                this.isBegining = false;
                this.valueAnimator.pause();
                this.isShowamaze = true;
                this.mHandler.sendEmptyMessageDelayed(0, 100L);
            }
            if (this.isShowamaze) {
                this.drawAmazed(canvas);
            }
            if (this.isBegining) {
                for (int i = 0; i < this.textLength; ++i) {
                    float moveX = ((float)i + 0.5f) * this.distance;
                    if (!(moveX < this.centerX)) continue;
                    canvas.drawText(DOT + "", 0, 1, moveX, (float)this.startY, this.mPaint);
                }
            } else {
                float moveX = this.isLeftTurn ? this.centerX - this.radius - this.distance * 1.0f : this.centerX + this.radius;
                canvas.drawText(DOT + "", 0, 1, moveX, (float)this.startY, this.mPaint);
            }
        }
    }

    private void drawEater(Canvas canvas) {
        this.centerX = (float)this.mPsdLoadingView.getWidth() * 1.4f * (1.0f - this.progress) - (float)this.mPsdLoadingView.getWidth() * 0.2f;
        this.left = this.centerX - this.radius;
        this.right = this.centerX + this.radius;
        RectF oval2 = new RectF(this.left, this.top, this.right, this.bottom);
        this.startAngle = 225.0f - this.eyeProgress * 30.0f;
        this.sweepAngle = 270.0f + this.eyeProgress * 60.0f;
        this.eyeX = this.centerX + this.radius / 2.0f;
        this.eyeY = this.centerY - this.radius / 2.0f;
        if (!this.isLeftTurn) {
            this.startAngle = 45.0f - this.eyeProgress * 25.0f;
            this.eyeX = this.centerX - this.radius / 2.0f;
        }
        canvas.drawArc(oval2, this.startAngle, this.sweepAngle, true, this.mPaint);
        canvas.drawCircle(this.eyeX, this.eyeY, this.radius / 5.0f, this.mEyePaint);
    }

    private void drawAmazed(Canvas canvas) {
        float amazedX = this.centerX - this.radius - this.distance * 0.75f;
        canvas.drawCircle(amazedX, this.centerY - this.radius, this.radius / 7.0f, this.mPaint);
        canvas.drawCircle(amazedX + this.radius / 2.0f, this.centerY - this.radius / 2.0f, this.radius / 7.0f, this.mPaint);
        canvas.drawCircle(amazedX - this.radius / 2.0f, this.centerY - this.radius / 2.0f, this.radius / 7.0f, this.mPaint);
    }

    @Override
    protected boolean whenStop() {
        return !this.isLoading && (this.progress <= 0.001f || this.progress >= 0.999f);
    }
}

