/*
 * Decompiled with CFR 0.152.
 */
package com.roger.psdloadingview.library;

import android.content.Context;
import android.graphics.Canvas;
import android.text.Editable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.EditText;
import com.roger.psdloadingview.library.animate.BaseAnimate;
import com.roger.psdloadingview.library.animate.IAnimate;
import com.roger.psdloadingview.library.animate.TranslationX2Animate;

public class PsdLoadingView
extends EditText {
    private IAnimate mIAnimate = new TranslationX2Animate();

    public PsdLoadingView(Context context) {
        super(context);
        this.init(this.mIAnimate);
    }

    public PsdLoadingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(this.mIAnimate);
    }

    public PsdLoadingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(this.mIAnimate);
    }

    public void init(IAnimate mIAnimate) {
        if (this.mIAnimate.isLoading()) {
            return;
        }
        this.mIAnimate = mIAnimate;
        this.mIAnimate.init(this);
    }

    public void startLoading() {
        if (this.mIAnimate.isLoading()) {
            return;
        }
        this.mIAnimate.startLoading();
    }

    public void stopLoading() {
        this.mIAnimate.stopLoading();
    }

    public void setDuration(int duration) {
        this.mIAnimate.setDuration(duration);
    }

    public Editable getTextDuringLoading() {
        BaseAnimate baseAnimate = (BaseAnimate)this.mIAnimate;
        if (baseAnimate.isLoading) {
            return baseAnimate.text;
        }
        return super.getText();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mIAnimate.onDraw(canvas);
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == 8 || visibility == 4) {
            this.mIAnimate.onVisibilityChanged(false);
        } else {
            this.mIAnimate.onVisibilityChanged(true);
        }
    }
}

