/*
 * Decompiled with CFR 0.152.
 */
package com.roger.psdloadingview.library.animate;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Editable;
import android.text.TextUtils;
import android.util.Log;
import android.view.animation.AccelerateDecelerateInterpolator;
import com.roger.psdloadingview.library.PsdLoadingView;
import com.roger.psdloadingview.library.animate.IAnimate;

public class BaseAnimate
implements IAnimate {
    protected static char DOT = (char)8226;
    protected PsdLoadingView mPsdLoadingView;
    protected Paint mPaint;
    protected int textLength;
    protected int startY = 0;
    protected float distance = 0.0f;
    protected float progress;
    public Editable text;
    protected CharSequence hint;
    public boolean isLoading;
    protected boolean isStop = true;
    protected int duration = 500;
    ValueAnimator valueAnimator;

    @Override
    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Override
    public void init(PsdLoadingView mPsdLoadingView) {
        this.mPsdLoadingView = mPsdLoadingView;
        this.mPaint = new Paint(1);
        this.mPaint.setColor(mPsdLoadingView.getCurrentTextColor());
        this.mPaint.setStyle(Paint.Style.FILL);
        mPsdLoadingView.setInputType(129);
    }

    @Override
    public void startLoading() {
        this.textLength = this.mPsdLoadingView.getText().length();
        this.startY = this.mPsdLoadingView.getBaseline();
        if (TextUtils.isEmpty((CharSequence)this.mPsdLoadingView.getText().toString())) {
            return;
        }
        this.isLoading = true;
        this.isStop = false;
        this.distance = this.mPsdLoadingView.getPaint().measureText(this.mPsdLoadingView.getText().charAt(0) + "");
        this.mPaint.setTextSize(this.mPsdLoadingView.getTextSize());
        this.text = this.mPsdLoadingView.getText();
        this.hint = this.mPsdLoadingView.getHint();
        this.mPsdLoadingView.setMinWidth(this.mPsdLoadingView.getWidth());
        this.mPsdLoadingView.setText("");
        this.mPsdLoadingView.setHint("");
        this.mPsdLoadingView.setCursorVisible(false);
        this.valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f}).setDuration((long)this.duration);
        this.valueAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.valueAnimator.setRepeatCount(-1);
        this.valueAnimator.setRepeatMode(2);
        this.valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BaseAnimate.this.progress = ((Float)animation.getAnimatedValue()).floatValue();
                BaseAnimate.this.mPsdLoadingView.invalidate();
                if (BaseAnimate.this.whenStop()) {
                    BaseAnimate.this.valueAnimator.cancel();
                    BaseAnimate.this.isStop = true;
                    BaseAnimate.this.mPsdLoadingView.setHint(BaseAnimate.this.hint);
                    BaseAnimate.this.mPsdLoadingView.setText((CharSequence)BaseAnimate.this.text);
                    BaseAnimate.this.mPsdLoadingView.setCursorVisible(true);
                    BaseAnimate.this.mPsdLoadingView.setSelection(BaseAnimate.this.mPsdLoadingView.getText().length());
                }
            }
        });
        this.valueAnimator.start();
    }

    @Override
    public void stopLoading() {
        this.isLoading = false;
    }

    @Override
    public void onDraw(Canvas canvas) {
    }

    @Override
    public void onVisibilityChanged(boolean isVisibiable) {
        Log.i((String)"Tag", (String)("isVisibiable:" + isVisibiable));
        if (!this.isLoading) {
            return;
        }
        if (isVisibiable) {
            this.valueAnimator.resume();
        } else {
            this.valueAnimator.pause();
        }
    }

    protected boolean whenStop() {
        return !this.isLoading && this.progress <= 0.001f;
    }
}

