/*
 * Decompiled with CFR 0.152.
 */
package com.rodolfonavalon.shaperipplelibrary;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.rodolfonavalon.shaperipplelibrary.R;
import com.rodolfonavalon.shaperipplelibrary.data.ShapeRippleEntry;
import com.rodolfonavalon.shaperipplelibrary.model.BaseShapeRipple;
import com.rodolfonavalon.shaperipplelibrary.model.Circle;
import com.rodolfonavalon.shaperipplelibrary.util.ShapePulseUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class ShapeRipple
extends View {
    private static final String TAG = ShapeRipple.class.getSimpleName();
    private static final int DEFAULT_RIPPLE_DURATION = 1500;
    private static final int EXTRA_RIPPLES = 1;
    private static final float DEFAULT_RIPPLE_INTERVAL_FACTOR = 1.0f;
    private int rippleColor;
    private int rippleFromColor;
    private int rippleToColor;
    private int rippleDuration;
    private int rippleStrokeWidth;
    private float rippleInterval;
    private float rippleIntervalCalculated;
    private float rippleIntervalFactor;
    private int viewWidth;
    private int viewHeight;
    private int maxRippleRadius;
    private float lastShapeFractionValue = 0.0f;
    private boolean enableColorTransition = true;
    private boolean enableSingleRipple = false;
    private boolean enableRandomPosition = false;
    private boolean enableRandomColor = false;
    private List<ShapeRippleEntry> shapeRippleEntries;
    private List<Integer> rippleRandomColors;
    private ValueAnimator rippleValueAnimator;
    private Interpolator rippleInterpolator;
    private Random random;
    private BaseShapeRipple rippleShape;

    public ShapeRipple(Context context) {
        super(context);
        this.init(context, null);
    }

    public ShapeRipple(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ShapeRipple(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        this.shapeRippleEntries = new ArrayList<ShapeRippleEntry>();
        this.random = new Random();
        this.rippleShape = new Circle();
        this.rippleColor = Color.parseColor((String)"#FFF44336");
        this.rippleFromColor = Color.parseColor((String)"#FFF44336");
        this.rippleToColor = Color.parseColor((String)"#00FFFFFF");
        this.rippleStrokeWidth = this.getResources().getDimensionPixelSize(R.dimen.default_stroke_width);
        this.rippleRandomColors = ShapePulseUtil.generateRandomColours(this.getContext());
        this.rippleDuration = 1500;
        this.rippleIntervalFactor = 1.0f;
        this.rippleInterpolator = new LinearInterpolator();
        if (attrs != null) {
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.ConnectingRipple, 0, 0);
            try {
                this.rippleColor = ta.getColor(R.styleable.ConnectingRipple_ripple_color, Color.parseColor((String)"#FFF44336"));
                this.rippleFromColor = ta.getColor(R.styleable.ConnectingRipple_ripple_from_color, Color.parseColor((String)"#FFF44336"));
                this.rippleToColor = ta.getColor(R.styleable.ConnectingRipple_ripple_to_color, Color.parseColor((String)"#00FFFFFF"));
                this.setRippleDuration(ta.getInteger(R.styleable.ConnectingRipple_ripple_duration, 1500));
                this.enableColorTransition = ta.getBoolean(R.styleable.ConnectingRipple_enable_color_transition, true);
                this.enableSingleRipple = ta.getBoolean(R.styleable.ConnectingRipple_enable_single_ripple, false);
                this.enableRandomPosition = ta.getBoolean(R.styleable.ConnectingRipple_enable_random_position, false);
                this.setEnableRandomColor(ta.getBoolean(R.styleable.ConnectingRipple_enable_random_color, false));
                this.setRippleStrokeWidth(ta.getDimensionPixelSize(R.styleable.ConnectingRipple_ripple_stroke_width, this.getResources().getDimensionPixelSize(R.dimen.default_stroke_width)));
            }
            finally {
                ta.recycle();
            }
        }
        this.start(this.rippleDuration);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (ShapeRippleEntry shapeRippleEntry : this.shapeRippleEntries) {
            if (!shapeRippleEntry.isRender()) continue;
            shapeRippleEntry.getBaseShapeRipple().draw(canvas, shapeRippleEntry.getX(), shapeRippleEntry.getY(), shapeRippleEntry.getRadiusSize(), shapeRippleEntry.getChangingColorValue(), this.shapeRippleEntries.size() - 1 - shapeRippleEntry.getRippleIndex());
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.viewWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.viewHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.maxRippleRadius = Math.min(this.viewWidth, this.viewHeight) / 2 - this.rippleStrokeWidth / 2;
        this.rippleIntervalCalculated = (float)this.rippleStrokeWidth / (float)this.maxRippleRadius;
        this.rippleInterval = this.rippleIntervalCalculated * this.rippleIntervalFactor;
        this.initializeEntries(this.rippleShape);
        this.rippleShape.setWidth(this.viewWidth);
        this.rippleShape.setHeight(this.viewHeight);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stop();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.stop();
    }

    private void initializeEntries(BaseShapeRipple shapeRipple) {
        shapeRipple.setStrokeWidth(this.rippleStrokeWidth);
        if (this.viewWidth == 0 && this.viewHeight == 0) {
            return;
        }
        this.shapeRippleEntries.clear();
        int maxNumberOfRipples = this.maxRippleRadius / this.rippleStrokeWidth;
        for (int i = 0; i < maxNumberOfRipples + 1; ++i) {
            ShapeRippleEntry shapeRippleEntry = new ShapeRippleEntry(shapeRipple);
            shapeRippleEntry.setX(this.enableRandomPosition ? this.random.nextInt(this.viewWidth) : this.viewWidth / 2);
            shapeRippleEntry.setY(this.enableRandomPosition ? this.random.nextInt(this.viewHeight) : this.viewHeight / 2);
            shapeRippleEntry.setFractionValue(-(this.rippleInterval * (float)i));
            shapeRippleEntry.setRippleIndex(i);
            if (this.enableRandomColor) {
                shapeRippleEntry.setOriginalColorValue(this.rippleRandomColors.get(this.random.nextInt(this.rippleRandomColors.size())));
            } else {
                shapeRippleEntry.setOriginalColorValue(this.rippleColor);
            }
            this.shapeRippleEntries.add(shapeRippleEntry);
            if (this.enableSingleRipple) break;
        }
    }

    private void reconfigureEntries() {
        if (this.viewWidth == 0 && this.viewHeight == 0 && (this.shapeRippleEntries == null || this.shapeRippleEntries.size() == 0)) {
            return;
        }
        this.rippleShape.setStrokeWidth(this.rippleStrokeWidth);
        for (ShapeRippleEntry shapeRippleEntry : this.shapeRippleEntries) {
            if (this.enableRandomColor) {
                shapeRippleEntry.setOriginalColorValue(this.rippleRandomColors.get(this.random.nextInt(this.rippleRandomColors.size())));
            } else {
                shapeRippleEntry.setOriginalColorValue(this.rippleColor);
            }
            shapeRippleEntry.setBaseShapeRipple(this.rippleShape);
        }
    }

    private void start(int millis) {
        this.rippleValueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.rippleValueAnimator.setDuration((long)millis);
        this.rippleValueAnimator.setRepeatMode(-1);
        this.rippleValueAnimator.setRepeatCount(-1);
        this.rippleValueAnimator.setInterpolator((TimeInterpolator)this.rippleInterpolator);
        this.rippleValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ShapeRipple.this.render((Float)animation.getAnimatedValue());
            }
        });
        this.rippleValueAnimator.start();
    }

    private void render(Float fractionValue) {
        if (this.shapeRippleEntries.size() == 0) {
            return;
        }
        float shapeFractionValue = fractionValue.floatValue();
        ShapeRippleEntry firstEntry = this.shapeRippleEntries.get(0);
        float firstEntryFractionValue = firstEntry.getFractionValue() + Math.max(shapeFractionValue - this.lastShapeFractionValue, 0.0f);
        if (firstEntryFractionValue >= 1.0f) {
            ShapeRippleEntry removedEntry = this.shapeRippleEntries.remove(0);
            removedEntry.reset();
            removedEntry.setOriginalColorValue(this.enableRandomColor ? this.rippleRandomColors.get(this.random.nextInt(this.rippleRandomColors.size())) : this.rippleColor);
            this.shapeRippleEntries.add(removedEntry);
            firstEntry = this.shapeRippleEntries.get(0);
            firstEntryFractionValue = firstEntry.getFractionValue() + Math.max(shapeFractionValue - this.lastShapeFractionValue, 0.0f);
            firstEntry.setX(this.enableRandomPosition ? this.random.nextInt(this.viewWidth) : this.viewWidth / 2);
            firstEntry.setY(this.enableRandomPosition ? this.random.nextInt(this.viewHeight) : this.viewHeight / 2);
            if (this.enableSingleRipple) {
                firstEntryFractionValue = 0.0f;
            }
        }
        int index = 0;
        for (ShapeRippleEntry shapeRippleEntry : this.shapeRippleEntries) {
            shapeRippleEntry.setRippleIndex(index);
            float currentShapeFractionValue = firstEntryFractionValue - this.rippleInterval * (float)index;
            if (!(currentShapeFractionValue >= 0.0f)) {
                shapeRippleEntry.setRender(false);
                continue;
            }
            shapeRippleEntry.setRender(true);
            if (index == 0) {
                shapeRippleEntry.setFractionValue(firstEntryFractionValue);
            } else {
                shapeRippleEntry.setFractionValue(firstEntryFractionValue > 0.0f ? currentShapeFractionValue : currentShapeFractionValue + 1.0f);
            }
            shapeRippleEntry.setChangingColorValue(this.enableColorTransition ? ShapePulseUtil.evaluateTransitionColor(currentShapeFractionValue, shapeRippleEntry.getOriginalColorValue(), this.rippleToColor) : this.rippleColor);
            shapeRippleEntry.setRadiusSize((float)this.maxRippleRadius * currentShapeFractionValue);
            ++index;
        }
        this.lastShapeFractionValue = shapeFractionValue;
        this.invalidate();
    }

    private void stop() {
        if (this.rippleValueAnimator != null) {
            this.rippleValueAnimator.cancel();
            this.rippleValueAnimator.end();
            this.rippleValueAnimator.removeAllUpdateListeners();
            this.rippleValueAnimator.removeAllListeners();
            this.rippleValueAnimator = null;
        }
        if (this.shapeRippleEntries != null) {
            this.shapeRippleEntries.clear();
            this.invalidate();
        }
    }

    public void startRipple() {
        this.stop();
        this.initializeEntries(this.rippleShape);
        this.start(this.rippleDuration);
    }

    public void stopRipple() {
        this.stop();
    }

    public float getRippleInterval() {
        return this.rippleInterval;
    }

    public boolean isEnableColorTransition() {
        return this.enableColorTransition;
    }

    public boolean isEnableSingleRipple() {
        return this.enableSingleRipple;
    }

    public boolean isEnableRandomPosition() {
        return this.enableRandomPosition;
    }

    public int getRippleStrokeWidth() {
        return this.rippleStrokeWidth;
    }

    public int getRippleColor() {
        return this.rippleColor;
    }

    public int getRippleFromColor() {
        return this.rippleFromColor;
    }

    public int getRippleToColor() {
        return this.rippleToColor;
    }

    public int getRippleDuration() {
        return this.rippleDuration;
    }

    public Interpolator getRippleInterpolator() {
        return this.rippleInterpolator;
    }

    public boolean isEnableRandomColor() {
        return this.enableRandomColor;
    }

    public BaseShapeRipple getRippleShape() {
        return this.rippleShape;
    }

    public List<Integer> getRippleRandomColors() {
        return this.rippleRandomColors;
    }

    public void setRippleInterval(float rippleInterval) {
        if (rippleInterval > 2.0f || rippleInterval <= 0.0f) {
            throw new IllegalArgumentException("Ripple Interval must be <= 2f and > 0");
        }
        this.rippleIntervalFactor = rippleInterval;
        this.rippleInterval = this.rippleIntervalCalculated * rippleInterval;
    }

    public void setEnableColorTransition(boolean enableColorTransition) {
        this.enableColorTransition = enableColorTransition;
    }

    public void setEnableSingleRipple(boolean enableSingleRipple) {
        this.enableSingleRipple = enableSingleRipple;
        this.initializeEntries(this.rippleShape);
    }

    public void setRippleStrokeWidth(int rippleStrokeWidth) {
        if (rippleStrokeWidth <= 0) {
            throw new IllegalArgumentException("Ripple duration must be > 0");
        }
        this.rippleStrokeWidth = rippleStrokeWidth;
    }

    public void setRippleColor(int rippleColor) {
        this.setRippleColor(rippleColor, true);
    }

    public void setRippleColor(int rippleColor, boolean instant) {
        this.rippleColor = rippleColor;
        if (instant) {
            this.reconfigureEntries();
        }
    }

    public void setRippleFromColor(int rippleFromColor) {
        this.setRippleFromColor(rippleFromColor, true);
    }

    public void setRippleFromColor(int rippleFromColor, boolean instant) {
        this.rippleFromColor = rippleFromColor;
        if (instant) {
            this.reconfigureEntries();
        }
    }

    public void setRippleToColor(int rippleToColor) {
        this.setRippleToColor(rippleToColor, true);
    }

    public void setRippleToColor(int rippleToColor, boolean instant) {
        this.rippleToColor = rippleToColor;
        if (instant) {
            this.reconfigureEntries();
        }
    }

    public void setRippleDuration(int millis) {
        if (this.rippleDuration <= 0) {
            throw new IllegalArgumentException("Ripple duration must be > 0");
        }
        this.rippleDuration = millis;
        if (this.rippleValueAnimator != null) {
            this.rippleValueAnimator.setDuration((long)this.rippleDuration);
        }
    }

    public void setEnableRandomPosition(boolean enableRandomPosition) {
        this.enableRandomPosition = enableRandomPosition;
        this.initializeEntries(this.rippleShape);
    }

    public void setRippleInterpolator(Interpolator rippleInterpolator) {
        if (rippleInterpolator == null) {
            throw new NullPointerException("Ripple interpolator in null");
        }
        this.rippleInterpolator = rippleInterpolator;
    }

    public void setEnableRandomColor(boolean enableRandomColor) {
        this.enableRandomColor = enableRandomColor;
        this.reconfigureEntries();
    }

    public void setRippleShape(BaseShapeRipple rippleShape) {
        this.rippleShape = rippleShape;
        this.reconfigureEntries();
    }

    public void setRippleRandomColors(List<Integer> rippleRandomColors) {
        if (rippleRandomColors == null) {
            throw new NullPointerException("List of colors cannot be null");
        }
        if (rippleRandomColors.size() == 0) {
            throw new IllegalArgumentException("List of color cannot be empty");
        }
        this.rippleRandomColors.clear();
        this.rippleRandomColors = rippleRandomColors;
        this.reconfigureEntries();
    }
}

