/*
 * Decompiled with CFR 0.152.
 */
package com.rocketfuel.sdbc.sqlserver.jdbc;

import com.rocketfuel.sdbc.base.jdbc.Row;
import com.rocketfuel.sdbc.base.jdbc.UpdatableRow;
import com.rocketfuel.sdbc.base.jdbc.Updater;
import com.rocketfuel.sdbc.sqlserver.jdbc.HierarchyId;
import com.rocketfuel.sdbc.sqlserver.jdbc.HierarchyNode;
import com.rocketfuel.sdbc.sqlserver.jdbc.SqlServerSuite;
import com.rocketfuel.sdbc.sqlserver.jdbc.UpdatesSpec$;
import com.rocketfuel.sdbc.sqlserver.jdbc.package$;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.UUID;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Tag;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.math.BigDecimal;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

@ScalaSignature(bytes="\u0006\u0001e3A!\u0001\u0002\u0001\u001b\tYQ\u000b\u001d3bi\u0016\u001c8\u000b]3d\u0015\t\u0019A!\u0001\u0003kI\n\u001c'BA\u0003\u0007\u0003%\u0019\u0018\u000f\\:feZ,'O\u0003\u0002\b\u0011\u0005!1\u000f\u001a2d\u0015\tI!\"\u0001\u0006s_\u000e\\W\r\u001e4vK2T\u0011aC\u0001\u0004G>l7\u0001A\n\u0003\u00019\u0001\"a\u0004\t\u000e\u0003\tI!!\u0005\u0002\u0003\u001dM\u000bHnU3sm\u0016\u00148+^5uK\")1\u0003\u0001C\u0001)\u00051A(\u001b8jiz\"\u0012!\u0006\t\u0003\u001f\u0001AQa\u0006\u0001\u0005\u0002a\t!\u0002^3tiV\u0003H-\u0019;f+\tIR\u0006\u0006\u0002\u001b!R\u00111D\u0014\u000b\u000391#B!H\u00127\u007fA\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t!QK\\5u\u0011\u0015!c\u0003q\u0001&\u0003\u0011\u0019G/Y4\u0011\u0007\u0019J3&D\u0001(\u0015\tAs$A\u0004sK\u001adWm\u0019;\n\u0005):#\u0001C\"mCN\u001cH+Y4\u0011\u00051jC\u0002\u0001\u0003\u0006]Y\u0011\ra\f\u0002\u0002)F\u0011\u0001g\r\t\u0003=EJ!AM\u0010\u0003\u000f9{G\u000f[5oOB\u0011a\u0004N\u0005\u0003k}\u00111!\u00118z\u0011\u00159d\u0003q\u00019\u0003\u001d)\b\u000fZ1uKJ\u00042!O\u001f,\u001b\u0005Q$BA\u0002<\u0015\tad!\u0001\u0003cCN,\u0017B\u0001 ;\u0005\u001d)\u0006\u000fZ1uKJDQ\u0001\u0011\fA\u0004\u0005\u000b\u0011bY8om\u0016\u0014H/\u001a:\u0011\ty\u0011EiK\u0005\u0003\u0007~\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0005\u0015CeBA\bG\u0013\t9%!A\u0004qC\u000e\\\u0017mZ3\n\u0005%S%a\u0001*po&\u00111J\u000f\u0002\u0005\t\nk5\u000bC\u0003N-\u0001\u00071&A\u0003bMR,'\u000fC\u0003P-\u0001\u00071&\u0001\u0004cK\u001a|'/\u001a\u0005\u0006#Z\u0001\rAU\u0001\tif\u0004XMT1nKB\u00111K\u0016\b\u0003=QK!!V\u0010\u0002\rA\u0013X\rZ3g\u0013\t9\u0006L\u0001\u0004TiJLgn\u001a\u0006\u0003+~\u0001")
public class UpdatesSpec
extends SqlServerSuite {
    public <T> void testUpdate(String typeName, T before, T after, ClassTag<T> ctag, Updater<T> updater, Function1<Row, T> converter) {
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Update ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ctag.runtimeClass().getName()})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function1)new Serializable(this, typeName, before, after, updater, converter){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UpdatesSpec $outer;
            private final String typeName$1;
            private final Object before$1;
            public final Object after$1;
            public final Updater updater$1;
            private final Function1 converter$1;

            public final void apply(Connection connection) {
                package$.MODULE$.Update().apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE tbl (id int identity PRIMARY KEY, v ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.typeName$1})), package$.MODULE$.Update().apply$default$2()).update(connection);
                package$.MODULE$.JdbcStringContextMethods(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO tbl (v) VALUES (", ")"}))).update((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.before$1}), package$.MODULE$.ParameterSetter()).update(connection);
                package$.MODULE$.JdbcStringContextMethods(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM tbl"}))).selectForUpdate((Seq)Nil$.MODULE$, package$.MODULE$.ParameterSetter()).iterator(connection).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testUpdate$1 $outer;

                    public final void apply(UpdatableRow row) {
                        row.update("v", this.$outer.after$1, this.$outer.updater$1);
                        row.updateRow();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Option maybeValue = package$.MODULE$.Select().apply("SELECT v FROM tbl", package$.MODULE$.Select().apply$default$2(), this.converter$1).option(connection);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(maybeValue.nonEmpty(), "maybeValue.nonEmpty");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                this.$outer.assertResult(new Some(this.after$1), maybeValue);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.typeName$1 = typeName$1;
                this.before$1 = before$1;
                this.after$1 = after$1;
                this.updater$1 = updater$1;
                this.converter$1 = converter$1;
            }
        });
    }

    public UpdatesSpec() {
        this.testUpdate("bigint", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToLong((long)2L), ClassTag$.MODULE$.Long(), package$.MODULE$.LongUpdater(), package$.MODULE$.GetterToRowConverter(package$.MODULE$.LongGetter()));
        this.testUpdate("int", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), ClassTag$.MODULE$.Int(), package$.MODULE$.IntUpdater(), package$.MODULE$.GetterToRowConverter(package$.MODULE$.IntGetter()));
        this.testUpdate("smallint", BoxesRunTime.boxToShort((short)((short)1)), BoxesRunTime.boxToShort((short)((short)2)), ClassTag$.MODULE$.Short(), package$.MODULE$.ShortUpdater(), package$.MODULE$.GetterToRowConverter(package$.MODULE$.ShortGetter()));
        this.testUpdate("tinyint", BoxesRunTime.boxToByte((byte)((byte)1)), BoxesRunTime.boxToByte((byte)((byte)2)), ClassTag$.MODULE$.Byte(), package$.MODULE$.ByteUpdater(), package$.MODULE$.GetterToRowConverter(package$.MODULE$.ByteGetter()));
        this.testUpdate("float", BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToDouble((double)2.0), ClassTag$.MODULE$.Double(), package$.MODULE$.DoubleUpdater(), package$.MODULE$.GetterToRowConverter(package$.MODULE$.DoubleGetter()));
        this.testUpdate("real", BoxesRunTime.boxToFloat((float)1.0f), BoxesRunTime.boxToFloat((float)2.0f), ClassTag$.MODULE$.Float(), package$.MODULE$.FloatUpdater(), package$.MODULE$.GetterToRowConverter(package$.MODULE$.FloatGetter()));
        this.testUpdate("bigint", Predef$.MODULE$.long2Long(1L), Predef$.MODULE$.long2Long(2L), ClassTag$.MODULE$.apply(Long.class), package$.MODULE$.BoxedLongUpdater(), package$.MODULE$.GetterToRowConverter(package$.MODULE$.BoxedLongGetter()));
        this.testUpdate("int", Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), ClassTag$.MODULE$.apply(Integer.class), package$.MODULE$.BoxedIntUpdater(), package$.MODULE$.GetterToRowConverter(package$.MODULE$.BoxedIntegerGetter()));
        this.testUpdate("smallint", Predef$.MODULE$.short2Short((short)1), Predef$.MODULE$.short2Short((short)2), ClassTag$.MODULE$.apply(Short.class), package$.MODULE$.BoxedShortUpdater(), package$.MODULE$.GetterToRowConverter(package$.MODULE$.BoxedShortGetter()));
        this.testUpdate("tinyint", Predef$.MODULE$.byte2Byte((byte)1), Predef$.MODULE$.byte2Byte((byte)2), ClassTag$.MODULE$.apply(Byte.class), package$.MODULE$.BoxedByteUpdater(), package$.MODULE$.GetterToRowConverter(package$.MODULE$.BoxedByteGetter()));
        this.testUpdate("float", Predef$.MODULE$.double2Double(1.0), Predef$.MODULE$.double2Double(2.0), ClassTag$.MODULE$.apply(Double.class), package$.MODULE$.BoxedDoubleUpdater(), package$.MODULE$.GetterToRowConverter(package$.MODULE$.BoxedDoubleGetter()));
        this.testUpdate("real", Predef$.MODULE$.float2Float(1.0f), Predef$.MODULE$.float2Float(2.0f), ClassTag$.MODULE$.apply(Float.class), package$.MODULE$.BoxedFloatUpdater(), package$.MODULE$.GetterToRowConverter(package$.MODULE$.BoxedFloatGetter()));
        this.testUpdate("varbinary(max)", ByteVector$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}), (Integral)Numeric.IntIsIntegral$.MODULE$), ByteVector$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6}), (Integral)Numeric.IntIsIntegral$.MODULE$), ClassTag$.MODULE$.apply(ByteVector.class), package$.MODULE$.ByteVectorUpdater(), package$.MODULE$.GetterToRowConverter(package$.MODULE$.ByteVectorGetter()));
        this.testUpdate("decimal", scala.package$.MODULE$.BigDecimal().apply(3), scala.package$.MODULE$.BigDecimal().apply("500"), ClassTag$.MODULE$.apply(BigDecimal.class), package$.MODULE$.ScalaBigDecimalUpdater(), package$.MODULE$.GetterToRowConverter(package$.MODULE$.ScalaBigDecimalGetter()));
        this.testUpdate("datetime2", new Timestamp(0L), Timestamp.from(Instant.now()), ClassTag$.MODULE$.apply(Timestamp.class), package$.MODULE$.TimestampUpdater(), package$.MODULE$.GetterToRowConverter(package$.MODULE$.TimestampGetter()));
        this.testUpdate("date", new Date(0L), Date.valueOf(LocalDate.now()), ClassTag$.MODULE$.apply(Date.class), package$.MODULE$.DateUpdater(), package$.MODULE$.GetterToRowConverter(package$.MODULE$.DateGetter()));
        this.testUpdate("time", new Time(0L), Time.valueOf(LocalTime.now()), ClassTag$.MODULE$.apply(Time.class), package$.MODULE$.TimeUpdater(), package$.MODULE$.GetterToRowConverter(package$.MODULE$.TimeGetter()));
        this.testUpdate("datetime2", Instant.ofEpochMilli(0L), Instant.now(), ClassTag$.MODULE$.apply(Instant.class), package$.MODULE$.InstantUpdater(), package$.MODULE$.GetterToRowConverter(package$.MODULE$.InstantGetter()));
        this.testUpdate("date", LocalDate.ofEpochDay(0L), LocalDate.now(), ClassTag$.MODULE$.apply(LocalDate.class), package$.MODULE$.LocalDateUpdater(), package$.MODULE$.GetterToRowConverter(package$.MODULE$.LocalDateGetter()));
        this.testUpdate("time", LocalTime.of(0, 0, 0), LocalTime.now(), ClassTag$.MODULE$.apply(LocalTime.class), package$.MODULE$.LocalTimeUpdater(), package$.MODULE$.GetterToRowConverter(package$.MODULE$.LocalTimeGetter()));
        this.testUpdate("bit", BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)true), ClassTag$.MODULE$.Boolean(), package$.MODULE$.BooleanUpdater(), package$.MODULE$.GetterToRowConverter(package$.MODULE$.BooleanGetter()));
        this.testUpdate("varchar(max)", "hi", "bye", ClassTag$.MODULE$.apply(String.class), package$.MODULE$.StringUpdater(), package$.MODULE$.GetterToRowConverter((Function2)package$.MODULE$.StringGetter()));
        this.testUpdate("uniqueidentifier", UUID.randomUUID(), UUID.randomUUID(), ClassTag$.MODULE$.apply(UUID.class), package$.MODULE$.UUIDUpdater(), package$.MODULE$.GetterToRowConverter(package$.MODULE$.UUIDGetter()));
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Update HierarchyId"})).s((Seq)Nil$.MODULE$), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UpdatesSpec $outer;

            public final void apply(Connection connection) {
                HierarchyId before = new HierarchyId((Seq)Nil$.MODULE$);
                HierarchyId after = new HierarchyId((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HierarchyNode[]{package$.MODULE$.IntToHierarchyNode(1), package$.MODULE$.IntToHierarchyNode(2)}));
                package$.MODULE$.Update().apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE tbl (id int identity PRIMARY KEY, v hierarchyid)"})).s((Seq)Nil$.MODULE$), package$.MODULE$.Update().apply$default$2()).update(connection);
                package$.MODULE$.JdbcStringContextMethods(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO tbl (v) VALUES (", ")"}))).update((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{before}), package$.MODULE$.ParameterSetter()).update(connection);
                package$.MODULE$.JdbcStringContextMethods(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT id, v FROM tbl"}))).selectForUpdate((Seq)Nil$.MODULE$, package$.MODULE$.ParameterSetter()).iterator(connection).foreach((Function1)new Serializable(this, after){
                    public static final long serialVersionUID = 0L;
                    private final HierarchyId after$2;

                    public final void apply(UpdatableRow row) {
                        row.update("v", (Object)this.after$2, package$.MODULE$.HierarchyUpdater());
                        row.updateRow();
                    }
                    {
                        this.after$2 = after$2;
                    }
                });
                Option maybeValue = package$.MODULE$.Select().apply("SELECT v.ToString() FROM tbl", package$.MODULE$.Select().apply$default$2(), package$.MODULE$.GetterToRowConverter((Function2)package$.MODULE$.HierarchyIdGetter())).option(connection);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(maybeValue.nonEmpty(), "maybeValue.nonEmpty");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                this.$outer.assertResult(new Some((Object)after), maybeValue);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Update None"})).s((Seq)Nil$.MODULE$), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UpdatesSpec $outer;

            public final void apply(Connection connection) {
                Option maybeValue;
                Some before = new Some((Object)BoxesRunTime.boxToInteger((int)1));
                None$ after = None$.MODULE$;
                package$.MODULE$.Update().apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE tbl (id int identity PRIMARY KEY, v int)"})).s((Seq)Nil$.MODULE$), package$.MODULE$.Update().apply$default$2()).update(connection);
                package$.MODULE$.JdbcStringContextMethods(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO tbl (v) VALUES (", ")"}))).update((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{before}), package$.MODULE$.ParameterSetter()).update(connection);
                package$.MODULE$.JdbcStringContextMethods(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT id, v FROM tbl"}))).selectForUpdate((Seq)Nil$.MODULE$, package$.MODULE$.ParameterSetter()).iterator(connection).foreach((Function1)new Serializable(this, after){
                    public static final long serialVersionUID = 0L;
                    private final None$ after$3;

                    public final void apply(UpdatableRow row) {
                        row.update("v", (Object)this.after$3, package$.MODULE$.NoneUpdater());
                        row.updateRow();
                    }
                    {
                        this.after$3 = after$3;
                    }
                });
                Option maybeRow = package$.MODULE$.Select().apply("SELECT v FROM tbl", package$.MODULE$.Select().apply$default$2(), package$.MODULE$.GetterToRowConverterOption(package$.MODULE$.IntGetter())).iterator(connection).toStream().headOption();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(maybeRow.nonEmpty(), "maybeRow.nonEmpty");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"There was a row");
                Option $org_scalatest_assert_macro_left = maybeValue = (Option)maybeRow.get();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

