/*
 * Decompiled with CFR 0.152.
 */
package com.rocketfuel.sdbc.sqlserver.jdbc;

import com.rocketfuel.sdbc.sqlserver.jdbc.HierarchyId;
import com.rocketfuel.sdbc.sqlserver.jdbc.HierarchyId$;
import com.rocketfuel.sdbc.sqlserver.jdbc.HierarchyNode;
import com.rocketfuel.sdbc.sqlserver.jdbc.SqlServerSuite;
import com.rocketfuel.sdbc.sqlserver.jdbc.package$;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.UUID;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scalaz.Scalaz$;

@ScalaSignature(bytes="\u0006\u0001\r2A!\u0001\u0002\u0001\u001b\tQq)\u001a;uKJ\u001c\u0006/Z2\u000b\u0005\r!\u0011\u0001\u00026eE\u000eT!!\u0002\u0004\u0002\u0013M\fHn]3sm\u0016\u0014(BA\u0004\t\u0003\u0011\u0019HMY2\u000b\u0005%Q\u0011A\u0003:pG.,GOZ;fY*\t1\"A\u0002d_6\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\u000f'Fd7+\u001a:wKJ\u001cV/\u001b;f\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0010\u0001!9q\u0003\u0001b\u0001\n\u0003A\u0012\u0001B;vS\u0012,\u0012!\u0007\t\u00035}i\u0011a\u0007\u0006\u00039u\tA!\u001e;jY*\ta$\u0001\u0003kCZ\f\u0017B\u0001\u0011\u001c\u0005\u0011)V+\u0013#\t\r\t\u0002\u0001\u0015!\u0003\u001a\u0003\u0015)X/\u001b3!\u0001")
public class GetterSpec
extends SqlServerSuite {
    private final UUID uuid = UUID.randomUUID();

    public UUID uuid() {
        return this.uuid;
    }

    /*
     * WARNING - void declaration
     */
    public GetterSpec() {
        void var1_1;
        this.testSelect("SELECT NULL", Scalaz$.MODULE$.none(), package$.MODULE$.GetterToRowConverterOption(package$.MODULE$.IntGetter()));
        this.testSelect("SELECT CAST(1 AS tinyint)", Scalaz$.MODULE$.ToOptionIdOps((Object)BoxesRunTime.boxToByte((byte)((byte)1))).some(), package$.MODULE$.GetterToRowConverterOption(package$.MODULE$.ByteGetter()));
        this.testSelect("SELECT CAST(1 AS smallint)", Scalaz$.MODULE$.ToOptionIdOps((Object)BoxesRunTime.boxToShort((short)((short)1))).some(), package$.MODULE$.GetterToRowConverterOption(package$.MODULE$.ShortGetter()));
        this.testSelect("SELECT CAST(1 AS int)", Scalaz$.MODULE$.ToOptionIdOps((Object)BoxesRunTime.boxToInteger((int)1)).some(), package$.MODULE$.GetterToRowConverterOption(package$.MODULE$.IntGetter()));
        this.testSelect("SELECT CAST(1 AS bigint)", Scalaz$.MODULE$.ToOptionIdOps((Object)BoxesRunTime.boxToLong((long)1L)).some(), package$.MODULE$.GetterToRowConverterOption(package$.MODULE$.LongGetter()));
        this.testSelect("SELECT 'hello'", Scalaz$.MODULE$.ToOptionIdOps((Object)"hello").some(), package$.MODULE$.GetterToRowConverterOption((Function2)package$.MODULE$.StringGetter()));
        this.testSelect("SELECT 0x0001ffa0", Scalaz$.MODULE$.ToOptionIdOps((Object)ByteBuffer.wrap((byte[])Predef$.MODULE$.intArrayOps(new int[]{0, 1, -1, -96}).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte apply(int x$1) {
                return (byte)x$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())))).some(), package$.MODULE$.GetterToRowConverterOption(package$.MODULE$.ByteBufferGetter()));
        this.testSelect("SELECT CAST(3.14159 AS real)", Scalaz$.MODULE$.ToOptionIdOps((Object)BoxesRunTime.boxToFloat((float)3.14159f)).some(), package$.MODULE$.GetterToRowConverterOption(package$.MODULE$.FloatGetter()));
        this.testSelect("SELECT CAST(3.14159 AS float)", Scalaz$.MODULE$.ToOptionIdOps((Object)BoxesRunTime.boxToDouble((double)3.14159)).some(), package$.MODULE$.GetterToRowConverterOption(package$.MODULE$.DoubleGetter()));
        this.testSelect("SELECT CAST(1 AS bit)", Scalaz$.MODULE$.ToOptionIdOps((Object)BoxesRunTime.boxToBoolean((boolean)true)).some(), package$.MODULE$.GetterToRowConverterOption(package$.MODULE$.BooleanGetter()));
        this.testSelect("SELECT CAST(3.14159 AS numeric(10,5)) --as Scala BigDecimal", Scalaz$.MODULE$.ToOptionIdOps((Object)scala.package$.MODULE$.BigDecimal().apply("3.14159")).some(), package$.MODULE$.GetterToRowConverterOption(package$.MODULE$.ScalaBigDecimalGetter()));
        this.testSelect("SELECT CAST(3.14159 AS numeric(10,5)) --as Java BigDecimal", Scalaz$.MODULE$.ToOptionIdOps((Object)scala.package$.MODULE$.BigDecimal().apply("3.14159").underlying()).some(), package$.MODULE$.GetterToRowConverterOption(package$.MODULE$.JavaBigDecimalGetter()));
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("hi"));
        this.testSelect("SELECT CAST('<a>hi</a>' AS xml)", Scalaz$.MODULE$.ToOptionIdOps((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, false, (Seq)var1_1)).some(), package$.MODULE$.GetterToRowConverterOption(package$.MODULE$.XMLGetter()));
        this.testSelect("SELECT CAST('2014-12-29' AS date)", Scalaz$.MODULE$.ToOptionIdOps((Object)Date.valueOf("2014-12-29")).some(), package$.MODULE$.GetterToRowConverterOption(package$.MODULE$.DateGetter()));
        this.testSelect("SELECT CAST('03:04:05' AS time) --as JDBC Time", Scalaz$.MODULE$.ToOptionIdOps((Object)Time.valueOf("03:04:05")).some(), package$.MODULE$.GetterToRowConverterOption(package$.MODULE$.TimeGetter()));
        this.testSelect("SELECT CAST('03:04:05' AS time) --as Java 8 LocalTime", Scalaz$.MODULE$.ToOptionIdOps((Object)LocalTime.parse("03:04:05")).some(), package$.MODULE$.GetterToRowConverterOption(package$.MODULE$.LocalTimeGetter()));
        this.testSelect("SELECT CAST('2014-12-29 01:02:03.5' AS datetime)", Scalaz$.MODULE$.ToOptionIdOps((Object)Timestamp.valueOf("2014-12-29 01:02:03.5")).some(), package$.MODULE$.GetterToRowConverterOption(package$.MODULE$.TimestampGetter()));
        this.testSelect("SELECT CAST('2014-12-29 01:02:03.5' AS datetime) --as Java 8 LocalDateTime)", Scalaz$.MODULE$.ToOptionIdOps((Object)LocalDateTime.parse("2014-12-29T01:02:03.5")).some(), package$.MODULE$.GetterToRowConverterOption(package$.MODULE$.LocalDateTimeGetter()));
        LocalDateTime localTime = LocalDateTime.parse("2014-12-29T01:02:03.5");
        ZoneOffset offset = ZoneId.systemDefault().getRules().getOffset(localTime);
        Instant expectedTime = localTime.toInstant(offset);
        this.testSelect("SELECT CAST('2014-12-29 01:02:03.5' AS datetime) --as Java 8 Instant", Scalaz$.MODULE$.ToOptionIdOps((Object)expectedTime).some(), package$.MODULE$.GetterToRowConverterOption(package$.MODULE$.InstantGetter()));
        this.testSelect("SELECT CAST('2014-12-29 01:02:03.5 -4:00' AS datetimeoffset) --as Java 8 OffsetDateTime", Scalaz$.MODULE$.ToOptionIdOps((Object)OffsetDateTime.parse("2014-12-29T01:02:03.5-04:00")).some(), package$.MODULE$.GetterToRowConverterOption(package$.MODULE$.OffsetDateTimeGetter()));
        this.testSelect("SELECT CAST('2014-12-29 01:02:03.5 -4:00' AS datetimeoffset) --as Java 8 Instant", Scalaz$.MODULE$.ToOptionIdOps((Object)Instant.parse("2014-12-29T05:02:03.5Z")).some(), package$.MODULE$.GetterToRowConverterOption(package$.MODULE$.InstantGetter()));
        this.testSelect("SELECT CAST('/' AS hierarchyid).ToString()", Scalaz$.MODULE$.ToOptionIdOps((Object)HierarchyId$.MODULE$.empty()).some(), package$.MODULE$.GetterToRowConverterOption((Function2)package$.MODULE$.HierarchyIdGetter()));
        this.testSelect("SELECT CAST('/1/2/3/' AS hierarchyid).ToString()", Scalaz$.MODULE$.ToOptionIdOps((Object)new HierarchyId((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HierarchyNode[]{package$.MODULE$.IntToHierarchyNode(1), package$.MODULE$.IntToHierarchyNode(2), package$.MODULE$.IntToHierarchyNode(3)}))).some(), package$.MODULE$.GetterToRowConverterOption((Function2)package$.MODULE$.HierarchyIdGetter()));
        this.testSelect("SELECT CAST('/1/2.1/3/' AS hierarchyid).ToString()", Scalaz$.MODULE$.ToOptionIdOps((Object)new HierarchyId((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HierarchyNode[]{package$.MODULE$.IntToHierarchyNode(1), package$.MODULE$.SeqIntToHierarchyNode((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1}))), package$.MODULE$.IntToHierarchyNode(3)}))).some(), package$.MODULE$.GetterToRowConverterOption((Function2)package$.MODULE$.HierarchyIdGetter()));
        this.testSelect(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT CAST('", "' AS uniqueidentifier)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.uuid()})), Scalaz$.MODULE$.ToOptionIdOps((Object)this.uuid()).some(), package$.MODULE$.GetterToRowConverterOption(package$.MODULE$.UUIDGetter()));
    }
}

