/*
 * Decompiled with CFR 0.152.
 */
package com.robotpajamas.stetho.couchbase;

import android.content.Context;
import com.facebook.stetho.InspectorModulesProvider;
import com.facebook.stetho.Stetho;
import com.facebook.stetho.inspector.protocol.ChromeDevtoolsDomain;
import com.robotpajamas.stetho.couchbase.CouchbasePeerManager;
import com.robotpajamas.stetho.couchbase.Database;
import java.util.ArrayList;
import timber.log.Timber;

public class CouchbaseInspectorModulesProvider
implements InspectorModulesProvider {
    private final Context mContext;
    private final boolean mShowMetadata;

    CouchbaseInspectorModulesProvider(Builder builder) {
        this.mContext = builder.context;
        this.mShowMetadata = builder.showMetadata;
    }

    public Iterable<ChromeDevtoolsDomain> get() {
        ArrayList<ChromeDevtoolsDomain> modules = new ArrayList<ChromeDevtoolsDomain>();
        for (ChromeDevtoolsDomain domain : Stetho.defaultInspectorModulesProvider((Context)this.mContext).get()) {
            Timber.d((String)"Domain: %s", (Object[])new Object[]{domain.toString()});
            if (domain instanceof com.facebook.stetho.inspector.protocol.module.Database) continue;
            modules.add(domain);
        }
        modules.add(new Database(new CouchbasePeerManager(this.mContext, this.mContext.getPackageName(), this.mShowMetadata)));
        return modules;
    }

    public static final class Builder {
        private Context context;
        private boolean showMetadata = true;

        public Builder(Context context) {
            if (context == null) {
                throw new IllegalArgumentException("Context must not be null.");
            }
            this.context = context.getApplicationContext();
        }

        public Builder showMetadata(boolean showMetadata) {
            this.showMetadata = showMetadata;
            return this;
        }

        public CouchbaseInspectorModulesProvider build() {
            return new CouchbaseInspectorModulesProvider(this);
        }
    }
}

