/*
 * Decompiled with CFR 0.152.
 */
package com.robotpajamas.stetho.couchbase;

import com.facebook.stetho.inspector.jsonrpc.JsonRpcPeer;
import com.facebook.stetho.inspector.jsonrpc.JsonRpcResult;
import com.facebook.stetho.inspector.protocol.ChromeDevtoolsDomain;
import com.facebook.stetho.inspector.protocol.ChromeDevtoolsMethod;
import com.facebook.stetho.json.ObjectMapper;
import com.facebook.stetho.json.annotation.JsonProperty;
import com.robotpajamas.stetho.couchbase.CouchbasePeerManager;
import java.util.List;
import org.json.JSONObject;
import timber.log.Timber;

class Database
implements ChromeDevtoolsDomain {
    private final CouchbasePeerManager mCouchbasePeerManager;
    private final ObjectMapper mObjectMapper = new ObjectMapper();

    Database(CouchbasePeerManager peerManager) {
        this.mCouchbasePeerManager = peerManager;
    }

    @ChromeDevtoolsMethod
    public void enable(JsonRpcPeer peer, JSONObject params) {
        Timber.d((String)"Enable Peer: %s", (Object[])new Object[]{String.valueOf(params)});
        this.mCouchbasePeerManager.addPeer(peer);
    }

    @ChromeDevtoolsMethod
    public void disable(JsonRpcPeer peer, JSONObject params) {
        Timber.d((String)"Disable Peer: %s", (Object[])new Object[]{String.valueOf(params)});
        this.mCouchbasePeerManager.removePeer(peer);
    }

    @ChromeDevtoolsMethod
    public JsonRpcResult getDatabaseTableNames(JsonRpcPeer peer, JSONObject params) {
        Timber.d((String)"getAllDocumentIds: %s", (Object[])new Object[]{String.valueOf(params)});
        GetDatabaseTableNamesRequest request = (GetDatabaseTableNamesRequest)this.mObjectMapper.convertValue((Object)params, GetDatabaseTableNamesRequest.class);
        GetDatabaseTableNamesResponse response = new GetDatabaseTableNamesResponse();
        response.tableNames = this.mCouchbasePeerManager.getAllDocumentIds(request.databaseId);
        return response;
    }

    @ChromeDevtoolsMethod
    public JsonRpcResult executeSQL(JsonRpcPeer peer, JSONObject params) {
        Timber.d((String)"executeSQL: %s", (Object[])new Object[]{String.valueOf(params)});
        ExecuteSQLResponse response = new ExecuteSQLResponse();
        try {
            ExecuteSQLRequest request = (ExecuteSQLRequest)this.mObjectMapper.convertValue((Object)params, ExecuteSQLRequest.class);
            return this.mCouchbasePeerManager.executeSQL(request.databaseId, request.query);
        }
        catch (Exception e) {
            Timber.e((String)e.toString(), (Object[])new Object[0]);
            Error error = new Error();
            error.code = 0;
            error.message = e.getMessage();
            response.sqlError = error;
            return response;
        }
    }

    public static class Error {
        @JsonProperty(required=true)
        public String message;
        @JsonProperty(required=true)
        public int code;
    }

    public static class DatabaseObject {
        @JsonProperty(required=true)
        public String id;
        @JsonProperty(required=true)
        public String domain;
        @JsonProperty(required=true)
        public String name;
        @JsonProperty(required=true)
        public String version;
    }

    public static class AddDatabaseEvent {
        @JsonProperty(required=true)
        public DatabaseObject database;
    }

    static class ExecuteSQLResponse
    implements JsonRpcResult {
        @JsonProperty
        public List<String> columnNames;
        @JsonProperty
        public List<Object> values;
        @JsonProperty
        public Error sqlError;

        ExecuteSQLResponse() {
        }
    }

    private static class ExecuteSQLRequest {
        @JsonProperty(required=true)
        public String databaseId;
        @JsonProperty(required=true)
        public String query;

        private ExecuteSQLRequest() {
        }
    }

    private static class GetDatabaseTableNamesResponse
    implements JsonRpcResult {
        @JsonProperty(required=true)
        public List<String> tableNames;

        private GetDatabaseTableNamesResponse() {
        }
    }

    private static class GetDatabaseTableNamesRequest {
        @JsonProperty(required=true)
        public String databaseId;

        private GetDatabaseTableNamesRequest() {
        }
    }
}

