/*
 * Decompiled with CFR 0.152.
 */
package com.robotpajamas.stetho.couchbase;

import com.couchbase.lite.Context;
import com.couchbase.lite.Database;
import com.couchbase.lite.DatabaseOptions;
import com.couchbase.lite.Document;
import com.couchbase.lite.Manager;
import com.couchbase.lite.ManagerOptions;
import com.couchbase.lite.QueryEnumerator;
import com.couchbase.lite.QueryRow;
import com.couchbase.lite.android.AndroidContext;
import com.facebook.stetho.inspector.console.CLog;
import com.facebook.stetho.inspector.helper.ChromePeerManager;
import com.facebook.stetho.inspector.helper.PeerRegistrationListener;
import com.facebook.stetho.inspector.jsonrpc.JsonRpcPeer;
import com.facebook.stetho.inspector.protocol.module.Console;
import com.robotpajamas.stetho.couchbase.Database;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;
import timber.log.Timber;

class CouchbasePeerManager
extends ChromePeerManager {
    private static final String DOC_PATTERN = "\"(.*?)\"";
    private static final List<String> COLUMN_NAMES = Arrays.asList("key", "value");
    private final Pattern mPattern = Pattern.compile("\"(.*?)\"");
    private final String mPackageName;
    private final android.content.Context mContext;
    private Manager mManager;

    CouchbasePeerManager(android.content.Context context, String packageName) {
        this.mContext = context;
        this.mPackageName = packageName;
        ManagerOptions managerOptions = new ManagerOptions();
        managerOptions.setReadOnly(true);
        try {
            this.mManager = new Manager((Context)new AndroidContext(this.mContext), managerOptions);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setListener(new PeerRegistrationListener(){

            public void onPeerRegistered(JsonRpcPeer peer) {
                Timber.e((String)"onPeerRegistered", (Object[])new Object[0]);
                CouchbasePeerManager.this.setupPeer(peer);
            }

            public void onPeerUnregistered(JsonRpcPeer peer) {
            }
        });
    }

    private void setupPeer(JsonRpcPeer peer) {
        Timber.e((String)"setupPeer", (Object[])new Object[0]);
        List potentialDatabases = this.mManager.getAllDatabaseNames();
        for (String database : potentialDatabases) {
            Timber.e((String)"File: %s", (Object[])new Object[]{database});
            Database.DatabaseObject databaseParams = new Database.DatabaseObject();
            databaseParams.id = database;
            databaseParams.name = database;
            databaseParams.domain = this.mPackageName;
            databaseParams.version = "N/A";
            Database.AddDatabaseEvent eventParams = new Database.AddDatabaseEvent();
            eventParams.database = databaseParams;
            peer.invokeMethod("Database.addDatabase", (Object)eventParams, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getAllDocumentIds(String databaseId) {
        Timber.d((String)"getAllDocumentIds: %s", (Object[])new Object[]{databaseId});
        ManagerOptions managerOptions = new ManagerOptions();
        managerOptions.setReadOnly(true);
        DatabaseOptions databaseOptions = new DatabaseOptions();
        databaseOptions.setReadOnly(true);
        Database database = null;
        try {
            Manager manager = new Manager((Context)new AndroidContext(this.mContext), managerOptions);
            database = manager.openDatabase(databaseId, databaseOptions);
            ArrayList<String> docIds = new ArrayList<String>();
            QueryEnumerator result = database.createAllDocumentsQuery().run();
            while (result.hasNext()) {
                QueryRow row = result.next();
                docIds.add(row.getDocumentId());
            }
            ArrayList<String> arrayList = docIds;
            return arrayList;
        }
        catch (Exception e) {
            List<String> list = Collections.emptyList();
            return list;
        }
        finally {
            if (database != null) {
                database.close();
            }
        }
    }

    Database.ExecuteSQLResponse executeSQL(String databaseId, String query) throws JSONException {
        Timber.d((String)"executeSQL: %s, %s", (Object[])new Object[]{databaseId, query});
        Database.ExecuteSQLResponse response = new Database.ExecuteSQLResponse();
        Matcher matcher = this.mPattern.matcher(query);
        if (!matcher.find()) {
            return response;
        }
        String docId = matcher.group(1);
        Timber.d((String)"Parsed doc ID: %s", (Object[])new Object[]{docId});
        Map<String, String> map = this.getDocument(databaseId, docId);
        response.columnNames = COLUMN_NAMES;
        response.values = new ArrayList<Object>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            response.values.add(entry.getKey());
            response.values.add(entry.getValue());
        }
        CLog.writeToConsole((Console.MessageLevel)Console.MessageLevel.DEBUG, (Console.MessageSource)Console.MessageSource.JAVASCRIPT, (String)new JSONObject(map).toString(4));
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getDocument(String databaseId, String docId) {
        Timber.d((String)"getDocument: %s, %s", (Object[])new Object[]{databaseId, docId});
        DatabaseOptions databaseOptions = new DatabaseOptions();
        databaseOptions.setReadOnly(true);
        Database database = null;
        try {
            database = this.mManager.openDatabase(databaseId, databaseOptions);
            Document doc = database.getExistingDocument(docId);
            if (doc == null) {
                TreeMap<String, String> treeMap = new TreeMap<String, String>();
                return treeMap;
            }
            TreeMap returnedMap = new TreeMap();
            for (Map.Entry entry : doc.getProperties().entrySet()) {
                returnedMap.put(entry.getKey(), String.valueOf(entry.getValue()));
            }
            TreeMap treeMap = returnedMap;
            return treeMap;
        }
        catch (Exception e) {
            Timber.e((String)e.toString(), (Object[])new Object[0]);
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            return treeMap;
        }
        finally {
            if (database != null) {
                database.close();
            }
        }
    }
}

