/*
 * Decompiled with CFR 0.152.
 */
package com.robin.lazy.logger.slf4j;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.android.LogcatAppender;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import org.slf4j.LoggerFactory;

public class Slf4jConfigurator {
    private static final String DEFAULT_PATTERN = "%d - [%p::%c] - %m%n";
    private Level level;
    private String logPattern = "%d - [%p::%c] - %m%n";
    private String fileNamePattern;

    public void setLevel(Level level) {
        this.level = level;
    }

    public void setFileNamePattern(String fileNamePattern) {
        this.fileNamePattern = fileNamePattern;
    }

    public void configure() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        context.reset();
        RollingFileAppender rollingFileAppender = new RollingFileAppender();
        rollingFileAppender.setAppend(true);
        rollingFileAppender.setContext((Context)context);
        TimeBasedRollingPolicy rollingPolicy = new TimeBasedRollingPolicy();
        rollingPolicy.setFileNamePattern(this.fileNamePattern);
        rollingPolicy.setMaxHistory(7);
        rollingPolicy.setParent((FileAppender)rollingFileAppender);
        rollingPolicy.setContext((Context)context);
        rollingPolicy.start();
        rollingFileAppender.setRollingPolicy((RollingPolicy)rollingPolicy);
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setPattern(this.logPattern);
        encoder.setContext((Context)context);
        encoder.start();
        rollingFileAppender.setEncoder((Encoder)encoder);
        rollingFileAppender.start();
        LogcatAppender logcatAppender = new LogcatAppender();
        logcatAppender.setContext((Context)context);
        logcatAppender.setEncoder(encoder);
        logcatAppender.setName("logcat");
        logcatAppender.start();
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        root.setLevel(this.level);
        root.addAppender((Appender)rollingFileAppender);
        root.addAppender((Appender)logcatAppender);
    }
}

