/*
 * Decompiled with CFR 0.152.
 */
package com.robin.lazy.logger;

import android.text.TextUtils;
import com.robin.lazy.logger.LogLevel;
import com.robin.lazy.logger.Printer;
import com.robin.lazy.logger.Settings;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LoggerOrdinaryPrinter
implements Printer {
    private static final int JSON_INDENT = 4;
    private String tag;
    private Settings settings;
    private final ThreadLocal<String> localTag = new ThreadLocal();

    @Override
    public Printer t(String tag, int methodCount) {
        if (tag != null) {
            this.localTag.set(tag);
        }
        return this;
    }

    @Override
    public Settings init(String tag) {
        if (tag == null) {
            throw new NullPointerException("tag may not be null");
        }
        if (tag.trim().length() == 0) {
            throw new IllegalStateException("tag may not be empty");
        }
        this.tag = tag;
        this.settings = new Settings();
        return this.settings;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public void d(String message, Object ... args) {
        this.log(LogLevel.DEBUG, message, args);
    }

    @Override
    public void d(Throwable throwable, String message, Object ... args) {
        this.log(LogLevel.DEBUG, throwable, message, args);
    }

    @Override
    public void e(String message, Object ... args) {
        this.log(LogLevel.ERROR, message, args);
    }

    @Override
    public void e(Throwable throwable, String message, Object ... args) {
        this.log(LogLevel.ERROR, throwable, message, args);
    }

    @Override
    public void w(String message, Object ... args) {
        this.log(LogLevel.WARN, message, args);
    }

    @Override
    public void w(Throwable throwable, String message, Object ... args) {
        this.log(LogLevel.WARN, throwable, message, args);
    }

    @Override
    public void i(String message, Object ... args) {
        this.log(LogLevel.INFO, message, args);
    }

    @Override
    public void i(Throwable throwable, String message, Object ... args) {
        this.log(LogLevel.INFO, throwable, message, args);
    }

    @Override
    public void v(String message, Object ... args) {
        this.log(LogLevel.TRACE, message, args);
    }

    @Override
    public void v(Throwable throwable, String message, Object ... args) {
        this.log(LogLevel.TRACE, throwable, message, args);
    }

    @Override
    public void wtf(String message, Object ... args) {
        this.log(LogLevel.FATAL, message, args);
    }

    @Override
    public void wtf(Throwable throwable, String message, Object ... args) {
        this.log(LogLevel.FATAL, throwable, message, args);
    }

    @Override
    public void json(String json) {
        if (TextUtils.isEmpty((CharSequence)json)) {
            this.d("Empty/Null json content", new Object[0]);
            return;
        }
        try {
            if (json.startsWith("{")) {
                JSONObject jsonObject = new JSONObject(json);
                String message = jsonObject.toString(4);
                this.d(message, new Object[0]);
                return;
            }
            if (json.startsWith("[")) {
                JSONArray jsonArray = new JSONArray(json);
                String message = jsonArray.toString(4);
                this.d(message, new Object[0]);
            }
        }
        catch (JSONException e) {
            this.e(e.getCause().getMessage() + "\n" + json, new Object[0]);
        }
    }

    @Override
    public void xml(String xml) {
        if (TextUtils.isEmpty((CharSequence)xml)) {
            this.d("Empty/Null xml content", new Object[0]);
            return;
        }
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(xml));
            StreamResult xmlOutput = new StreamResult(new StringWriter());
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(xmlInput, xmlOutput);
            this.d(xmlOutput.getWriter().toString().replaceFirst(">", ">\n"), new Object[0]);
        }
        catch (TransformerException e) {
            this.e(e.getCause().getMessage() + "\n" + xml, new Object[0]);
        }
    }

    @Override
    public void clear() {
        this.settings = null;
    }

    private void log(LogLevel logType, String message, Object ... args) {
        this.log(logType, null, message, args);
    }

    private void log(LogLevel logType, Throwable throwable, String message, Object ... args) {
        if (this.settings == null || this.settings.getLogLevel().getCode() > logType.getCode()) {
            return;
        }
        String finalMessage = this.createMessage(message, args);
        switch (logType) {
            case TRACE: {
                if (throwable != null) {
                    this.settings.getLogTool().v(this.getTag(), finalMessage, throwable);
                    break;
                }
                this.settings.getLogTool().v(this.getTag(), finalMessage);
                break;
            }
            case DEBUG: {
                if (throwable != null) {
                    this.settings.getLogTool().d(this.getTag(), finalMessage, throwable);
                    break;
                }
                this.settings.getLogTool().d(this.getTag(), finalMessage);
                break;
            }
            case INFO: {
                if (throwable != null) {
                    this.settings.getLogTool().i(this.getTag(), finalMessage, throwable);
                    break;
                }
                this.settings.getLogTool().i(this.getTag(), finalMessage);
                break;
            }
            case WARN: {
                if (throwable != null) {
                    this.settings.getLogTool().w(this.getTag(), finalMessage, throwable);
                    break;
                }
                this.settings.getLogTool().w(this.getTag(), finalMessage);
                break;
            }
            case ERROR: {
                if (throwable != null) {
                    this.settings.getLogTool().e(this.getTag(), finalMessage, throwable);
                    break;
                }
                this.settings.getLogTool().e(this.getTag(), finalMessage);
                break;
            }
            case FATAL: {
                if (throwable != null) {
                    this.settings.getLogTool().wtf(this.getTag(), finalMessage, throwable);
                    break;
                }
                this.settings.getLogTool().wtf(this.getTag(), finalMessage);
                break;
            }
        }
    }

    private String createMessage(String message, Object ... args) {
        return args.length == 0 ? message : String.format(message, args);
    }

    private String getTag() {
        String tag = this.localTag.get();
        if (tag != null) {
            this.localTag.remove();
            return tag;
        }
        return this.tag;
    }
}

