/*
 * Decompiled with CFR 0.152.
 */
package com.robin.lazy.logger;

import com.robin.lazy.logger.LoggerFormattedPrinter;
import com.robin.lazy.logger.LoggerPrinterFactory;
import com.robin.lazy.logger.Printer;
import com.robin.lazy.logger.PrinterType;
import com.robin.lazy.logger.Settings;

public final class LazyLogger {
    private static final String DEFAULT_TAG = "LazyLogger";
    private static Printer printer = new LoggerFormattedPrinter();

    private LazyLogger() {
    }

    public static Settings init(PrinterType printerType) {
        return LazyLogger.init(DEFAULT_TAG, printerType);
    }

    public static Settings init(String tag, PrinterType printerType) {
        if (printer != null) {
            LazyLogger.clear();
        }
        printer = LoggerPrinterFactory.getPrinter(printerType);
        return printer.init(tag);
    }

    public static void clear() {
        printer.clear();
        printer = null;
    }

    public static Printer t(String tag) {
        return printer.t(tag, printer.getSettings().getMethodCount());
    }

    public static Printer t(int methodCount) {
        return printer.t(null, methodCount);
    }

    public static Printer t(String tag, int methodCount) {
        return printer.t(tag, methodCount);
    }

    public static void d(String message, Object ... args) {
        printer.d(message, args);
    }

    public static void d(Throwable throwable, String message, Object ... args) {
        printer.d(throwable, message, args);
    }

    public static void e(String message, Object ... args) {
        printer.e(null, message, args);
    }

    public static void e(Throwable throwable, String message, Object ... args) {
        printer.e(throwable, message, args);
    }

    public static void i(String message, Object ... args) {
        printer.i(message, args);
    }

    public static void i(Throwable throwable, String message, Object ... args) {
        printer.i(throwable, message, args);
    }

    public static void v(String message, Object ... args) {
        printer.v(message, args);
    }

    public static void v(Throwable throwable, String message, Object ... args) {
        printer.v(throwable, message, args);
    }

    public static void w(String message, Object ... args) {
        printer.w(message, args);
    }

    public static void w(Throwable throwable, String message, Object ... args) {
        printer.w(throwable, message, args);
    }

    public static void wtf(String message, Object ... args) {
        printer.wtf(message, args);
    }

    public static void wtf(Throwable throwable, String message, Object ... args) {
        printer.wtf(throwable, message, args);
    }

    public static void json(String json) {
        printer.json(json);
    }

    public static void xml(String xml) {
        printer.xml(xml);
    }
}

