/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.repackage.brut.androlib.res.xml;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResXmlEncoders {
    public static String escapeXmlChars(String string) {
        return string.replace("&", "&amp;").replace("<", "&lt;");
    }

    public static String encodeAsResXmlAttr(String string) {
        if (string.isEmpty()) {
            return string;
        }
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder(string.length() + 10);
        switch (cArray[0]) {
            case '#': 
            case '?': 
            case '@': {
                stringBuilder.append('\\');
            }
        }
        block8: for (char c : cArray) {
            switch (c) {
                case '\\': {
                    stringBuilder.append('\\');
                    break;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block8;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block8;
                }
                default: {
                    if (ResXmlEncoders.isPrintableChar(c)) break;
                    stringBuilder.append(String.format("\\u%04x", c));
                    continue block8;
                }
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String encodeAsXmlValue(String string) {
        if (string.isEmpty()) {
            return string;
        }
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder(string.length() + 10);
        switch (cArray[0]) {
            case '#': 
            case '?': 
            case '@': {
                stringBuilder.append('\\');
            }
        }
        boolean bl = false;
        int n = 0;
        boolean bl2 = false;
        boolean bl3 = true;
        block9: for (char c : cArray) {
            if (bl) {
                if (c == '>') {
                    bl = false;
                    n = stringBuilder.length() + 1;
                    bl2 = false;
                }
            } else if (c == ' ') {
                if (bl3) {
                    bl2 = true;
                }
                bl3 = true;
            } else {
                bl3 = false;
                switch (c) {
                    case '\\': {
                        stringBuilder.append('\\');
                        break;
                    }
                    case '\n': 
                    case '\'': {
                        bl2 = true;
                        break;
                    }
                    case '\"': {
                        stringBuilder.append('\\');
                        break;
                    }
                    case '<': {
                        bl = true;
                        if (!bl2) break;
                        stringBuilder.insert(n, '\"').append('\"');
                        break;
                    }
                    default: {
                        if (ResXmlEncoders.isPrintableChar(c)) break;
                        stringBuilder.append(String.format("\\u%04x", c));
                        continue block9;
                    }
                }
            }
            stringBuilder.append(c);
        }
        if (bl2 || bl3) {
            stringBuilder.insert(n, '\"').append('\"');
        }
        return stringBuilder.toString();
    }

    public static boolean hasMultipleNonPositionalSubstitutions(String string) {
        return ResXmlEncoders.findNonPositionalSubstitutions(string, 2).size() > 1;
    }

    public static String enumerateNonPositionalSubstitutions(String string) {
        List<Integer> list = ResXmlEncoders.findNonPositionalSubstitutions(string, -1);
        if (list.size() < 2) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = 0;
        for (Integer n3 : list) {
            n3 = n3 + 1;
            stringBuilder.append(string.substring(n, n3)).append(++n2).append('$');
            n = n3;
        }
        stringBuilder.append(string.substring(n));
        return stringBuilder.toString();
    }

    private static List<Integer> findNonPositionalSubstitutions(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = string.length();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while ((n3 = (n2 = string.indexOf(37, n3)) + 1) != 0 && n3 != n5) {
            char c;
            if ((c = string.charAt(n3++)) == '%') continue;
            if (c >= '0' && c <= '9' && n3 < n5) {
                while ((c = string.charAt(n3++)) >= '0' && c <= '9' && n3 < n5) {
                }
                if (c == '$') continue;
            }
            arrayList.add(n2);
            if (n == -1 || ++n4 < n) continue;
            break;
        }
        return arrayList;
    }

    private static boolean isPrintableChar(char c) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && c != '\uffff' && unicodeBlock != null && unicodeBlock != Character.UnicodeBlock.SPECIALS;
    }
}

