/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.sift;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.helpers.NOPAppender;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.sift.AppenderFactory;
import ch.qos.logback.core.spi.AbstractComponentTracker;
import ch.qos.logback.core.spi.ContextAwareImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppenderTracker<E>
extends AbstractComponentTracker<Appender<E>> {
    int nopaWarningCount = 0;
    final Context context;
    final AppenderFactory<E> appenderFactory;
    final ContextAwareImpl contextAware;

    public AppenderTracker(Context context, AppenderFactory<E> appenderFactory) {
        this.context = context;
        this.appenderFactory = appenderFactory;
        this.contextAware = new ContextAwareImpl(context, this);
    }

    @Override
    protected void processPriorToRemoval(Appender<E> appender) {
        appender.stop();
    }

    @Override
    protected Appender<E> buildComponent(String string) {
        Appender<E> appender = null;
        try {
            appender = this.appenderFactory.buildAppender(this.context, string);
        }
        catch (JoranException joranException) {
            this.contextAware.addError("Error while building appender with discriminating value [" + string + "]");
        }
        if (appender == null) {
            appender = this.buildNOPAppender(string);
        }
        return appender;
    }

    private NOPAppender<E> buildNOPAppender(String string) {
        if (this.nopaWarningCount < 4) {
            ++this.nopaWarningCount;
            this.contextAware.addError("Building NOPAppender for discriminating value [" + string + "]");
        }
        NOPAppender nOPAppender = new NOPAppender();
        nOPAppender.setContext(this.context);
        nOPAppender.start();
        return nOPAppender;
    }

    @Override
    protected boolean isComponentStale(Appender<E> appender) {
        return !appender.isStarted();
    }
}

