/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.net.DefaultSocketConnector;
import ch.qos.logback.core.net.SocketConnector;
import ch.qos.logback.core.spi.PreSerializationTransformer;
import ch.qos.logback.core.util.CloseUtil;
import ch.qos.logback.core.util.Duration;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSocketAppender<E>
extends AppenderBase<E>
implements Runnable,
SocketConnector.ExceptionHandler {
    public static final int DEFAULT_PORT = 4560;
    public static final int DEFAULT_RECONNECTION_DELAY = 30000;
    public static final int DEFAULT_QUEUE_SIZE = 128;
    private static final int DEFAULT_ACCEPT_CONNECTION_DELAY = 5000;
    private static final int DEFAULT_EVENT_DELAY_TIMEOUT = 100;
    private String remoteHost;
    private int port = 4560;
    private InetAddress address;
    private Duration reconnectionDelay = new Duration(30000L);
    private int queueSize = 128;
    private int acceptConnectionTimeout = 5000;
    private Duration eventDelayLimit = new Duration(100L);
    private BlockingQueue<E> queue;
    private String peerId;
    private Future<?> task;
    private Future<Socket> connectorTask;
    private volatile Socket socket;

    protected AbstractSocketAppender() {
    }

    @Deprecated
    protected AbstractSocketAppender(String string, int n) {
        this.remoteHost = string;
        this.port = n;
    }

    @Override
    public void start() {
        if (this.isStarted()) {
            return;
        }
        int n = 0;
        if (this.port <= 0) {
            ++n;
            this.addError("No port was configured for appender" + this.name + " For more information, please visit http://logback.qos.ch/codes.html#socket_no_port");
        }
        if (this.remoteHost == null) {
            ++n;
            this.addError("No remote host was configured for appender" + this.name + " For more information, please visit http://logback.qos.ch/codes.html#socket_no_host");
        }
        if (this.queueSize < 0) {
            ++n;
            this.addError("Queue size must be non-negative");
        }
        if (n == 0) {
            try {
                this.address = InetAddress.getByName(this.remoteHost);
            }
            catch (UnknownHostException unknownHostException) {
                this.addError("unknown host: " + this.remoteHost);
                ++n;
            }
        }
        if (n == 0) {
            this.queue = this.newBlockingQueue(this.queueSize);
            this.peerId = "remote peer " + this.remoteHost + ":" + this.port + ": ";
            this.task = this.getContext().getExecutorService().submit(this);
            super.start();
        }
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        CloseUtil.closeQuietly(this.socket);
        this.task.cancel(true);
        if (this.connectorTask != null) {
            this.connectorTask.cancel(true);
        }
        super.stop();
    }

    @Override
    protected void append(E e) {
        if (e == null || !this.isStarted()) {
            return;
        }
        try {
            boolean bl = this.queue.offer(e, this.eventDelayLimit.getMilliseconds(), TimeUnit.MILLISECONDS);
            if (!bl) {
                this.addInfo("Dropping event due to timeout limit of [" + this.eventDelayLimit + "] milliseconds being exceeded");
            }
        }
        catch (InterruptedException interruptedException) {
            this.addError("Interrupted while appending event to SocketAppender", interruptedException);
        }
    }

    @Override
    public final void run() {
        this.signalEntryInRunMethod();
        try {
            while (!Thread.currentThread().isInterrupted()) {
                SocketConnector socketConnector = this.createConnector(this.address, this.port, 0, this.reconnectionDelay.getMilliseconds());
                this.connectorTask = this.activateConnector(socketConnector);
                if (this.connectorTask != null) {
                    this.socket = this.waitForConnectorToReturnASocket();
                    if (this.socket != null) {
                        this.dispatchEvents();
                        continue;
                    }
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.addInfo("shutting down");
    }

    protected void signalEntryInRunMethod() {
    }

    private SocketConnector createConnector(InetAddress inetAddress, int n, int n2, long l) {
        SocketConnector socketConnector = this.newConnector(inetAddress, n, n2, l);
        socketConnector.setExceptionHandler(this);
        socketConnector.setSocketFactory(this.getSocketFactory());
        return socketConnector;
    }

    private Future<Socket> activateConnector(SocketConnector socketConnector) {
        try {
            return this.getContext().getExecutorService().submit(socketConnector);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return null;
        }
    }

    private Socket waitForConnectorToReturnASocket() throws InterruptedException {
        try {
            Socket socket = this.connectorTask.get();
            this.connectorTask = null;
            return socket;
        }
        catch (ExecutionException executionException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvents() throws InterruptedException {
        try {
            try {
                this.socket.setSoTimeout(this.acceptConnectionTimeout);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.socket.getOutputStream());
                this.socket.setSoTimeout(0);
                this.addInfo(this.peerId + "connection established");
                int n = 0;
                while (true) {
                    E e = this.queue.take();
                    this.postProcessEvent(e);
                    Serializable serializable = this.getPST().transform(e);
                    objectOutputStream.writeObject(serializable);
                    objectOutputStream.flush();
                    if (++n < 70) continue;
                    objectOutputStream.reset();
                    n = 0;
                }
            }
            catch (IOException iOException) {
                this.addInfo(this.peerId + "connection failed: " + iOException);
                CloseUtil.closeQuietly(this.socket);
                this.socket = null;
                this.addInfo(this.peerId + "connection closed");
            }
        }
        catch (Throwable throwable) {
            CloseUtil.closeQuietly(this.socket);
            this.socket = null;
            this.addInfo(this.peerId + "connection closed");
            throw throwable;
        }
    }

    @Override
    public void connectionFailed(SocketConnector socketConnector, Exception exception) {
        if (exception instanceof InterruptedException) {
            this.addInfo("connector interrupted");
        } else if (exception instanceof ConnectException) {
            this.addInfo(this.peerId + "connection refused");
        } else {
            this.addInfo(this.peerId + exception);
        }
    }

    protected SocketConnector newConnector(InetAddress inetAddress, int n, long l, long l2) {
        return new DefaultSocketConnector(inetAddress, n, l, l2);
    }

    protected SocketFactory getSocketFactory() {
        return SocketFactory.getDefault();
    }

    BlockingQueue<E> newBlockingQueue(int n) {
        return (BlockingQueue)((Object)(n <= 0 ? new SynchronousQueue() : new ArrayBlockingQueue(n)));
    }

    protected abstract void postProcessEvent(E var1);

    protected abstract PreSerializationTransformer<E> getPST();

    @Deprecated
    protected static InetAddress getAddressByName(String string) {
        try {
            return InetAddress.getByName(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setRemoteHost(String string) {
        this.remoteHost = string;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public int getPort() {
        return this.port;
    }

    public void setReconnectionDelay(Duration duration) {
        this.reconnectionDelay = duration;
    }

    public Duration getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    public void setQueueSize(int n) {
        this.queueSize = n;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setEventDelayLimit(Duration duration) {
        this.eventDelayLimit = duration;
    }

    public Duration getEventDelayLimit() {
        return this.eventDelayLimit;
    }

    void setAcceptConnectionTimeout(int n) {
        this.acceptConnectionTimeout = n;
    }
}

