/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.IADataForComplexProperty;
import ch.qos.logback.core.joran.action.ImplicitAction;
import ch.qos.logback.core.joran.spi.ElementPath;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.joran.spi.NoAutoStartUtil;
import ch.qos.logback.core.joran.util.PropertySetter;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.util.AggregationType;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.util.Stack;
import org.xml.sax.Attributes;

public class NestedComplexPropertyIA
extends ImplicitAction {
    Stack<IADataForComplexProperty> actionDataStack = new Stack();

    public boolean isApplicable(ElementPath elementPath, Attributes attributes, InterpretationContext interpretationContext) {
        String string = elementPath.peekLast();
        if (interpretationContext.isEmpty()) {
            return false;
        }
        Object object = interpretationContext.peekObject();
        PropertySetter propertySetter = new PropertySetter(object);
        propertySetter.setContext(this.context);
        AggregationType aggregationType = propertySetter.computeAggregationType(string);
        switch (aggregationType) {
            case NOT_FOUND: 
            case AS_BASIC_PROPERTY: 
            case AS_BASIC_PROPERTY_COLLECTION: {
                return false;
            }
            case AS_COMPLEX_PROPERTY_COLLECTION: 
            case AS_COMPLEX_PROPERTY: {
                IADataForComplexProperty iADataForComplexProperty = new IADataForComplexProperty(propertySetter, aggregationType, string);
                this.actionDataStack.push(iADataForComplexProperty);
                return true;
            }
        }
        this.addError("PropertySetter.computeAggregationType returned " + (Object)((Object)aggregationType));
        return false;
    }

    public void begin(InterpretationContext interpretationContext, String string, Attributes attributes) {
        IADataForComplexProperty iADataForComplexProperty = this.actionDataStack.peek();
        String string2 = attributes.getValue("class");
        string2 = interpretationContext.subst(string2);
        Class<?> clazz = null;
        try {
            Object object;
            if (!OptionHelper.isEmpty(string2)) {
                clazz = Loader.loadClass(string2, this.context);
            } else {
                object = iADataForComplexProperty.parentBean;
                clazz = ((PropertySetter)object).getClassNameViaImplicitRules(iADataForComplexProperty.getComplexPropertyName(), iADataForComplexProperty.getAggregationType(), interpretationContext.getDefaultNestedComponentRegistry());
            }
            if (clazz == null) {
                iADataForComplexProperty.inError = true;
                object = "Could not find an appropriate class for property [" + string + "]";
                this.addError((String)object);
                return;
            }
            if (OptionHelper.isEmpty(string2)) {
                this.addInfo("Assuming default type [" + clazz.getName() + "] for [" + string + "] property");
            }
            iADataForComplexProperty.setNestedComplexProperty(clazz.newInstance());
            if (iADataForComplexProperty.getNestedComplexProperty() instanceof ContextAware) {
                ((ContextAware)iADataForComplexProperty.getNestedComplexProperty()).setContext(this.context);
            }
            interpretationContext.pushObject(iADataForComplexProperty.getNestedComplexProperty());
        }
        catch (Exception exception) {
            iADataForComplexProperty.inError = true;
            String string3 = "Could not create component [" + string + "] of type [" + string2 + "]";
            this.addError(string3, exception);
        }
    }

    public void end(InterpretationContext interpretationContext, String string) {
        Object object;
        Object object2;
        IADataForComplexProperty iADataForComplexProperty = this.actionDataStack.pop();
        if (iADataForComplexProperty.inError) {
            return;
        }
        PropertySetter propertySetter = new PropertySetter(iADataForComplexProperty.getNestedComplexProperty());
        propertySetter.setContext(this.context);
        if (propertySetter.computeAggregationType("parent") == AggregationType.AS_COMPLEX_PROPERTY) {
            propertySetter.setComplexProperty("parent", iADataForComplexProperty.parentBean.getObj());
        }
        if ((object2 = iADataForComplexProperty.getNestedComplexProperty()) instanceof LifeCycle && NoAutoStartUtil.notMarkedWithNoAutoStart(object2)) {
            ((LifeCycle)object2).start();
        }
        if ((object = interpretationContext.peekObject()) != iADataForComplexProperty.getNestedComplexProperty()) {
            this.addError("The object on the top the of the stack is not the component pushed earlier.");
        } else {
            interpretationContext.popObject();
            switch (iADataForComplexProperty.aggregationType) {
                case AS_COMPLEX_PROPERTY: {
                    iADataForComplexProperty.parentBean.setComplexProperty(string, iADataForComplexProperty.getNestedComplexProperty());
                    break;
                }
                case AS_COMPLEX_PROPERTY_COLLECTION: {
                    iADataForComplexProperty.parentBean.addComplexProperty(string, iADataForComplexProperty.getNestedComplexProperty());
                }
            }
        }
    }
}

