/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.android;

import android.util.Log;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogcatAppender
extends AppenderBase<ILoggingEvent> {
    private static final int MAX_TAG_LENGTH = 23;
    private PatternLayoutEncoder encoder = null;
    private PatternLayoutEncoder tagEncoder = null;
    private boolean checkLoggable = false;

    @Override
    public void start() {
        if (this.encoder == null || this.encoder.getLayout() == null) {
            this.addError("No layout set for the appender named [" + this.name + "].");
            return;
        }
        if (this.tagEncoder != null) {
            Layout layout = this.tagEncoder.getLayout();
            if (layout == null) {
                this.addError("No tag layout set for the appender named [" + this.name + "].");
                return;
            }
            if (layout instanceof PatternLayout) {
                String string = this.tagEncoder.getPattern();
                if (!string.contains("%nopex")) {
                    this.tagEncoder.stop();
                    this.tagEncoder.setPattern(string + "%nopex");
                    this.tagEncoder.start();
                }
                PatternLayout patternLayout = (PatternLayout)layout;
                patternLayout.setPostCompileProcessor(null);
            }
        }
        super.start();
    }

    @Override
    public void append(ILoggingEvent iLoggingEvent) {
        if (!this.isStarted()) {
            return;
        }
        String string = this.getTag(iLoggingEvent);
        switch (iLoggingEvent.getLevel().levelInt) {
            case -2147483648: 
            case 5000: {
                if (this.checkLoggable && !Log.isLoggable((String)string, (int)2)) break;
                Log.v((String)string, (String)this.encoder.getLayout().doLayout(iLoggingEvent));
                break;
            }
            case 10000: {
                if (this.checkLoggable && !Log.isLoggable((String)string, (int)3)) break;
                Log.d((String)string, (String)this.encoder.getLayout().doLayout(iLoggingEvent));
                break;
            }
            case 20000: {
                if (this.checkLoggable && !Log.isLoggable((String)string, (int)4)) break;
                Log.i((String)string, (String)this.encoder.getLayout().doLayout(iLoggingEvent));
                break;
            }
            case 30000: {
                if (this.checkLoggable && !Log.isLoggable((String)string, (int)5)) break;
                Log.w((String)string, (String)this.encoder.getLayout().doLayout(iLoggingEvent));
                break;
            }
            case 40000: {
                if (this.checkLoggable && !Log.isLoggable((String)string, (int)6)) break;
                Log.e((String)string, (String)this.encoder.getLayout().doLayout(iLoggingEvent));
                break;
            }
        }
    }

    public PatternLayoutEncoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(PatternLayoutEncoder patternLayoutEncoder) {
        this.encoder = patternLayoutEncoder;
    }

    public PatternLayoutEncoder getTagEncoder() {
        return this.tagEncoder;
    }

    public void setTagEncoder(PatternLayoutEncoder patternLayoutEncoder) {
        this.tagEncoder = patternLayoutEncoder;
    }

    public void setCheckLoggable(boolean bl) {
        this.checkLoggable = bl;
    }

    public boolean getCheckLoggable() {
        return this.checkLoggable;
    }

    protected String getTag(ILoggingEvent iLoggingEvent) {
        String string;
        String string2 = string = this.tagEncoder != null ? this.tagEncoder.getLayout().doLayout(iLoggingEvent) : iLoggingEvent.getLoggerName();
        if (this.checkLoggable && string.length() > 23) {
            string = string.substring(0, 22) + "*";
        }
        return string;
    }
}

