/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.android;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteStatement;
import ch.qos.logback.classic.db.SQLBuilder;
import ch.qos.logback.classic.db.names.DBNameResolver;
import ch.qos.logback.classic.db.names.DefaultDBNameResolver;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.android.CommonPathUtil;
import java.io.File;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLiteAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private SQLiteDatabase db;
    private String insertPropertiesSQL;
    private String insertExceptionSQL;
    private String insertSQL;
    private DBNameResolver dbNameResolver;
    private static final int TIMESTMP_INDEX = 1;
    private static final int FORMATTED_MESSAGE_INDEX = 2;
    private static final int LOGGER_NAME_INDEX = 3;
    private static final int LEVEL_STRING_INDEX = 4;
    private static final int THREAD_NAME_INDEX = 5;
    private static final int REFERENCE_FLAG_INDEX = 6;
    private static final int ARG0_INDEX = 7;
    private static final int CALLER_FILENAME_INDEX = 11;
    private static final int CALLER_CLASS_INDEX = 12;
    private static final int CALLER_METHOD_INDEX = 13;
    private static final int CALLER_LINE_INDEX = 14;
    private static final short PROPERTIES_EXIST = 1;
    private static final short EXCEPTION_EXISTS = 2;

    public void setDbNameResolver(DBNameResolver dBNameResolver) {
        this.dbNameResolver = dBNameResolver;
    }

    @Override
    public void start() {
        this.started = false;
        String string = null;
        if (this.getContext() != null) {
            string = this.getContext().getProperty("PACKAGE_NAME");
        }
        if (string == null || string.length() == 0) {
            this.addError("Cannot create database without package name");
            return;
        }
        boolean bl = false;
        try {
            File file = new File(CommonPathUtil.getDatabaseDirectoryPath(string), "logback.db");
            file.getParentFile().mkdirs();
            this.db = SQLiteDatabase.openOrCreateDatabase((String)file.getPath(), null);
            bl = true;
        }
        catch (SQLiteException sQLiteException) {
            this.addError("Cannot open database", sQLiteException);
        }
        if (bl) {
            if (this.dbNameResolver == null) {
                this.dbNameResolver = new DefaultDBNameResolver();
            }
            this.insertExceptionSQL = SQLBuilder.buildInsertExceptionSQL(this.dbNameResolver);
            this.insertPropertiesSQL = SQLBuilder.buildInsertPropertiesSQL(this.dbNameResolver);
            this.insertSQL = SQLBuilder.buildInsertSQL(this.dbNameResolver);
            try {
                this.db.execSQL(SQLBuilder.buildCreateLoggingEventTableSQL(this.dbNameResolver));
                this.db.execSQL(SQLBuilder.buildCreatePropertyTableSQL(this.dbNameResolver));
                this.db.execSQL(SQLBuilder.buildCreateExceptionTableSQL(this.dbNameResolver));
                super.start();
                this.started = true;
            }
            catch (SQLiteException sQLiteException) {
                this.addError("Cannot create database tables", sQLiteException);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.db.close();
    }

    @Override
    public void stop() {
        this.db.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(ILoggingEvent iLoggingEvent) {
        if (this.isStarted()) {
            try {
                SQLiteStatement sQLiteStatement = this.db.compileStatement(this.insertSQL);
                try {
                    this.db.beginTransaction();
                    long l = this.subAppend(iLoggingEvent, sQLiteStatement);
                    if (l != -1L) {
                        this.secondarySubAppend(iLoggingEvent, l);
                        this.db.setTransactionSuccessful();
                    }
                }
                finally {
                    if (this.db.inTransaction()) {
                        this.db.endTransaction();
                    }
                    sQLiteStatement.close();
                }
            }
            catch (Throwable throwable) {
                this.addError("Cannot append event", throwable);
            }
        }
    }

    private long subAppend(ILoggingEvent iLoggingEvent, SQLiteStatement sQLiteStatement) throws SQLException {
        this.bindLoggingEvent(sQLiteStatement, iLoggingEvent);
        this.bindLoggingEventArguments(sQLiteStatement, iLoggingEvent.getArgumentArray());
        this.bindCallerData(sQLiteStatement, iLoggingEvent.getCallerData());
        long l = -1L;
        try {
            l = sQLiteStatement.executeInsert();
        }
        catch (SQLiteException sQLiteException) {
            this.addWarn("Failed to insert loggingEvent", sQLiteException);
        }
        return l;
    }

    private void secondarySubAppend(ILoggingEvent iLoggingEvent, long l) throws SQLException {
        Map<String, String> map = this.mergePropertyMaps(iLoggingEvent);
        this.insertProperties(map, l);
        if (iLoggingEvent.getThrowableProxy() != null) {
            this.insertThrowable(iLoggingEvent.getThrowableProxy(), l);
        }
    }

    private void bindLoggingEvent(SQLiteStatement sQLiteStatement, ILoggingEvent iLoggingEvent) throws SQLException {
        sQLiteStatement.bindLong(1, iLoggingEvent.getTimeStamp());
        sQLiteStatement.bindString(2, iLoggingEvent.getFormattedMessage());
        sQLiteStatement.bindString(3, iLoggingEvent.getLoggerName());
        sQLiteStatement.bindString(4, iLoggingEvent.getLevel().toString());
        sQLiteStatement.bindString(5, iLoggingEvent.getThreadName());
        sQLiteStatement.bindLong(6, (long)SQLiteAppender.computeReferenceMask(iLoggingEvent));
    }

    private void bindLoggingEventArguments(SQLiteStatement sQLiteStatement, Object[] objectArray) throws SQLException {
        int n = objectArray != null ? objectArray.length : 0;
        for (int i = 0; i < n && i < 4; ++i) {
            sQLiteStatement.bindString(7 + i, this.asStringTruncatedTo254(objectArray[i]));
        }
    }

    private String asStringTruncatedTo254(Object object) {
        String string = null;
        if (object != null) {
            string = object.toString();
        }
        if (string != null && string.length() > 254) {
            string = string.substring(0, 254);
        }
        return string == null ? "" : string;
    }

    private static short computeReferenceMask(ILoggingEvent iLoggingEvent) {
        short s = 0;
        int n = 0;
        if (iLoggingEvent.getMDCPropertyMap() != null) {
            n = iLoggingEvent.getMDCPropertyMap().keySet().size();
        }
        int n2 = 0;
        if (iLoggingEvent.getLoggerContextVO().getPropertyMap() != null) {
            n2 = iLoggingEvent.getLoggerContextVO().getPropertyMap().size();
        }
        if (n > 0 || n2 > 0) {
            s = 1;
        }
        if (iLoggingEvent.getThrowableProxy() != null) {
            s = (short)(s | 2);
        }
        return s;
    }

    private Map<String, String> mergePropertyMaps(ILoggingEvent iLoggingEvent) {
        Map<String, String> map;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Map<String, String> map2 = iLoggingEvent.getLoggerContextVO().getPropertyMap();
        if (map2 != null) {
            hashMap.putAll(map2);
        }
        if ((map = iLoggingEvent.getMDCPropertyMap()) != null) {
            hashMap.putAll(map);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertProperties(Map<String, String> map, long l) throws SQLException {
        if (map.size() > 0) {
            SQLiteStatement sQLiteStatement = this.db.compileStatement(this.insertPropertiesSQL);
            try {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    sQLiteStatement.bindLong(1, l);
                    sQLiteStatement.bindString(2, entry.getKey());
                    sQLiteStatement.bindString(3, entry.getValue());
                    sQLiteStatement.executeInsert();
                }
            }
            finally {
                sQLiteStatement.close();
            }
        }
    }

    private void bindCallerData(SQLiteStatement sQLiteStatement, StackTraceElement[] stackTraceElementArray) throws SQLException {
        StackTraceElement stackTraceElement;
        if (stackTraceElementArray != null && stackTraceElementArray.length > 0 && (stackTraceElement = stackTraceElementArray[0]) != null) {
            sQLiteStatement.bindString(11, stackTraceElement.getFileName());
            sQLiteStatement.bindString(12, stackTraceElement.getClassName());
            sQLiteStatement.bindString(13, stackTraceElement.getMethodName());
            sQLiteStatement.bindString(14, Integer.toString(stackTraceElement.getLineNumber()));
        }
    }

    private void insertException(SQLiteStatement sQLiteStatement, String string, short s, long l) throws SQLException {
        sQLiteStatement.bindLong(1, l);
        sQLiteStatement.bindLong(2, (long)s);
        sQLiteStatement.bindString(3, string);
        sQLiteStatement.executeInsert();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertThrowable(IThrowableProxy iThrowableProxy, long l) throws SQLException {
        SQLiteStatement sQLiteStatement = this.db.compileStatement(this.insertExceptionSQL);
        try {
            short s = 0;
            while (iThrowableProxy != null) {
                StringBuilder stringBuilder = new StringBuilder();
                ThrowableProxyUtil.subjoinFirstLine(stringBuilder, iThrowableProxy);
                short s2 = s;
                s = (short)(s + 1);
                this.insertException(sQLiteStatement, stringBuilder.toString(), s2, l);
                int n = iThrowableProxy.getCommonFrames();
                StackTraceElementProxy[] stackTraceElementProxyArray = iThrowableProxy.getStackTraceElementProxyArray();
                for (int i = 0; i < stackTraceElementProxyArray.length - n; ++i) {
                    StringBuilder stringBuilder2 = new StringBuilder();
                    stringBuilder2.append('\t');
                    ThrowableProxyUtil.subjoinSTEP(stringBuilder2, stackTraceElementProxyArray[i]);
                    short s3 = s;
                    s = (short)(s + 1);
                    this.insertException(sQLiteStatement, stringBuilder2.toString(), s3, l);
                }
                if (n > 0) {
                    StringBuilder stringBuilder3 = new StringBuilder();
                    stringBuilder3.append('\t').append("... ").append(n).append(" common frames omitted");
                    short s4 = s;
                    s = (short)(s + 1);
                    this.insertException(sQLiteStatement, stringBuilder3.toString(), s4, l);
                }
                iThrowableProxy = iThrowableProxy.getCause();
            }
        }
        finally {
            sQLiteStatement.close();
        }
    }
}

