/*
 * Decompiled with CFR 0.152.
 */
package com.robin.lazy.logger;

import android.os.Environment;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import com.robin.lazy.logger.LogTool;
import com.robin.lazy.logger.slf4j.Slf4jConfigurator;
import java.io.File;
import org.slf4j.LoggerFactory;

public class SLF4JTool
implements LogTool {
    private Logger log;
    private String curTag;
    private Level mLevel;

    public SLF4JTool() {
        this(Level.ERROR);
    }

    public SLF4JTool(Level level) {
        this(level, "MyLog", "applog");
    }

    public SLF4JTool(Level level, String dirName, String fileName) {
        this.mLevel = level;
        Slf4jConfigurator logConfigurator = new Slf4jConfigurator();
        fileName = fileName + "_%d{yyyyMMdd}";
        logConfigurator.setFileNamePattern(this.getFile(dirName, fileName));
        logConfigurator.setLevel(level);
        logConfigurator.configure();
    }

    @Override
    public void d(String tag, String message) {
        this.resetLog(tag);
        this.log.debug(message);
    }

    @Override
    public void d(String tag, String message, Throwable throwable) {
        this.resetLog(tag);
        this.log.debug(message, throwable);
    }

    @Override
    public void e(String tag, String message) {
        this.resetLog(tag);
        this.log.error(message);
    }

    @Override
    public void e(String tag, String message, Throwable throwable) {
        this.resetLog(tag);
        this.log.error(message, throwable);
    }

    @Override
    public void w(String tag, String message) {
        this.resetLog(tag);
        this.log.warn(message);
    }

    @Override
    public void w(String tag, String message, Throwable throwable) {
        this.resetLog(tag);
        this.log.warn(message, throwable);
    }

    @Override
    public void i(String tag, String message) {
        this.resetLog(tag);
        this.log.info(message);
    }

    @Override
    public void i(String tag, String message, Throwable throwable) {
        this.resetLog(tag);
        this.log.info(message, throwable);
    }

    @Override
    public void v(String tag, String message) {
        this.resetLog(tag);
        this.log.trace(message);
    }

    @Override
    public void v(String tag, String message, Throwable throwable) {
        this.resetLog(tag);
        this.log.trace(message, throwable);
    }

    @Override
    public void wtf(String tag, String message) {
        this.resetLog(tag);
        this.log.debug(message);
    }

    @Override
    public void wtf(String tag, String message, Throwable throwable) {
        this.resetLog(tag);
        this.log.debug(message, throwable);
    }

    private String getFile(String dirName, String fileName) {
        File cacheDir;
        String sdDir = null;
        if (Environment.getExternalStorageState().equals("mounted")) {
            sdDir = Environment.getExternalStorageDirectory().toString();
        }
        if (!(cacheDir = new File(sdDir + File.separator + dirName)).exists()) {
            cacheDir.mkdir();
        }
        File filePath = new File(cacheDir + File.separator + fileName + ".log");
        return filePath.toString();
    }

    private void resetLog(String tag) {
        if (this.curTag == null) {
            this.curTag = tag;
            this.log = (Logger)LoggerFactory.getLogger((String)tag);
            this.log.setLevel(this.mLevel);
        } else if (!this.curTag.equals(tag)) {
            this.curTag = tag;
            this.log = null;
            this.log = (Logger)LoggerFactory.getLogger((String)tag);
            this.log.setLevel(this.mLevel);
        }
    }
}

