/*
 * Decompiled with CFR 0.152.
 */
package com.robin.lazy.logger;

import android.os.Environment;
import com.robin.lazy.logger.LogTool;
import com.robin.lazy.logger.log4j.LogConfigurator;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class Log4JTool
implements LogTool {
    private Logger log;
    private String curTag;
    private Level mLevel;

    public Log4JTool() {
        this(Level.ERROR);
    }

    public Log4JTool(Level level) {
        this(level, "MyLog", "applog");
    }

    public Log4JTool(Level level, String dirName, String fileName) {
        this.mLevel = level;
        LogConfigurator logConfigurator = new LogConfigurator();
        logConfigurator.setFileName(this.getFile(dirName, fileName));
        logConfigurator.setRootLevel(Level.DEBUG);
        logConfigurator.setLevel("org.apache", level);
        logConfigurator.configure();
    }

    @Override
    public void d(String tag, String message) {
        this.resetLog(tag);
        this.log.debug((Object)message);
    }

    @Override
    public void d(String tag, String message, Throwable throwable) {
        this.resetLog(tag);
        this.log.debug((Object)message, throwable);
    }

    @Override
    public void e(String tag, String message) {
        this.resetLog(tag);
        this.log.error((Object)message);
    }

    @Override
    public void e(String tag, String message, Throwable throwable) {
        this.resetLog(tag);
        this.log.error((Object)message, throwable);
    }

    @Override
    public void w(String tag, String message) {
        this.resetLog(tag);
        this.log.warn((Object)message);
    }

    @Override
    public void w(String tag, String message, Throwable throwable) {
        this.resetLog(tag);
        this.log.warn((Object)message, throwable);
    }

    @Override
    public void i(String tag, String message) {
        this.resetLog(tag);
        this.log.info((Object)message);
    }

    @Override
    public void i(String tag, String message, Throwable throwable) {
        this.resetLog(tag);
        this.log.info((Object)message, throwable);
    }

    @Override
    public void v(String tag, String message) {
        this.resetLog(tag);
        this.log.trace((Object)message);
    }

    @Override
    public void v(String tag, String message, Throwable throwable) {
        this.resetLog(tag);
        this.log.trace((Object)message, throwable);
    }

    @Override
    public void wtf(String tag, String message) {
        this.resetLog(tag);
        this.log.fatal((Object)message);
    }

    @Override
    public void wtf(String tag, String message, Throwable throwable) {
        this.resetLog(tag);
        this.log.fatal((Object)message, throwable);
    }

    private String getFile(String dirName, String fileName) {
        File filePath;
        File cacheDir;
        String sdDir = null;
        if (Environment.getExternalStorageState().equals("mounted")) {
            sdDir = Environment.getExternalStorageDirectory().toString();
        }
        if (!(cacheDir = new File(sdDir + File.separator + dirName)).exists()) {
            cacheDir.mkdir();
        }
        if (!(filePath = new File(cacheDir + File.separator + fileName + ".log")).exists()) {
            try {
                filePath.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return filePath.toString();
    }

    private void resetLog(String tag) {
        if (this.curTag == null) {
            this.curTag = tag;
            this.log = Logger.getLogger((String)tag);
            this.log.setLevel(this.mLevel);
        } else if (!this.curTag.equals(tag)) {
            this.curTag = tag;
            this.log = null;
            this.log = Logger.getLogger((String)tag);
            this.log.setLevel(this.mLevel);
        }
    }
}

