/*
 * Decompiled with CFR 0.152.
 */
package com.robertlevonyan.views.chip;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import com.robertlevonyan.views.chip.R;

class ChipUtils {
    public static final int IMAGE_ID = 9504024;
    public static final int TEXT_ID = 364824;

    ChipUtils() {
    }

    public static Bitmap getScaledBitmap(Context context, Bitmap bitmap) {
        int width = (int)context.getResources().getDimension(R.dimen.chip_height);
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)width, (boolean)false);
    }

    public static Bitmap getSquareBitmap(Bitmap bitmap) {
        Bitmap output = bitmap.getWidth() >= bitmap.getHeight() ? Bitmap.createBitmap((Bitmap)bitmap, (int)(bitmap.getWidth() / 2 - bitmap.getHeight() / 2), (int)0, (int)bitmap.getHeight(), (int)bitmap.getHeight()) : Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)(bitmap.getHeight() / 2 - bitmap.getWidth() / 2), (int)bitmap.getWidth(), (int)bitmap.getWidth());
        return output;
    }

    public static Bitmap getCircleBitmap(Context context, Bitmap bitmap) {
        int width = (int)context.getResources().getDimension(R.dimen.chip_height);
        Bitmap output = Bitmap.createBitmap((int)width, (int)width, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color2 = -65536;
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, width, width);
        RectF rectF = new RectF(rect);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-65536);
        canvas.drawOval(rectF, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return output;
    }

    public static void setIconColor(ImageView icon, int color2) {
        Drawable iconDrawable = icon.getDrawable();
        icon.setColorFilter((ColorFilter)new PorterDuffColorFilter(color2, PorterDuff.Mode.SRC_ATOP));
        icon.setImageDrawable(iconDrawable);
    }
}

