/*
 * Decompiled with CFR 0.152.
 */
package com.robertlevonyan.views.chip;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.PaintDrawable;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.robertlevonyan.views.chip.ChipUtils;
import com.robertlevonyan.views.chip.OnChipClickListener;
import com.robertlevonyan.views.chip.OnCloseClickListener;
import com.robertlevonyan.views.chip.OnIconClickListener;
import com.robertlevonyan.views.chip.OnSelectClickListener;
import com.robertlevonyan.views.chip.R;

public class Chip
extends RelativeLayout {
    private String chipText;
    private boolean hasIcon;
    private Drawable chipIcon;
    private boolean closable;
    private boolean selectable;
    private int backgroundColor;
    private int selectedBackgroundColor;
    private int textColor;
    private int selectedTextColor;
    private int closeColor;
    private int selectedCloseColor;
    private ImageView closeIcon;
    private ImageView selectIcon;
    private boolean clicked;
    private boolean selected;
    private OnCloseClickListener onCloseClickListener;
    private OnSelectClickListener onSelectClickListener;
    private OnChipClickListener onChipClickListener;
    private OnIconClickListener onIconClickListener;

    public Chip(Context context) {
        this(context, null, 0);
    }

    public Chip(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public Chip(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initTypedArray(attrs);
        this.initChipClick();
    }

    private void initChipClick() {
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (Chip.this.onChipClickListener != null) {
                    Chip.this.onChipClickListener.onChipClick(v);
                }
            }
        });
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (Build.VERSION.SDK_INT >= 24) {
            this.buildView();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        ViewGroup.LayoutParams thisParams = this.getLayoutParams();
        thisParams.width = -2;
        thisParams.height = (int)this.getResources().getDimension(R.dimen.chip_height);
        this.setLayoutParams(thisParams);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (Build.VERSION.SDK_INT < 24) {
            this.buildView();
        }
    }

    private void buildView() {
        this.initBackgroundColor();
        this.initTextView();
        this.initImageIcon();
        this.initCloseIcon();
        this.initSelectIcon();
    }

    private void initSelectClick() {
        this.selectIcon.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: 
                    case 5: {
                        Chip.this.onSelectTouchDown();
                        break;
                    }
                    case 1: 
                    case 6: {
                        Chip.this.onSelectTouchUp(v);
                        break;
                    }
                }
                return true;
            }
        });
    }

    private void onSelectTouchDown() {
        this.clicked = true;
        this.initBackgroundColor();
        this.initTextView();
        this.selectIcon.setImageResource(R.drawable.ic_select);
        ChipUtils.setIconColor(this.selectIcon, this.selectedCloseColor);
    }

    private void onSelectTouchUp(View v) {
        if (this.selected) {
            this.clicked = false;
            this.initBackgroundColor();
            this.initTextView();
            this.selectIcon.setImageResource(R.drawable.ic_select);
            ChipUtils.setIconColor(this.selectIcon, this.closeColor);
        }
        boolean bl = this.selected = !this.selected;
        if (this.onSelectClickListener != null) {
            this.onSelectClickListener.onSelectClick(v, this.selected);
        }
    }

    private void initCloseClick() {
        this.closeIcon.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: 
                    case 5: {
                        Chip.this.onCloseTouchDown();
                        break;
                    }
                    case 1: 
                    case 6: {
                        Chip.this.onCloseTouchUp(v);
                        break;
                    }
                }
                return true;
            }
        });
    }

    private void onCloseTouchDown() {
        this.clicked = true;
        this.initBackgroundColor();
        this.initTextView();
        this.closeIcon.setImageResource(R.drawable.ic_close);
        ChipUtils.setIconColor(this.closeIcon, this.selectedCloseColor);
    }

    private void onCloseTouchUp(View v) {
        this.clicked = false;
        this.initBackgroundColor();
        this.initTextView();
        this.closeIcon.setImageResource(R.drawable.ic_close);
        ChipUtils.setIconColor(this.closeIcon, this.closeColor);
        if (this.onCloseClickListener != null) {
            this.onCloseClickListener.onCloseClick(v);
        }
    }

    private void initSelectIcon() {
        if (!this.selectable) {
            return;
        }
        this.selectIcon = new ImageView(this.getContext());
        RelativeLayout.LayoutParams selectIconParams = new RelativeLayout.LayoutParams((int)this.getResources().getDimension(R.dimen.chip_close_icon_size2), (int)this.getResources().getDimension(R.dimen.chip_close_icon_size2));
        selectIconParams.addRule(Build.VERSION.SDK_INT >= 17 ? 17 : 1, 364824);
        selectIconParams.addRule(15);
        selectIconParams.setMargins((int)this.getResources().getDimension(R.dimen.chip_close_horizontal_margin), 0, (int)this.getResources().getDimension(R.dimen.chip_close_horizontal_margin), 0);
        this.selectIcon.setLayoutParams((ViewGroup.LayoutParams)selectIconParams);
        this.selectIcon.setScaleType(ImageView.ScaleType.CENTER);
        this.selectIcon.setImageResource(R.drawable.ic_select);
        ChipUtils.setIconColor(this.selectIcon, this.closeColor);
        this.initSelectClick();
        this.addView((View)this.selectIcon);
    }

    private void initCloseIcon() {
        if (!this.closable) {
            return;
        }
        this.closeIcon = new ImageView(this.getContext());
        RelativeLayout.LayoutParams closeIconParams = new RelativeLayout.LayoutParams((int)this.getResources().getDimension(R.dimen.chip_close_icon_size2), (int)this.getResources().getDimension(R.dimen.chip_close_icon_size2));
        closeIconParams.addRule(Build.VERSION.SDK_INT >= 17 ? 17 : 1, 364824);
        closeIconParams.addRule(15);
        closeIconParams.setMargins((int)this.getResources().getDimension(R.dimen.chip_close_horizontal_margin), 0, (int)this.getResources().getDimension(R.dimen.chip_close_horizontal_margin), 0);
        this.closeIcon.setLayoutParams((ViewGroup.LayoutParams)closeIconParams);
        this.closeIcon.setScaleType(ImageView.ScaleType.CENTER);
        this.closeIcon.setImageResource(R.drawable.ic_close);
        ChipUtils.setIconColor(this.closeIcon, this.closeColor);
        this.initCloseClick();
        this.addView((View)this.closeIcon);
    }

    private void initImageIcon() {
        if (!this.hasIcon) {
            return;
        }
        ImageView icon = new ImageView(this.getContext());
        RelativeLayout.LayoutParams iconParams = new RelativeLayout.LayoutParams((int)this.getResources().getDimension(R.dimen.chip_height), (int)this.getResources().getDimension(R.dimen.chip_height));
        iconParams.addRule(Build.VERSION.SDK_INT >= 17 ? 20 : 9);
        icon.setLayoutParams((ViewGroup.LayoutParams)iconParams);
        icon.setScaleType(ImageView.ScaleType.FIT_CENTER);
        icon.setId(9504024);
        if (this.chipIcon != null && ((BitmapDrawable)this.chipIcon).getBitmap() != null) {
            Bitmap bitmap = ((BitmapDrawable)this.chipIcon).getBitmap();
            bitmap = ChipUtils.getSquareBitmap(bitmap);
            bitmap = ChipUtils.getScaledBitmap(this.getContext(), bitmap);
            icon.setImageBitmap(ChipUtils.getCircleBitmap(this.getContext(), bitmap));
        }
        icon.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (Chip.this.onIconClickListener != null) {
                    Chip.this.onIconClickListener.onIconClick(v);
                }
            }
        });
        this.addView((View)icon);
    }

    private void initTextView() {
        TextView chipTextView = new TextView(this.getContext());
        RelativeLayout.LayoutParams chipTextParams = new RelativeLayout.LayoutParams(-2, -2);
        if (this.hasIcon || this.closable || this.selectable) {
            chipTextParams.addRule(Build.VERSION.SDK_INT >= 17 ? 17 : 1, 9504024);
            chipTextParams.addRule(15);
        } else {
            chipTextParams.addRule(13);
        }
        int startMargin = this.hasIcon ? (int)this.getResources().getDimension(R.dimen.chip_icon_horizontal_margin) : (int)this.getResources().getDimension(R.dimen.chip_horizontal_padding);
        int endMargin = this.closable || this.selectable ? 0 : (int)this.getResources().getDimension(R.dimen.chip_horizontal_padding);
        chipTextParams.setMargins(startMargin, 0, endMargin, 0);
        chipTextView.setLayoutParams((ViewGroup.LayoutParams)chipTextParams);
        chipTextView.setTextColor(this.clicked ? this.selectedTextColor : this.textColor);
        chipTextView.setText((CharSequence)this.chipText);
        chipTextView.setId(364824);
        this.addView((View)chipTextView);
    }

    private void initBackgroundColor() {
        PaintDrawable bgDrawable = new PaintDrawable(this.clicked ? this.selectedBackgroundColor : this.backgroundColor);
        bgDrawable.setCornerRadius(this.getResources().getDimension(R.dimen.chip_height) / 2.0f);
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground((Drawable)bgDrawable);
        } else {
            this.setBackgroundDrawable((Drawable)bgDrawable);
        }
    }

    private void initTypedArray(AttributeSet attrs) {
        TypedArray ta = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.Chip, 0, 0);
        this.chipText = ta.getString(R.styleable.Chip_chipText);
        this.hasIcon = ta.getBoolean(R.styleable.Chip_hasIcon, false);
        this.chipIcon = ta.getDrawable(R.styleable.Chip_chipIcon);
        this.closable = ta.getBoolean(R.styleable.Chip_closable, false);
        this.selectable = ta.getBoolean(R.styleable.Chip_selectable, false);
        this.backgroundColor = ta.getColor(R.styleable.Chip_backgroundColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.colorChipBackground));
        this.selectedBackgroundColor = ta.getColor(R.styleable.Chip_selectedBackgroundColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.colorChipBackgroundClicked));
        this.textColor = ta.getColor(R.styleable.Chip_textColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.colorChipText));
        this.selectedTextColor = ta.getColor(R.styleable.Chip_selectedTextColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.colorChipTextClicked));
        this.closeColor = ta.getColor(R.styleable.Chip_closeColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.colorChipCloseInactive));
        this.selectedCloseColor = ta.getColor(R.styleable.Chip_selectedCloseColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.colorChipCloseClicked));
        ta.recycle();
    }

    public String getChipText() {
        return this.chipText;
    }

    public void setChipText(String chipText) {
        this.chipText = chipText;
    }

    public boolean isHasIcon() {
        return this.hasIcon;
    }

    public void setHasIcon(boolean hasIcon) {
        this.hasIcon = hasIcon;
    }

    public Drawable getChipIcon() {
        return this.chipIcon;
    }

    public void setChipIcon(Drawable chipIcon) {
        this.chipIcon = chipIcon;
    }

    public boolean isClosable() {
        return this.closable;
    }

    public void setClosable(boolean closable) {
        this.closable = closable;
        this.selectable = false;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void changeBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public int getSelectedBackgroundColor() {
        return this.selectedBackgroundColor;
    }

    public void changeSelectedBackgroundColor(int selectedBackgroundColor) {
        this.selectedBackgroundColor = selectedBackgroundColor;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public int getSelectedTextColor() {
        return this.selectedTextColor;
    }

    public void setSelectedTextColor(int selectedTextColor) {
        this.selectedTextColor = selectedTextColor;
    }

    public int getCloseColor() {
        return this.closeColor;
    }

    public void setCloseColor(int closeColor) {
        this.closeColor = closeColor;
    }

    public int getSelectedCloseColor() {
        return this.selectedCloseColor;
    }

    public void setSelectedCloseColor(int selectedCloseColor) {
        this.selectedCloseColor = selectedCloseColor;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
        this.closable = false;
    }

    public void setOnCloseClickListener(OnCloseClickListener onCloseClickListener) {
        this.onCloseClickListener = onCloseClickListener;
    }

    public void setOnSelectClickListener(OnSelectClickListener onSelectClickListener) {
        this.onSelectClickListener = onSelectClickListener;
    }

    public void setOnChipClickListener(OnChipClickListener onChipClickListener) {
        this.onChipClickListener = onChipClickListener;
    }

    public void setOnIconClickListener(OnIconClickListener onIconClickListener) {
        this.onIconClickListener = onIconClickListener;
    }
}

