/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.tesseract.android;

import android.graphics.Rect;

public class PageIterator {
    private final long mNativePageIterator;

    PageIterator(long nativePageIterator) {
        this.mNativePageIterator = nativePageIterator;
    }

    public void begin() {
        PageIterator.nativeBegin(this.mNativePageIterator);
    }

    public boolean next(int level) {
        return PageIterator.nativeNext(this.mNativePageIterator, level);
    }

    public int[] getBoundingBox(int level) {
        return PageIterator.nativeBoundingBox(this.mNativePageIterator, level);
    }

    public Rect getBoundingRect(int level) {
        int[] box = this.getBoundingBox(level);
        return new Rect(box[0], box[1], box[2], box[3]);
    }

    private static native void nativeBegin(long var0);

    private static native boolean nativeNext(long var0, int var2);

    private static native int[] nativeBoundingBox(long var0, int var2);

    static {
        System.loadLibrary("pngt");
        System.loadLibrary("lept");
        System.loadLibrary("tess");
    }
}

