/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import android.graphics.Rect;
import android.util.Log;

public class Boxa {
    private static final String TAG;
    private final long mNativeBoxa;
    private boolean mRecycled = false;

    public Boxa(long nativeBoxa) {
        this.mNativeBoxa = nativeBoxa;
        this.mRecycled = false;
    }

    public long getNativeBoxa() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return this.mNativeBoxa;
    }

    public int getCount() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return Boxa.nativeGetCount(this.mNativeBoxa);
    }

    public Rect getRect(int index) {
        int[] geometry = this.getGeometry(index);
        int left = geometry[0];
        int top = geometry[1];
        int right = left + geometry[2];
        int bottom = top + geometry[3];
        return new Rect(left, top, right, bottom);
    }

    public int[] getGeometry(int index) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        int[] geometry = new int[4];
        if (this.getGeometry(index, geometry)) {
            return geometry;
        }
        return null;
    }

    public boolean getGeometry(int index, int[] geometry) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        if (geometry.length < 4) {
            throw new IllegalArgumentException("Geometry array must be at least 4 elements long");
        }
        return Boxa.nativeGetGeometry(this.mNativeBoxa, index, geometry);
    }

    public synchronized void recycle() {
        if (!this.mRecycled) {
            Boxa.nativeDestroy(this.mNativeBoxa);
            this.mRecycled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.mRecycled) {
                Log.w((String)TAG, (String)"Boxa was not terminated using recycle()");
                this.recycle();
            }
        }
        finally {
            super.finalize();
        }
    }

    private static native void nativeDestroy(long var0);

    private static native boolean nativeGetGeometry(long var0, int var2, int[] var3);

    private static native int nativeGetCount(long var0);

    static {
        System.loadLibrary("pngt");
        System.loadLibrary("lept");
        TAG = Boxa.class.getSimpleName();
    }
}

