/*
 * Decompiled with CFR 0.152.
 */
package com.rm.rmswitch;

import android.animation.LayoutTransition;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.StyleableRes;
import android.support.v4.view.animation.FastOutLinearInInterpolator;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Checkable;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.rm.rmswitch.R;
import com.rm.rmswitch.SquareImageView;
import com.rm.rmswitch.TristateCheckable;
import com.rm.rmswitch.Utils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class RMAbstractSwitch
extends RelativeLayout
implements Checkable,
View.OnClickListener,
TristateCheckable,
View.OnLayoutChangeListener {
    protected String TAG = this.getClass().getSimpleName();
    protected static final String BUNDLE_KEY_SUPER_DATA = "bundle_key_super_data";
    protected static final String BUNDLE_KEY_ENABLED = "bundle_key_enabled";
    protected static final String BUNDLE_KEY_FORCE_ASPECT_RATIO = "bundle_key_force_aspect_ratio";
    protected static final String BUNDLE_KEY_DESIGN = "bundle_key_design";
    protected static final float ALPHA_DISABLED = 0.6f;
    protected static final float ALPHA_ENABLED = 1.0f;
    public static final int STATE_LEFT = 0;
    public static final int STATE_MIDDLE = 1;
    public static final int STATE_RIGHT = 2;
    public static final int DESIGN_LARGE = 0;
    public static final int DESIGN_SLIM = 1;
    public static final int DESIGN_ANDROID = 2;
    protected boolean mForceAspectRatio;
    protected boolean mIsEnabled;
    protected SquareImageView mImgToggle;
    protected ImageView mImgBkg;
    protected int mSwitchDesign;
    protected RelativeLayout mContainerLayout;
    protected static LayoutTransition sLayoutTransition;
    protected static final int ANIMATION_DURATION = 150;

    public RMAbstractSwitch(Context context) {
        this(context, null);
    }

    public RMAbstractSwitch(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMAbstractSwitch(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, this.getTypedArrayResource(), defStyleAttr, 0);
        this.mSwitchDesign = typedArray.getInt(R.styleable.RMSwitch_switchDesign, 0);
        if (this.mSwitchDesign == 0) {
            this.mSwitchDesign = typedArray.getInt(R.styleable.RMTristateSwitch_switchDesign, 0);
        }
        this.setupLayout();
        try {
            this.setupSwitchCustomAttributes(typedArray);
        }
        finally {
            typedArray.recycle();
        }
        this.addOnLayoutChangeListener(this);
        this.setOnClickListener(this);
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(BUNDLE_KEY_SUPER_DATA, super.onSaveInstanceState());
        bundle.putBoolean(BUNDLE_KEY_ENABLED, this.mIsEnabled);
        bundle.putBoolean(BUNDLE_KEY_FORCE_ASPECT_RATIO, this.mForceAspectRatio);
        bundle.putInt(BUNDLE_KEY_DESIGN, this.mSwitchDesign);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        Bundle prevState = (Bundle)state;
        super.onRestoreInstanceState(prevState.getParcelable(BUNDLE_KEY_SUPER_DATA));
        this.mIsEnabled = prevState.getBoolean(BUNDLE_KEY_ENABLED, true);
        this.mForceAspectRatio = prevState.getBoolean(BUNDLE_KEY_FORCE_ASPECT_RATIO, true);
        this.mSwitchDesign = prevState.getInt(BUNDLE_KEY_DESIGN, 0);
    }

    public void setEnabled(boolean enabled) {
        if (this.mIsEnabled != enabled) {
            this.mIsEnabled = enabled;
            this.setupSwitchAppearance();
        }
    }

    public void setForceAspectRatio(boolean forceAspectRatio) {
        if (forceAspectRatio != this.mForceAspectRatio) {
            this.mForceAspectRatio = forceAspectRatio;
            this.setupSwitchAppearance();
        }
    }

    public void setSwitchDesign(int switchDesign) {
        if (switchDesign != this.mSwitchDesign) {
            this.mSwitchDesign = switchDesign;
            this.setupLayout();
            this.setupSwitchAppearance();
        }
        this.addOnLayoutChangeListener(this);
    }

    public boolean isForceAspectRatio() {
        return this.mForceAspectRatio;
    }

    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    public int getSwitchDesign() {
        return this.mSwitchDesign;
    }

    protected void setupLayout() {
        this.removeAllViews();
        if (sLayoutTransition == null) {
            sLayoutTransition = new LayoutTransition();
            sLayoutTransition.setDuration(150L);
            sLayoutTransition.enableTransitionType(4);
            sLayoutTransition.setInterpolator(4, (TimeInterpolator)new FastOutLinearInInterpolator());
        }
        ((LayoutInflater)this.getContext().getSystemService("layout_inflater")).inflate(this.mSwitchDesign == 1 ? R.layout.switch_view_slim : R.layout.switch_view, (ViewGroup)this, true);
        this.mImgToggle = (SquareImageView)this.findViewById(R.id.rm_switch_view_toggle);
        this.mImgBkg = (ImageView)this.findViewById(R.id.rm_switch_view_bkg);
        this.mContainerLayout = (RelativeLayout)this.findViewById(R.id.rm_switch_view_container);
        this.setLayoutTransition(sLayoutTransition);
        this.mContainerLayout.setLayoutTransition(sLayoutTransition);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (widthMode != 0x40000000) {
            int standardWith = this.getSwitchStandardWidth();
            if (widthMode == 0 || widthMode == Integer.MIN_VALUE && standardWith < View.MeasureSpec.getSize((int)widthMeasureSpec)) {
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)standardWith, (int)0x40000000);
            }
        }
        if (heightMode != 0x40000000) {
            int standardHeight = this.getSwitchStandardHeight();
            if (heightMode == 0 || heightMode == Integer.MIN_VALUE && standardHeight < View.MeasureSpec.getSize((int)heightMeasureSpec)) {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)standardHeight, (int)0x40000000);
            }
        }
        if (this.mForceAspectRatio) {
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)((int)((float)View.MeasureSpec.getSize((int)widthMeasureSpec) / this.getSwitchAspectRatio())), (int)View.MeasureSpec.getMode((int)heightMeasureSpec));
        } else if (View.MeasureSpec.getSize((int)widthMeasureSpec) < View.MeasureSpec.getSize((int)heightMeasureSpec)) {
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)widthMeasureSpec), (int)View.MeasureSpec.getMode((int)heightMeasureSpec));
        }
        this.setBkgMargins(heightMeasureSpec, widthMeasureSpec);
        this.setToggleMargins(heightMeasureSpec);
        this.setToggleImagePadding();
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private void setBkgMargins(int heightMeasureSpec, int widthMeasureSpec) {
        int calculatedBackgroundSideMargin = 0;
        int calculatedBackgroundTopBottomMargin = 0;
        if (this.mSwitchDesign == 1 || this.mSwitchDesign == 2) {
            calculatedBackgroundSideMargin = View.MeasureSpec.getSize((int)widthMeasureSpec) / 6;
        }
        if (this.mSwitchDesign == 2) {
            calculatedBackgroundTopBottomMargin = View.MeasureSpec.getSize((int)heightMeasureSpec) / 6;
        }
        ((RelativeLayout.LayoutParams)this.mImgBkg.getLayoutParams()).setMargins(calculatedBackgroundSideMargin, calculatedBackgroundTopBottomMargin, calculatedBackgroundSideMargin, calculatedBackgroundTopBottomMargin);
    }

    private void setToggleMargins(int heightMeasureSpec) {
        Log.e((String)this.TAG, (String)"Margins");
        int calculatedToggleMargin = this.mSwitchDesign == 0 ? (View.MeasureSpec.getSize((int)heightMeasureSpec) > 0 ? View.MeasureSpec.getSize((int)heightMeasureSpec) / 6 : (int)Utils.convertDpToPixel(this.getContext(), 2.0f)) : 0;
        ((RelativeLayout.LayoutParams)this.mImgToggle.getLayoutParams()).setMargins(calculatedToggleMargin, calculatedToggleMargin, calculatedToggleMargin, calculatedToggleMargin);
    }

    private void setToggleImagePadding() {
        Log.e((String)this.TAG, (String)"Paddings");
        int padding = this.mSwitchDesign == 0 ? this.mImgToggle.getHeight() / 10 : this.mImgToggle.getHeight() / 5;
        this.mImgToggle.setPadding(padding, padding, padding, padding);
    }

    protected void removeRules(RelativeLayout.LayoutParams toggleParams, int[] rules) {
        for (int rule : rules) {
            this.removeRule(toggleParams, rule);
        }
    }

    protected void removeRule(RelativeLayout.LayoutParams toggleParams, int rule) {
        if (Build.VERSION.SDK_INT >= 17) {
            toggleParams.removeRule(rule);
        } else {
            toggleParams.addRule(rule, 0);
        }
    }

    protected void setSwitchAlpha() {
        this.setAlpha(this.mIsEnabled ? 1.0f : 0.6f);
    }

    protected void setupSwitchAppearance() {
        Drawable bkgDrawable = this.getSwitchCurrentBkgDrawable();
        Drawable toggleDrawable = this.getSwitchCurrentToggleDrawable();
        Drawable toggleBkgDrawable = this.getSwitchCurrentToggleBkgDrawable();
        if (this.mImgBkg.getDrawable() != null) {
            TransitionDrawable bkgTransitionDrawable = new TransitionDrawable(new Drawable[]{this.mImgBkg.getDrawable() instanceof TransitionDrawable ? ((TransitionDrawable)this.mImgBkg.getDrawable()).getDrawable(1) : this.mImgBkg.getDrawable(), bkgDrawable});
            bkgTransitionDrawable.setCrossFadeEnabled(true);
            this.mImgBkg.setImageDrawable((Drawable)bkgTransitionDrawable);
            bkgTransitionDrawable.startTransition(150);
        } else {
            this.mImgBkg.setImageDrawable(bkgDrawable);
        }
        if (this.mImgToggle.getBackground() != null) {
            TransitionDrawable toggleBkgTransitionDrawable = new TransitionDrawable(new Drawable[]{this.mImgToggle.getBackground() instanceof TransitionDrawable ? ((TransitionDrawable)this.mImgToggle.getBackground()).getDrawable(1) : this.mImgToggle.getBackground(), toggleBkgDrawable});
            toggleBkgTransitionDrawable.setCrossFadeEnabled(true);
            this.mImgToggle.setBackground((Drawable)toggleBkgTransitionDrawable);
            toggleBkgTransitionDrawable.startTransition(150);
        } else {
            this.mImgToggle.setImageDrawable(toggleBkgDrawable);
        }
        if (this.mImgToggle.getDrawable() != null) {
            TransitionDrawable toggleTransitionDrawable = new TransitionDrawable(new Drawable[]{this.mImgToggle.getDrawable() instanceof TransitionDrawable ? ((TransitionDrawable)this.mImgToggle.getDrawable()).getDrawable(1) : this.mImgToggle.getDrawable(), toggleDrawable});
            toggleTransitionDrawable.setCrossFadeEnabled(true);
            this.mImgToggle.setImageDrawable((Drawable)toggleTransitionDrawable);
            toggleTransitionDrawable.startTransition(150);
        } else {
            this.mImgToggle.setImageDrawable(toggleDrawable);
        }
        this.setSwitchAlpha();
    }

    @Override
    public void toggle() {
    }

    @Override
    public void setState(int state) {
    }

    @Override
    public int getState() {
        return 0;
    }

    public void setChecked(boolean b) {
    }

    public boolean isChecked() {
        return false;
    }

    public void onClick(View view) {
        if (this.mIsEnabled) {
            this.toggle();
        }
    }

    public abstract float getSwitchAspectRatio();

    public abstract int getSwitchStandardWidth();

    public abstract int getSwitchStandardHeight();

    public abstract Drawable getSwitchCurrentToggleDrawable();

    public abstract Drawable getSwitchCurrentToggleBkgDrawable();

    public abstract Drawable getSwitchCurrentBkgDrawable();

    @StyleableRes
    public abstract int[] getTypedArrayResource();

    protected abstract void changeToggleGravity();

    protected abstract void setupSwitchCustomAttributes(TypedArray var1);

    public void onLayoutChange(View view, int i, int i1, int i2, int i3, int i4, int i5, int i6, int i7) {
        this.removeOnLayoutChangeListener(this);
        this.measure(this.getMeasuredWidth(), this.getMeasuredHeight());
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SwitchDesign {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }
}

