/*
 * Decompiled with CFR 0.152.
 */
package com.rm.rmswitch;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.rm.rmswitch.R;
import com.rm.rmswitch.RMAbstractSwitch;
import com.rm.rmswitch.Utils;
import java.util.ArrayList;
import java.util.List;

public class RMTristateSwitch
extends RMAbstractSwitch {
    private static final String BUNDLE_KEY_STATE = "bundle_key_state";
    private static final String BUNDLE_KEY_RIGHT_TO_LEFT = "bundle_key_right_to_left";
    private static final String BUNDLE_KEY_BKG_LEFT_COLOR = "bundle_key_bkg_left_color";
    private static final String BUNDLE_KEY_BKG_MIDDLE_COLOR = "bundle_key_bkg_middle_color";
    private static final String BUNDLE_KEY_BKG_RIGHT_COLOR = "bundle_key_bkg_right_color";
    private static final String BUNDLE_KEY_TOGGLE_LEFT_COLOR = "bundle_key_toggle_left_color";
    private static final String BUNDLE_KEY_TOGGLE_MIDDLE_COLOR = "bundle_key_toggle_middle_color";
    private static final String BUNDLE_KEY_TOGGLE_RIGHT_COLOR = "bundle_key_toggle_right_color";
    private static final String BUNDLE_KEY_TOGGLE_LEFT_DRAWABLE = "bundle_key_toggle_left_drawable";
    private static final String BUNDLE_KEY_TOGGLE_MIDDLE_DRAWABLE = "bundle_key_toggle_middle_drawable";
    private static final String BUNDLE_KEY_TOGGLE_RIGHT_DRAWABLE = "bundle_key_toggle_right_drawable";
    private static final float SWITCH_STANDARD_ASPECT_RATIO = 2.6f;
    private List<RMTristateSwitchObserver> mObservers;
    private int mCurrentState;
    private boolean mRightToLeft;
    private int mBkgLeftColor;
    private int mBkgMiddleColor;
    private int mBkgRightColor;
    private int mToggleLeftColor;
    private int mToggleMiddleColor;
    private int mToggleRightColor;
    private Drawable mToggleLeftDrawable;
    private Drawable mToggleMiddleDrawable;
    private Drawable mToggleRightDrawable;

    public RMTristateSwitch(Context context) {
        this(context, null);
    }

    public RMTristateSwitch(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RMTristateSwitch(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public float getSwitchAspectRatio() {
        return 2.6f;
    }

    @Override
    public int getSwitchStandardWidth() {
        return this.getResources().getDimensionPixelSize(this.getSwitchDesign() != 2 ? R.dimen.rm_triswitch_standard_width : R.dimen.rm_triswitch_android_width);
    }

    @Override
    public int getSwitchStandardHeight() {
        return this.getResources().getDimensionPixelSize(this.getSwitchDesign() != 2 ? R.dimen.rm_switch_standard_height : R.dimen.rm_switch_android_height);
    }

    @Override
    public int[] getTypedArrayResource() {
        return R.styleable.RMTristateSwitch;
    }

    private void setMissingImages() {
        if (this.mToggleLeftDrawable != null) {
            this.setMissingImagesFromDrawable(this.mToggleLeftDrawable);
        } else if (this.mToggleMiddleDrawable != null) {
            this.setMissingImagesFromDrawable(this.mToggleMiddleDrawable);
        } else if (this.mToggleRightDrawable != null) {
            this.setMissingImagesFromDrawable(this.mToggleRightDrawable);
        }
    }

    private void setMissingImagesFromDrawable(Drawable resource) {
        if (this.mToggleLeftDrawable == null) {
            this.mToggleLeftDrawable = resource;
        }
        if (this.mToggleMiddleDrawable == null) {
            this.mToggleMiddleDrawable = resource;
        }
        if (this.mToggleRightDrawable == null) {
            this.mToggleRightDrawable = resource;
        }
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Bundle bundle = (Bundle)super.onSaveInstanceState();
        bundle.putInt(BUNDLE_KEY_STATE, this.mCurrentState);
        bundle.putBoolean(BUNDLE_KEY_RIGHT_TO_LEFT, this.mRightToLeft);
        bundle.putInt(BUNDLE_KEY_BKG_LEFT_COLOR, this.mBkgLeftColor);
        bundle.putInt(BUNDLE_KEY_BKG_MIDDLE_COLOR, this.mBkgMiddleColor);
        bundle.putInt(BUNDLE_KEY_BKG_RIGHT_COLOR, this.mBkgRightColor);
        bundle.putInt(BUNDLE_KEY_TOGGLE_LEFT_COLOR, this.mToggleLeftColor);
        bundle.putInt(BUNDLE_KEY_TOGGLE_MIDDLE_COLOR, this.mToggleMiddleColor);
        bundle.putInt(BUNDLE_KEY_TOGGLE_RIGHT_COLOR, this.mToggleRightColor);
        bundle.putParcelable(BUNDLE_KEY_TOGGLE_LEFT_DRAWABLE, this.mToggleLeftDrawable != null ? ((BitmapDrawable)this.mToggleLeftDrawable).getBitmap() : null);
        bundle.putParcelable(BUNDLE_KEY_TOGGLE_MIDDLE_DRAWABLE, this.mToggleMiddleDrawable != null ? ((BitmapDrawable)this.mToggleMiddleDrawable).getBitmap() : null);
        bundle.putParcelable(BUNDLE_KEY_TOGGLE_RIGHT_DRAWABLE, this.mToggleRightDrawable != null ? ((BitmapDrawable)this.mToggleRightDrawable).getBitmap() : null);
        return bundle;
    }

    @Override
    protected void onRestoreInstanceState(Parcelable state) {
        super.onRestoreInstanceState(state);
        Bundle prevState = (Bundle)state;
        this.mBkgLeftColor = prevState.getInt(BUNDLE_KEY_BKG_LEFT_COLOR, Utils.getDefaultBackgroundColor(this.getContext()));
        this.mBkgMiddleColor = prevState.getInt(BUNDLE_KEY_BKG_MIDDLE_COLOR, this.mBkgLeftColor);
        this.mBkgRightColor = prevState.getInt(BUNDLE_KEY_BKG_RIGHT_COLOR, this.mBkgLeftColor);
        this.mToggleLeftColor = prevState.getInt(BUNDLE_KEY_TOGGLE_LEFT_COLOR, -1);
        this.mToggleMiddleColor = prevState.getInt(BUNDLE_KEY_TOGGLE_MIDDLE_COLOR, Utils.getPrimaryColor(this.getContext()));
        this.mToggleRightColor = prevState.getInt(BUNDLE_KEY_TOGGLE_RIGHT_COLOR, Utils.getAccentColor(this.getContext()));
        this.mToggleLeftDrawable = new BitmapDrawable(this.getResources(), (Bitmap)prevState.getParcelable(BUNDLE_KEY_TOGGLE_LEFT_DRAWABLE));
        this.mToggleMiddleDrawable = new BitmapDrawable(this.getResources(), (Bitmap)prevState.getParcelable(BUNDLE_KEY_TOGGLE_MIDDLE_DRAWABLE));
        this.mToggleRightDrawable = new BitmapDrawable(this.getResources(), (Bitmap)prevState.getParcelable(BUNDLE_KEY_TOGGLE_RIGHT_DRAWABLE));
        this.setMissingImages();
        this.setState(prevState.getInt(BUNDLE_KEY_STATE, 0));
        this.notifyObservers();
    }

    public void setRightToLeft(boolean rightToLeft) {
        this.mRightToLeft = rightToLeft;
    }

    public void setSwitchBkgLeftColor(@ColorInt int color) {
        this.mBkgLeftColor = color;
        this.setupSwitchAppearance();
    }

    public void setSwitchBkgMiddleColor(@ColorInt int color) {
        this.mBkgMiddleColor = color;
        this.setupSwitchAppearance();
    }

    public void setSwitchBkgRightColor(@ColorInt int color) {
        this.mBkgRightColor = color;
        this.setupSwitchAppearance();
    }

    public void setSwitchToggleLeftColor(@ColorInt int color) {
        this.mToggleLeftColor = color;
        this.setupSwitchAppearance();
    }

    public void setSwitchToggleMiddleColor(@ColorInt int color) {
        this.mToggleMiddleColor = color;
        this.setupSwitchAppearance();
    }

    public void setSwitchToggleRightColor(@ColorInt int color) {
        this.mToggleRightColor = color;
        this.setupSwitchAppearance();
    }

    public void setSwitchToggleLeftDrawableRes(@DrawableRes int drawable2) {
        this.setSwitchToggleLeftDrawable(drawable2 != 0 ? ContextCompat.getDrawable((Context)this.getContext(), (int)drawable2) : null);
    }

    public void setSwitchToggleMiddleDrawableRes(@DrawableRes int drawable2) {
        this.setSwitchToggleMiddleDrawable(drawable2 != 0 ? ContextCompat.getDrawable((Context)this.getContext(), (int)drawable2) : null);
    }

    public void setSwitchToggleRightDrawableRes(@DrawableRes int drawable2) {
        this.setSwitchToggleRightDrawable(drawable2 != 0 ? ContextCompat.getDrawable((Context)this.getContext(), (int)drawable2) : null);
    }

    public void setSwitchToggleLeftDrawable(Drawable drawable2) {
        this.mToggleLeftDrawable = drawable2;
        this.setMissingImages();
        this.setupSwitchAppearance();
    }

    public void setSwitchToggleMiddleDrawable(Drawable drawable2) {
        this.mToggleMiddleDrawable = drawable2;
        this.setMissingImages();
        this.setupSwitchAppearance();
    }

    public void setSwitchToggleRightDrawable(Drawable drawable2) {
        this.mToggleRightDrawable = drawable2;
        this.setMissingImages();
        this.setupSwitchAppearance();
    }

    public boolean isRightToLeft() {
        return this.mRightToLeft;
    }

    @ColorInt
    public int getSwitchBkgLeftColor() {
        return this.mBkgLeftColor;
    }

    @ColorInt
    public int getSwitchBkgMiddleColor() {
        return this.mBkgMiddleColor;
    }

    @ColorInt
    public int getSwitchBkgRightColor() {
        return this.mBkgRightColor;
    }

    @ColorInt
    public int getSwitchToggleLeftColor() {
        return this.mToggleLeftColor;
    }

    @ColorInt
    public int getSwitchToggleMiddleColor() {
        return this.mToggleMiddleColor;
    }

    @ColorInt
    public int getSwitchToggleRightColor() {
        return this.mToggleRightColor;
    }

    public Drawable getSwitchToggleLeftDrawable() {
        return this.mToggleLeftDrawable;
    }

    public Drawable getSwitchToggleMiddleDrawableRes() {
        return this.mToggleMiddleDrawable;
    }

    public Drawable getSwitchToggleRightDrawableRes() {
        return this.mToggleRightDrawable;
    }

    @Override
    public Drawable getSwitchCurrentToggleDrawable() {
        return this.mCurrentState == 0 ? this.mToggleLeftDrawable : (this.mCurrentState == 1 ? this.mToggleMiddleDrawable : this.mToggleRightDrawable);
    }

    @Override
    public Drawable getSwitchCurrentToggleBkgDrawable() {
        Drawable toggleBkgDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.rounded_border_bkg);
        ((GradientDrawable)toggleBkgDrawable).setColor(this.mCurrentState == 0 ? this.mToggleLeftColor : (this.mCurrentState == 1 ? this.mToggleMiddleColor : this.mToggleRightColor));
        return toggleBkgDrawable;
    }

    @Override
    public Drawable getSwitchCurrentBkgDrawable() {
        Drawable bkgDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.rounded_border_bkg);
        ((GradientDrawable)bkgDrawable).setColor(this.mCurrentState == 0 ? this.mBkgLeftColor : (this.mCurrentState == 1 ? this.mBkgMiddleColor : this.mBkgRightColor));
        return bkgDrawable;
    }

    public void addSwitchObserver(RMTristateSwitchObserver switchObserver) {
        if (switchObserver == null) {
            return;
        }
        if (this.mObservers == null) {
            this.mObservers = new ArrayList<RMTristateSwitchObserver>();
        }
        this.mObservers.add(switchObserver);
    }

    public void removeSwitchObserver(RMTristateSwitchObserver switchObserver) {
        if (switchObserver != null && this.mObservers != null && this.mObservers.size() > 0 && this.mObservers.indexOf(switchObserver) >= 0) {
            this.mObservers.remove(this.mObservers.indexOf(switchObserver));
        }
    }

    private void notifyObservers() {
        if (this.mObservers != null) {
            for (RMTristateSwitchObserver observer : this.mObservers) {
                observer.onCheckStateChange(this, this.mCurrentState);
            }
        }
    }

    public void removeSwitchObservers() {
        if (this.mObservers != null && this.mObservers.size() > 0) {
            this.mObservers.clear();
        }
    }

    @Override
    public void setupSwitchCustomAttributes(TypedArray typedArray) {
        this.mCurrentState = typedArray.getInt(R.styleable.RMTristateSwitch_state, 0);
        this.mForceAspectRatio = typedArray.getBoolean(R.styleable.RMTristateSwitch_forceAspectRatio, true);
        this.mIsEnabled = typedArray.getBoolean(R.styleable.RMTristateSwitch_enabled, true);
        this.mRightToLeft = typedArray.getBoolean(R.styleable.RMTristateSwitch_right_to_left, false);
        this.mBkgLeftColor = typedArray.getColor(R.styleable.RMTristateSwitch_switchBkgLeftColor, Utils.getDefaultBackgroundColor(this.getContext()));
        this.mBkgMiddleColor = typedArray.getColor(R.styleable.RMTristateSwitch_switchBkgMiddleColor, this.mBkgLeftColor);
        this.mBkgRightColor = typedArray.getColor(R.styleable.RMTristateSwitch_switchBkgRightColor, this.mBkgLeftColor);
        this.mToggleLeftColor = typedArray.getColor(R.styleable.RMTristateSwitch_switchToggleLeftColor, -1);
        this.mToggleMiddleColor = typedArray.getColor(R.styleable.RMTristateSwitch_switchToggleMiddleColor, Utils.getPrimaryColor(this.getContext()));
        this.mToggleRightColor = typedArray.getColor(R.styleable.RMTristateSwitch_switchToggleRightColor, Utils.getAccentColor(this.getContext()));
        int toggleLeftDrawableResource = typedArray.getResourceId(R.styleable.RMTristateSwitch_switchToggleLeftImage, 0);
        int toggleMiddleDrawableResource = typedArray.getResourceId(R.styleable.RMTristateSwitch_switchToggleMiddleImage, toggleLeftDrawableResource);
        int toggleRightDrawableResource = typedArray.getResourceId(R.styleable.RMTristateSwitch_switchToggleRightImage, toggleLeftDrawableResource);
        this.mToggleLeftDrawable = toggleLeftDrawableResource != 0 ? ContextCompat.getDrawable((Context)this.getContext(), (int)toggleLeftDrawableResource) : null;
        this.mToggleMiddleDrawable = toggleMiddleDrawableResource != 0 ? ContextCompat.getDrawable((Context)this.getContext(), (int)toggleMiddleDrawableResource) : null;
        this.mToggleRightDrawable = toggleRightDrawableResource != 0 ? ContextCompat.getDrawable((Context)this.getContext(), (int)toggleRightDrawableResource) : null;
        this.setMissingImages();
        this.setState(this.mCurrentState);
    }

    @Override
    protected void changeToggleGravity() {
        RelativeLayout.LayoutParams toggleParams = (RelativeLayout.LayoutParams)this.mImgToggle.getLayoutParams();
        toggleParams.addRule(this.getCurrentLayoutRule());
        this.removePreviousRules(toggleParams);
        this.mImgToggle.setLayoutParams((ViewGroup.LayoutParams)toggleParams);
    }

    private int getCurrentLayoutRule() {
        return this.mCurrentState == 0 ? 9 : (this.mCurrentState == 1 ? 14 : 11);
    }

    private void removePreviousRules(RelativeLayout.LayoutParams toggleParams) {
        if (this.mCurrentState == 0) {
            this.removeRules(toggleParams, new int[]{14, 11});
        }
        if (this.mCurrentState == 1) {
            this.removeRules(toggleParams, new int[]{9, 11});
        }
        if (this.mCurrentState == 2) {
            this.removeRules(toggleParams, new int[]{9, 14});
        }
    }

    @Override
    public void setState(int state) {
        this.mCurrentState = state;
        this.setupSwitchAppearance();
        this.changeToggleGravity();
    }

    @Override
    public int getState() {
        return this.mCurrentState;
    }

    @Override
    public void toggle() {
        this.setState(this.getNextState());
        this.notifyObservers();
    }

    private int getNextState() {
        if (!this.mRightToLeft) {
            if (this.mCurrentState == 0) {
                return 1;
            }
            if (this.mCurrentState == 1) {
                return 2;
            }
            if (this.mCurrentState == 2) {
                return 0;
            }
        } else {
            if (this.mCurrentState == 2) {
                return 1;
            }
            if (this.mCurrentState == 1) {
                return 0;
            }
            if (this.mCurrentState == 0) {
                return 2;
            }
        }
        return 0;
    }

    public static interface RMTristateSwitchObserver {
        public void onCheckStateChange(RMTristateSwitch var1, int var2);
    }
}

