/*
 * Decompiled with CFR 0.152.
 */
package com.rm.rmswitch;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.rm.rmswitch.R;
import com.rm.rmswitch.RMAbstractSwitch;
import com.rm.rmswitch.Utils;
import java.util.ArrayList;
import java.util.List;

public class RMSwitch
extends RMAbstractSwitch {
    private static final String BUNDLE_KEY_CHECKED = "bundle_key_checked";
    private static final String BUNDLE_KEY_BKG_CHECKED_COLOR = "bundle_key_bkg_checked_color";
    private static final String BUNDLE_KEY_BKG_NOT_CHECKED_COLOR = "bundle_key_bkg_not_checked_color";
    private static final String BUNDLE_KEY_TOGGLE_CHECKED_COLOR = "bundle_key_toggle_checked_color";
    private static final String BUNDLE_KEY_TOGGLE_NOT_CHECKED_COLOR = "bundle_key_toggle_not_checked_color";
    private static final String BUNDLE_KEY_TOGGLE_CHECKED_DRAWABLE = "bundle_key_toggle_checked_drawable";
    private static final String BUNDLE_KEY_TOGGLE_NOT_CHECKED_DRAWABLE = "bundle_key_toggle_not_checked_drawable";
    private static final float SWITCH_STANDARD_ASPECT_RATIO = 2.2f;
    private List<RMSwitchObserver> mObservers;
    private boolean mIsChecked;
    private int mBkgCheckedColor;
    private int mBkgNotCheckedColor;
    private int mToggleCheckedColor;
    private int mToggleNotCheckedColor;
    private Drawable mToggleCheckedDrawable;
    private Drawable mToggleNotCheckedDrawable;

    public RMSwitch(Context context) {
        this(context, null);
    }

    public RMSwitch(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RMSwitch(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Bundle bundle = (Bundle)super.onSaveInstanceState();
        bundle.putBoolean(BUNDLE_KEY_CHECKED, this.mIsChecked);
        bundle.putInt(BUNDLE_KEY_BKG_CHECKED_COLOR, this.mBkgCheckedColor);
        bundle.putInt(BUNDLE_KEY_BKG_NOT_CHECKED_COLOR, this.mBkgNotCheckedColor);
        bundle.putInt(BUNDLE_KEY_TOGGLE_CHECKED_COLOR, this.mToggleCheckedColor);
        bundle.putInt(BUNDLE_KEY_TOGGLE_NOT_CHECKED_COLOR, this.mToggleNotCheckedColor);
        bundle.putParcelable(BUNDLE_KEY_TOGGLE_CHECKED_DRAWABLE, this.mToggleCheckedDrawable != null ? ((BitmapDrawable)this.mToggleCheckedDrawable).getBitmap() : null);
        bundle.putParcelable(BUNDLE_KEY_TOGGLE_NOT_CHECKED_DRAWABLE, this.mToggleNotCheckedDrawable != null ? ((BitmapDrawable)this.mToggleNotCheckedDrawable).getBitmap() : null);
        return bundle;
    }

    @Override
    protected void onRestoreInstanceState(Parcelable state) {
        super.onRestoreInstanceState(state);
        Bundle prevState = (Bundle)state;
        this.mBkgCheckedColor = prevState.getInt(BUNDLE_KEY_BKG_CHECKED_COLOR, Utils.getDefaultBackgroundColor(this.getContext()));
        this.mBkgNotCheckedColor = prevState.getInt(BUNDLE_KEY_BKG_NOT_CHECKED_COLOR, this.mBkgCheckedColor);
        this.mToggleCheckedColor = prevState.getInt(BUNDLE_KEY_TOGGLE_CHECKED_COLOR, Utils.getAccentColor(this.getContext()));
        this.mToggleNotCheckedColor = prevState.getInt(BUNDLE_KEY_TOGGLE_NOT_CHECKED_COLOR, -1);
        this.mToggleCheckedDrawable = new BitmapDrawable(this.getResources(), (Bitmap)prevState.getParcelable(BUNDLE_KEY_TOGGLE_CHECKED_DRAWABLE));
        this.mToggleNotCheckedDrawable = new BitmapDrawable(this.getResources(), (Bitmap)prevState.getParcelable(BUNDLE_KEY_TOGGLE_NOT_CHECKED_DRAWABLE));
        this.setChecked(prevState.getBoolean(BUNDLE_KEY_CHECKED, false));
        this.notifyObservers();
    }

    public void setSwitchBkgCheckedColor(@ColorInt int color) {
        this.mBkgCheckedColor = color;
        this.setupSwitchAppearance();
    }

    public void setSwitchBkgNotCheckedColor(@ColorInt int color) {
        this.mBkgNotCheckedColor = color;
        this.setupSwitchAppearance();
    }

    public void setSwitchToggleCheckedColor(@ColorInt int color) {
        this.mToggleCheckedColor = color;
        this.setupSwitchAppearance();
    }

    public void setSwitchToggleNotCheckedColor(@ColorInt int color) {
        this.mToggleNotCheckedColor = color;
        this.setupSwitchAppearance();
    }

    public void setSwitchToggleCheckedDrawableRes(@DrawableRes int drawable2) {
        this.setSwitchToggleCheckedDrawable(drawable2 != 0 ? ContextCompat.getDrawable((Context)this.getContext(), (int)drawable2) : null);
    }

    public void setSwitchToggleNotCheckedDrawableRes(@DrawableRes int drawable2) {
        this.setSwitchToggleNotCheckedDrawable(drawable2 != 0 ? ContextCompat.getDrawable((Context)this.getContext(), (int)drawable2) : null);
    }

    public void setSwitchToggleCheckedDrawable(Drawable drawable2) {
        this.mToggleCheckedDrawable = drawable2;
        this.setupSwitchAppearance();
    }

    public void setSwitchToggleNotCheckedDrawable(Drawable drawable2) {
        this.mToggleNotCheckedDrawable = drawable2;
        this.setupSwitchAppearance();
    }

    @ColorInt
    public int getSwitchBkgCheckedColor() {
        return this.mBkgCheckedColor;
    }

    @ColorInt
    public int getSwitchBkgNotCheckedColor() {
        return this.mBkgNotCheckedColor;
    }

    @ColorInt
    public int getSwitchToggleCheckedColor() {
        return this.mToggleCheckedColor;
    }

    @ColorInt
    public int getSwitchToggleNotCheckedColor() {
        return this.mToggleNotCheckedColor;
    }

    public Drawable getSwitchToggleCheckedDrawable() {
        return this.mToggleCheckedDrawable;
    }

    public Drawable getSwitchToggleNotCheckedDrawable() {
        return this.mToggleNotCheckedDrawable;
    }

    public void addSwitchObserver(RMSwitchObserver switchObserver) {
        if (switchObserver == null) {
            return;
        }
        if (this.mObservers == null) {
            this.mObservers = new ArrayList<RMSwitchObserver>();
        }
        this.mObservers.add(switchObserver);
    }

    public void removeSwitchObserver(RMSwitchObserver switchObserver) {
        if (switchObserver != null && this.mObservers != null && this.mObservers.size() > 0 && this.mObservers.indexOf(switchObserver) >= 0) {
            this.mObservers.remove(this.mObservers.indexOf(switchObserver));
        }
    }

    private void notifyObservers() {
        if (this.mObservers != null) {
            for (RMSwitchObserver observer : this.mObservers) {
                observer.onCheckStateChange(this, this.mIsChecked);
            }
        }
    }

    public void removeSwitchObservers() {
        if (this.mObservers != null && this.mObservers.size() > 0) {
            this.mObservers.clear();
        }
    }

    @Override
    public void setupSwitchCustomAttributes(TypedArray typedArray) {
        this.mIsChecked = typedArray.getBoolean(R.styleable.RMSwitch_checked, false);
        this.mForceAspectRatio = typedArray.getBoolean(R.styleable.RMSwitch_forceAspectRatio, true);
        this.mIsEnabled = typedArray.getBoolean(R.styleable.RMSwitch_enabled, true);
        this.mBkgCheckedColor = typedArray.getColor(R.styleable.RMSwitch_switchBkgCheckedColor, Utils.getDefaultBackgroundColor(this.getContext()));
        this.mBkgNotCheckedColor = typedArray.getColor(R.styleable.RMSwitch_switchBkgNotCheckedColor, this.mBkgCheckedColor);
        this.mToggleCheckedColor = typedArray.getColor(R.styleable.RMSwitch_switchToggleCheckedColor, Utils.getAccentColor(this.getContext()));
        this.mToggleNotCheckedColor = typedArray.getColor(R.styleable.RMSwitch_switchToggleNotCheckedColor, -1);
        int toggleCheckedDrawableResource = typedArray.getResourceId(R.styleable.RMSwitch_switchToggleCheckedImage, 0);
        int toggleNotCheckedDrawableResource = typedArray.getResourceId(R.styleable.RMSwitch_switchToggleNotCheckedImage, toggleCheckedDrawableResource);
        if (toggleCheckedDrawableResource == 0 && toggleNotCheckedDrawableResource != 0) {
            toggleCheckedDrawableResource = toggleNotCheckedDrawableResource;
        }
        this.mToggleCheckedDrawable = toggleCheckedDrawableResource != 0 ? ContextCompat.getDrawable((Context)this.getContext(), (int)toggleCheckedDrawableResource) : null;
        this.mToggleNotCheckedDrawable = toggleNotCheckedDrawableResource != 0 ? ContextCompat.getDrawable((Context)this.getContext(), (int)toggleNotCheckedDrawableResource) : null;
        this.setChecked(this.mIsChecked);
    }

    @Override
    protected void changeToggleGravity() {
        RelativeLayout.LayoutParams toggleParams = (RelativeLayout.LayoutParams)this.mImgToggle.getLayoutParams();
        toggleParams.addRule(this.getCurrentLayoutRule());
        this.removeRule(toggleParams, this.getPreviousLayoutRule());
        this.mImgToggle.setLayoutParams((ViewGroup.LayoutParams)toggleParams);
    }

    private int getCurrentLayoutRule() {
        return this.mIsChecked ? 11 : 9;
    }

    private int getPreviousLayoutRule() {
        return this.mIsChecked ? 9 : 11;
    }

    @Override
    public void setChecked(boolean checked) {
        this.mIsChecked = checked;
        this.setupSwitchAppearance();
        this.changeToggleGravity();
    }

    @Override
    public boolean isChecked() {
        return this.mIsChecked;
    }

    @Override
    public float getSwitchAspectRatio() {
        return 2.2f;
    }

    @Override
    public int getSwitchStandardWidth() {
        return this.getResources().getDimensionPixelSize(this.getSwitchDesign() == 2 ? R.dimen.rm_switch_android_width : R.dimen.rm_switch_standard_width);
    }

    @Override
    public int getSwitchStandardHeight() {
        return this.getResources().getDimensionPixelSize(this.getSwitchDesign() == 2 ? R.dimen.rm_switch_android_height : R.dimen.rm_switch_standard_height);
    }

    @Override
    public Drawable getSwitchCurrentToggleDrawable() {
        return this.mIsChecked ? this.mToggleCheckedDrawable : this.mToggleNotCheckedDrawable;
    }

    @Override
    public Drawable getSwitchCurrentToggleBkgDrawable() {
        Drawable toggleBkgDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.rounded_border_bkg);
        ((GradientDrawable)toggleBkgDrawable).setColor(this.mIsChecked ? this.mToggleCheckedColor : this.mToggleNotCheckedColor);
        return toggleBkgDrawable;
    }

    @Override
    public Drawable getSwitchCurrentBkgDrawable() {
        Drawable bkgDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.rounded_border_bkg);
        ((GradientDrawable)bkgDrawable).setColor(this.mIsChecked ? this.mBkgCheckedColor : this.mBkgNotCheckedColor);
        return bkgDrawable;
    }

    @Override
    public void toggle() {
        this.setChecked(!this.mIsChecked);
        this.notifyObservers();
    }

    @Override
    public int[] getTypedArrayResource() {
        return R.styleable.RMSwitch;
    }

    public static interface RMSwitchObserver {
        public void onCheckStateChange(RMSwitch var1, boolean var2);
    }
}

