/*
 * Decompiled with CFR 0.152.
 */
package com.rm.rmswitch;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.TransitionDrawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.rm.rmswitch.R;
import com.rm.rmswitch.RMAbstractSwitch;
import com.rm.rmswitch.Utils;
import java.util.ArrayList;
import java.util.List;

public class RMTristateSwitch
extends RMAbstractSwitch {
    private static final String BUNDLE_KEY_STATE = "bundle_key_state";
    private static final String BUNDLE_KEY_SUPER_DATA = "bundle_key_super_data";
    private static final String BUNDLE_KEY_ENABLED = "bundle_key_enabled";
    private static final String BUNDLE_KEY_FORCE_ASPECT_RATIO = "bundle_key_force_aspect_ratio";
    private static final String BUNDLE_KEY_RIGHT_TO_LEFT = "bundle_key_right_to_left";
    private static final String BUNDLE_KEY_BKG_LEFT_COLOR = "bundle_key_bkg_left_color";
    private static final String BUNDLE_KEY_BKG_MIDDLE_COLOR = "bundle_key_bkg_middle_color";
    private static final String BUNDLE_KEY_BKG_RIGHT_COLOR = "bundle_key_bkg_right_color";
    private static final String BUNDLE_KEY_TOGGLE_LEFT_COLOR = "bundle_key_toggle_left_color";
    private static final String BUNDLE_KEY_TOGGLE_MIDDLE_COLOR = "bundle_key_toggle_middle_color";
    private static final String BUNDLE_KEY_TOGGLE_RIGHT_COLOR = "bundle_key_toggle_right_color";
    private static final String BUNDLE_KEY_TOGGLE_LEFT_DRAWABLE_RES = "bundle_key_toggle_left_drawable_res";
    private static final String BUNDLE_KEY_TOGGLE_MIDDLE_DRAWABLE_RES = "bundle_key_toggle_middle_drawable_res";
    private static final String BUNDLE_KEY_TOGGLE_RIGHT_DRAWABLE_RES = "bundle_key_toggle_right_drawable_res";
    private static final float SWITCH_STANDARD_ASPECT_RATIO = 2.6f;
    private List<RMTristateSwitchObserver> mObservers;
    private int mCurrentState;
    private boolean mRightToLeft;
    private int mBkgLeftColor;
    private int mBkgMiddleColor;
    private int mBkgRightColor;
    private int mToggleLeftColor;
    private int mToggleMiddleColor;
    private int mToggleRightColor;
    private int mToggleLeftDrawableResource;
    private int mToggleMiddleDrawableResource;
    private int mToggleRightDrawableResource;

    public RMTristateSwitch(Context context) {
        this(context, null);
    }

    public RMTristateSwitch(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RMTristateSwitch(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public float getSwitchAspectRatio() {
        return 2.6f;
    }

    @Override
    public int getSwitchStandardWidth() {
        return R.dimen.rm_triswitch_standard_width;
    }

    @Override
    public int getSwitchStandardHeight() {
        return R.dimen.rm_triswitch_standard_height;
    }

    @Override
    public int[] getTypedArrayResource() {
        return R.styleable.RMTristateSwitch;
    }

    private void setMissingImages() {
        if (this.mToggleLeftDrawableResource != 0) {
            this.setMissingImagesFromResource(this.mToggleLeftDrawableResource);
        } else if (this.mToggleMiddleDrawableResource != 0) {
            this.setMissingImagesFromResource(this.mToggleMiddleDrawableResource);
        } else if (this.mToggleRightDrawableResource != 0) {
            this.setMissingImagesFromResource(this.mToggleRightDrawableResource);
        }
    }

    private void setMissingImagesFromResource(@DrawableRes int resource) {
        if (this.mToggleLeftDrawableResource == 0) {
            this.mToggleLeftDrawableResource = resource;
        }
        if (this.mToggleMiddleDrawableResource == 0) {
            this.mToggleMiddleDrawableResource = resource;
        }
        if (this.mToggleRightDrawableResource == 0) {
            this.mToggleRightDrawableResource = resource;
        }
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(BUNDLE_KEY_SUPER_DATA, super.onSaveInstanceState());
        bundle.putInt(BUNDLE_KEY_STATE, this.mCurrentState);
        bundle.putBoolean(BUNDLE_KEY_ENABLED, this.mIsEnabled);
        bundle.putBoolean(BUNDLE_KEY_FORCE_ASPECT_RATIO, this.mForceAspectRatio);
        bundle.putBoolean(BUNDLE_KEY_RIGHT_TO_LEFT, this.mRightToLeft);
        bundle.putInt(BUNDLE_KEY_BKG_LEFT_COLOR, this.mBkgLeftColor);
        bundle.putInt(BUNDLE_KEY_BKG_MIDDLE_COLOR, this.mBkgMiddleColor);
        bundle.putInt(BUNDLE_KEY_BKG_RIGHT_COLOR, this.mBkgRightColor);
        bundle.putInt(BUNDLE_KEY_TOGGLE_LEFT_COLOR, this.mToggleLeftColor);
        bundle.putInt(BUNDLE_KEY_TOGGLE_MIDDLE_COLOR, this.mToggleMiddleColor);
        bundle.putInt(BUNDLE_KEY_TOGGLE_RIGHT_COLOR, this.mToggleRightColor);
        bundle.putInt(BUNDLE_KEY_TOGGLE_LEFT_DRAWABLE_RES, this.mToggleLeftDrawableResource);
        bundle.putInt(BUNDLE_KEY_TOGGLE_MIDDLE_DRAWABLE_RES, this.mToggleMiddleDrawableResource);
        bundle.putInt(BUNDLE_KEY_TOGGLE_RIGHT_DRAWABLE_RES, this.mToggleRightDrawableResource);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        Bundle prevState = (Bundle)state;
        super.onRestoreInstanceState(prevState.getParcelable(BUNDLE_KEY_SUPER_DATA));
        this.mIsEnabled = prevState.getBoolean(BUNDLE_KEY_ENABLED, true);
        this.mForceAspectRatio = prevState.getBoolean(BUNDLE_KEY_FORCE_ASPECT_RATIO, true);
        this.mBkgLeftColor = prevState.getInt(BUNDLE_KEY_BKG_LEFT_COLOR, Utils.getDefaultBackgroundColor(this.getContext()));
        this.mBkgMiddleColor = prevState.getInt(BUNDLE_KEY_BKG_MIDDLE_COLOR, this.mBkgLeftColor);
        this.mBkgRightColor = prevState.getInt(BUNDLE_KEY_BKG_RIGHT_COLOR, this.mBkgLeftColor);
        this.mToggleLeftColor = prevState.getInt(BUNDLE_KEY_TOGGLE_LEFT_COLOR, -1);
        this.mToggleMiddleColor = prevState.getInt(BUNDLE_KEY_TOGGLE_MIDDLE_COLOR, Utils.getPrimaryColor(this.getContext()));
        this.mToggleRightColor = prevState.getInt(BUNDLE_KEY_TOGGLE_RIGHT_COLOR, Utils.getAccentColor(this.getContext()));
        this.mToggleLeftDrawableResource = prevState.getInt(BUNDLE_KEY_TOGGLE_LEFT_DRAWABLE_RES, 0);
        this.mToggleMiddleDrawableResource = prevState.getInt(BUNDLE_KEY_TOGGLE_MIDDLE_DRAWABLE_RES, 0);
        this.mToggleRightDrawableResource = prevState.getInt(BUNDLE_KEY_TOGGLE_RIGHT_DRAWABLE_RES, 0);
        this.setMissingImages();
        this.setState(prevState.getInt(BUNDLE_KEY_STATE, 0));
        this.notifyObservers();
    }

    public void setRightToLeft(boolean rightToLeft) {
        this.mRightToLeft = rightToLeft;
    }

    public void setSwitchBkgLeftColor(@ColorInt int color) {
        this.mBkgLeftColor = color;
        this.setupSwitchAppearance();
    }

    public void setSwitchBkgMiddleColor(@ColorInt int color) {
        this.mBkgMiddleColor = color;
        this.setupSwitchAppearance();
    }

    public void setSwitchBkgRightColor(@ColorInt int color) {
        this.mBkgRightColor = color;
        this.setupSwitchAppearance();
    }

    public void setSwitchToggleLeftColor(@ColorInt int color) {
        this.mToggleLeftColor = color;
        this.setupSwitchAppearance();
    }

    public void setSwitchToggleMiddleColor(@ColorInt int color) {
        this.mToggleMiddleColor = color;
        this.setupSwitchAppearance();
    }

    public void setSwitchToggleRightColor(@ColorInt int color) {
        this.mToggleRightColor = color;
        this.setupSwitchAppearance();
    }

    public void setSwitchToggleLeftDrawableRes(@DrawableRes int drawable2) {
        this.mToggleLeftDrawableResource = drawable2;
        this.setMissingImages();
        this.setupSwitchAppearance();
    }

    public void setSwitchToggleMiddleDrawableRes(@DrawableRes int drawable2) {
        this.mToggleMiddleDrawableResource = drawable2;
        this.setMissingImages();
        this.setupSwitchAppearance();
    }

    public void setSwitchToggleRightDrawableRes(@DrawableRes int drawable2) {
        this.mToggleRightDrawableResource = drawable2;
        this.setMissingImages();
        this.setupSwitchAppearance();
    }

    public boolean isRightToLeft() {
        return this.mRightToLeft;
    }

    @ColorInt
    public int getSwitchBkgLeftColor() {
        return this.mBkgLeftColor;
    }

    @ColorInt
    public int getSwitchBkgMiddleColor() {
        return this.mBkgMiddleColor;
    }

    @ColorInt
    public int getSwitchBkgRightColor() {
        return this.mBkgRightColor;
    }

    @ColorInt
    public int getSwitchToggleLeftColor() {
        return this.mToggleLeftColor;
    }

    @ColorInt
    public int getSwitchToggleMiddleColor() {
        return this.mToggleMiddleColor;
    }

    @ColorInt
    public int getSwitchToggleRightColor() {
        return this.mToggleRightColor;
    }

    @DrawableRes
    public int getSwitchToggleLeftDrawableRes() {
        return this.mToggleLeftDrawableResource;
    }

    @DrawableRes
    public int getSwitchToggleMiddleDrawableRes() {
        return this.mToggleMiddleDrawableResource;
    }

    @DrawableRes
    public int getSwitchToggleRightDrawableRes() {
        return this.mToggleRightDrawableResource;
    }

    @ColorInt
    public int getSwitchCurrentBkgColor() {
        return this.getSwitchBkgColorForState(this.mCurrentState);
    }

    @ColorInt
    public int getSwitchToggleCurrentColor() {
        return this.getSwitchToggleColorForState(this.mCurrentState);
    }

    @DrawableRes
    public int getSwitchToggleCurrentDrawableResource() {
        return this.getSwitchToggleDrawableResourceForState(this.mCurrentState);
    }

    @ColorInt
    public int getSwitchBkgColorForState(int state) {
        return state == 0 ? this.mBkgLeftColor : (state == 1 ? this.mBkgMiddleColor : this.mBkgRightColor);
    }

    @ColorInt
    public int getSwitchToggleColorForState(int state) {
        return state == 0 ? this.mToggleLeftColor : (state == 1 ? this.mToggleMiddleColor : this.mToggleRightColor);
    }

    @DrawableRes
    public int getSwitchToggleDrawableResourceForState(int state) {
        return state == 0 ? this.mToggleLeftDrawableResource : (state == 1 ? this.mToggleMiddleDrawableResource : this.mToggleRightDrawableResource);
    }

    @Nullable
    public Drawable getSwitchToggleCurrentDrawable() {
        try {
            int currentDrawableResource = this.getSwitchToggleCurrentDrawableResource();
            return currentDrawableResource == 0 ? null : ContextCompat.getDrawable((Context)this.getContext(), (int)currentDrawableResource);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void addSwitchObserver(RMTristateSwitchObserver switchObserver) {
        if (switchObserver == null) {
            return;
        }
        if (this.mObservers == null) {
            this.mObservers = new ArrayList<RMTristateSwitchObserver>();
        }
        this.mObservers.add(switchObserver);
    }

    public void removeSwitchObserver(RMTristateSwitchObserver switchObserver) {
        if (switchObserver != null && this.mObservers != null && this.mObservers.size() > 0 && this.mObservers.indexOf(switchObserver) >= 0) {
            this.mObservers.remove(this.mObservers.indexOf(switchObserver));
        }
    }

    private void notifyObservers() {
        if (this.mObservers != null) {
            for (RMTristateSwitchObserver observer : this.mObservers) {
                observer.onCheckStateChange(this.mCurrentState);
            }
        }
    }

    public void removeSwitchObservers() {
        if (this.mObservers != null && this.mObservers.size() > 0) {
            this.mObservers.clear();
        }
    }

    @Override
    public void setupSwitchAppearance() {
        Drawable bkgDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.rounded_border_bkg);
        ((GradientDrawable)bkgDrawable).setColor(this.getSwitchCurrentBkgColor());
        Drawable toggleDrawable = this.getSwitchToggleCurrentDrawable();
        Drawable toggleBkgDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.rounded_border_bkg);
        ((GradientDrawable)toggleBkgDrawable).setColor(this.getSwitchToggleCurrentColor());
        if (this.mImgBkg.getDrawable() != null) {
            TransitionDrawable bkgTransitionDrawable = new TransitionDrawable(new Drawable[]{this.mImgBkg.getDrawable() instanceof TransitionDrawable ? ((TransitionDrawable)this.mImgBkg.getDrawable()).getDrawable(1) : this.mImgBkg.getDrawable(), bkgDrawable});
            bkgTransitionDrawable.setCrossFadeEnabled(true);
            this.mImgBkg.setImageDrawable((Drawable)bkgTransitionDrawable);
            bkgTransitionDrawable.startTransition(150);
        } else {
            this.mImgBkg.setImageDrawable(bkgDrawable);
        }
        if (this.mImgToggle.getBackground() != null) {
            TransitionDrawable toggleBkgTransitionDrawable = new TransitionDrawable(new Drawable[]{this.mImgToggle.getBackground() instanceof TransitionDrawable ? ((TransitionDrawable)this.mImgToggle.getBackground()).getDrawable(1) : this.mImgToggle.getBackground(), toggleBkgDrawable});
            toggleBkgTransitionDrawable.setCrossFadeEnabled(true);
            this.mImgToggle.setBackground((Drawable)toggleBkgTransitionDrawable);
            toggleBkgTransitionDrawable.startTransition(150);
        } else {
            this.mImgToggle.setImageDrawable(toggleBkgDrawable);
        }
        if (this.mImgToggle.getDrawable() != null) {
            TransitionDrawable toggleTransitionDrawable = new TransitionDrawable(new Drawable[]{this.mImgToggle.getDrawable() instanceof TransitionDrawable ? ((TransitionDrawable)this.mImgToggle.getDrawable()).getDrawable(1) : this.mImgToggle.getDrawable(), toggleDrawable});
            toggleTransitionDrawable.setCrossFadeEnabled(true);
            this.mImgToggle.setImageDrawable((Drawable)toggleTransitionDrawable);
            toggleTransitionDrawable.startTransition(150);
        } else {
            this.mImgToggle.setImageDrawable(toggleDrawable);
        }
        this.setAlpha(this.mIsEnabled ? 1.0f : 0.6f);
    }

    @Override
    public void setupSwitchCustomAttributes(TypedArray typedArray) {
        this.mCurrentState = typedArray.getInt(R.styleable.RMTristateSwitch_state, 0);
        this.mForceAspectRatio = typedArray.getBoolean(R.styleable.RMTristateSwitch_forceAspectRatio, true);
        this.mIsEnabled = typedArray.getBoolean(R.styleable.RMTristateSwitch_enabled, true);
        this.mRightToLeft = typedArray.getBoolean(R.styleable.RMTristateSwitch_right_to_left, false);
        this.mBkgLeftColor = typedArray.getColor(R.styleable.RMTristateSwitch_switchBkgLeftColor, Utils.getDefaultBackgroundColor(this.getContext()));
        this.mBkgMiddleColor = typedArray.getColor(R.styleable.RMTristateSwitch_switchBkgMiddleColor, this.mBkgLeftColor);
        this.mBkgRightColor = typedArray.getColor(R.styleable.RMTristateSwitch_switchBkgRightColor, this.mBkgLeftColor);
        this.mToggleLeftColor = typedArray.getColor(R.styleable.RMTristateSwitch_switchToggleLeftColor, -1);
        this.mToggleMiddleColor = typedArray.getColor(R.styleable.RMTristateSwitch_switchToggleMiddleColor, Utils.getPrimaryColor(this.getContext()));
        this.mToggleRightColor = typedArray.getColor(R.styleable.RMTristateSwitch_switchToggleRightColor, Utils.getAccentColor(this.getContext()));
        this.mToggleLeftDrawableResource = typedArray.getResourceId(R.styleable.RMTristateSwitch_switchToggleLeftImage, 0);
        this.mToggleMiddleDrawableResource = typedArray.getResourceId(R.styleable.RMTristateSwitch_switchToggleMiddleImage, this.mToggleLeftDrawableResource);
        this.mToggleRightDrawableResource = typedArray.getResourceId(R.styleable.RMTristateSwitch_switchToggleRightImage, this.mToggleLeftDrawableResource);
        this.setMissingImages();
        this.setState(this.mCurrentState);
    }

    @Override
    protected void changeToggleGravity() {
        RelativeLayout.LayoutParams toggleParams = (RelativeLayout.LayoutParams)this.mImgToggle.getLayoutParams();
        toggleParams.addRule(this.getCurrentLayoutRule());
        this.removePreviousRules(toggleParams);
        this.mImgToggle.setLayoutParams((ViewGroup.LayoutParams)toggleParams);
    }

    private int getCurrentLayoutRule() {
        return this.mCurrentState == 0 ? 9 : (this.mCurrentState == 1 ? 14 : 11);
    }

    private void removePreviousRules(RelativeLayout.LayoutParams toggleParams) {
        if (this.mCurrentState == 0) {
            this.removeRules(toggleParams, new int[]{14, 11});
        }
        if (this.mCurrentState == 1) {
            this.removeRules(toggleParams, new int[]{9, 11});
        }
        if (this.mCurrentState == 2) {
            this.removeRules(toggleParams, new int[]{9, 14});
        }
    }

    @Override
    public void setState(int state) {
        this.mCurrentState = state;
        this.setupSwitchAppearance();
        this.changeToggleGravity();
    }

    @Override
    public int getState() {
        return this.mCurrentState;
    }

    @Override
    public void toggle() {
        this.setState(this.getNextState());
        this.notifyObservers();
    }

    private int getNextState() {
        if (!this.mRightToLeft) {
            if (this.mCurrentState == 0) {
                return 1;
            }
            if (this.mCurrentState == 1) {
                return 2;
            }
            if (this.mCurrentState == 2) {
                return 0;
            }
        } else {
            if (this.mCurrentState == 2) {
                return 1;
            }
            if (this.mCurrentState == 1) {
                return 0;
            }
            if (this.mCurrentState == 0) {
                return 2;
            }
        }
        return 0;
    }

    public static interface RMTristateSwitchObserver {
        public void onCheckStateChange(int var1);
    }
}

