/*
 * Decompiled with CFR 0.152.
 */
package com.rm.rmswitch;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.TransitionDrawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.rm.rmswitch.R;
import com.rm.rmswitch.RMAbstractSwitch;
import com.rm.rmswitch.Utils;
import java.util.ArrayList;
import java.util.List;

public class RMSwitch
extends RMAbstractSwitch {
    private static final String BUNDLE_KEY_CHECKED = "bundle_key_checked";
    private static final String BUNDLE_KEY_SUPER_DATA = "bundle_key_super_data";
    private static final String BUNDLE_KEY_ENABLED = "bundle_key_enabled";
    private static final String BUNDLE_KEY_FORCE_ASPECT_RATIO = "bundle_key_force_aspect_ratio";
    private static final String BUNDLE_KEY_BKG_CHECKED_COLOR = "bundle_key_bkg_checked_color";
    private static final String BUNDLE_KEY_BKG_NOT_CHECKED_COLOR = "bundle_key_bkg_not_checked_color";
    private static final String BUNDLE_KEY_TOGGLE_CHECKED_COLOR = "bundle_key_toggle_checked_color";
    private static final String BUNDLE_KEY_TOGGLE_NOT_CHECKED_COLOR = "bundle_key_toggle_not_checked_color";
    private static final String BUNDLE_KEY_TOGGLE_CHECKED_DRAWABLE_RES = "bundle_key_toggle_checked_drawable_res";
    private static final String BUNDLE_KEY_TOGGLE_NOT_CHECKED_DRAWABLE_RES = "bundle_key_toggle_not_checked_drawable_res";
    private static final float SWITCH_STANDARD_ASPECT_RATIO = 2.2f;
    private List<RMSwitchObserver> mObservers;
    private boolean mIsChecked;
    private int mBkgCheckedColor;
    private int mBkgNotCheckedColor;
    private int mToggleCheckedColor;
    private int mToggleNotCheckedColor;
    private int mToggleCheckedDrawableResource;
    private int mToggleNotCheckedDrawableResource;

    public RMSwitch(Context context) {
        this(context, null);
    }

    public RMSwitch(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RMSwitch(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(BUNDLE_KEY_SUPER_DATA, super.onSaveInstanceState());
        bundle.putBoolean(BUNDLE_KEY_CHECKED, this.mIsChecked);
        bundle.putBoolean(BUNDLE_KEY_ENABLED, this.mIsEnabled);
        bundle.putBoolean(BUNDLE_KEY_FORCE_ASPECT_RATIO, this.mForceAspectRatio);
        bundle.putInt(BUNDLE_KEY_BKG_CHECKED_COLOR, this.mBkgCheckedColor);
        bundle.putInt(BUNDLE_KEY_BKG_NOT_CHECKED_COLOR, this.mBkgNotCheckedColor);
        bundle.putInt(BUNDLE_KEY_TOGGLE_CHECKED_COLOR, this.mToggleCheckedColor);
        bundle.putInt(BUNDLE_KEY_TOGGLE_NOT_CHECKED_COLOR, this.mToggleNotCheckedColor);
        bundle.putInt(BUNDLE_KEY_TOGGLE_CHECKED_DRAWABLE_RES, this.mToggleCheckedDrawableResource);
        bundle.putInt(BUNDLE_KEY_TOGGLE_NOT_CHECKED_DRAWABLE_RES, this.mToggleNotCheckedDrawableResource);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        Bundle prevState = (Bundle)state;
        super.onRestoreInstanceState(prevState.getParcelable(BUNDLE_KEY_SUPER_DATA));
        this.mIsEnabled = prevState.getBoolean(BUNDLE_KEY_ENABLED, true);
        this.mForceAspectRatio = prevState.getBoolean(BUNDLE_KEY_FORCE_ASPECT_RATIO, true);
        this.mBkgCheckedColor = prevState.getInt(BUNDLE_KEY_BKG_CHECKED_COLOR, Utils.getDefaultBackgroundColor(this.getContext()));
        this.mBkgNotCheckedColor = prevState.getInt(BUNDLE_KEY_BKG_NOT_CHECKED_COLOR, this.mBkgCheckedColor);
        this.mToggleCheckedColor = prevState.getInt(BUNDLE_KEY_TOGGLE_CHECKED_COLOR, Utils.getAccentColor(this.getContext()));
        this.mToggleNotCheckedColor = prevState.getInt(BUNDLE_KEY_TOGGLE_NOT_CHECKED_COLOR, -1);
        this.mToggleCheckedDrawableResource = prevState.getInt(BUNDLE_KEY_TOGGLE_CHECKED_DRAWABLE_RES, 0);
        this.mToggleNotCheckedDrawableResource = prevState.getInt(BUNDLE_KEY_TOGGLE_NOT_CHECKED_DRAWABLE_RES, this.mToggleCheckedDrawableResource);
        this.setChecked(prevState.getBoolean(BUNDLE_KEY_CHECKED, false));
        this.notifyObservers();
    }

    public void setSwitchBkgCheckedColor(@ColorInt int color) {
        this.mBkgCheckedColor = color;
        this.setupSwitchAppearance();
    }

    public void setSwitchBkgNotCheckedColor(@ColorInt int color) {
        this.mBkgNotCheckedColor = color;
        this.setupSwitchAppearance();
    }

    public void setSwitchToggleCheckedColor(@ColorInt int color) {
        this.mToggleCheckedColor = color;
        this.setupSwitchAppearance();
    }

    public void setSwitchToggleNotCheckedColor(@ColorInt int color) {
        this.mToggleNotCheckedColor = color;
        this.setupSwitchAppearance();
    }

    public void setSwitchToggleCheckedDrawableRes(@DrawableRes int drawable2) {
        this.mToggleCheckedDrawableResource = drawable2;
        this.setupSwitchAppearance();
    }

    public void setSwitchToggleNotCheckedDrawableRes(@DrawableRes int drawable2) {
        this.mToggleNotCheckedDrawableResource = drawable2;
        this.setupSwitchAppearance();
    }

    @ColorInt
    public int getSwitchBkgCheckedColor() {
        return this.mBkgCheckedColor;
    }

    @ColorInt
    public int getSwitchBkgNotCheckedColor() {
        return this.mBkgNotCheckedColor;
    }

    @ColorInt
    public int getSwitchToggleCheckedColor() {
        return this.mToggleCheckedColor;
    }

    @ColorInt
    public int getSwitchToggleNotCheckedColor() {
        return this.mToggleNotCheckedColor;
    }

    @DrawableRes
    public int getSwitchToggleCheckedDrawableRes() {
        return this.mToggleCheckedDrawableResource;
    }

    @DrawableRes
    public int getSwitchToggleNotCheckedDrawableRes() {
        return this.mToggleNotCheckedDrawableResource;
    }

    public void addSwitchObserver(RMSwitchObserver switchObserver) {
        if (switchObserver == null) {
            return;
        }
        if (this.mObservers == null) {
            this.mObservers = new ArrayList<RMSwitchObserver>();
        }
        this.mObservers.add(switchObserver);
    }

    public void removeSwitchObserver(RMSwitchObserver switchObserver) {
        if (switchObserver != null && this.mObservers != null && this.mObservers.size() > 0 && this.mObservers.indexOf(switchObserver) >= 0) {
            this.mObservers.remove(this.mObservers.indexOf(switchObserver));
        }
    }

    private void notifyObservers() {
        if (this.mObservers != null) {
            for (RMSwitchObserver observer : this.mObservers) {
                observer.onCheckStateChange(this.mIsChecked);
            }
        }
    }

    public void removeSwitchObservers() {
        if (this.mObservers != null && this.mObservers.size() > 0) {
            this.mObservers.clear();
        }
    }

    @Override
    public void setupSwitchAppearance() {
        Drawable bkgDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.rounded_border_bkg);
        ((GradientDrawable)bkgDrawable).setColor(this.mIsChecked ? this.mBkgCheckedColor : this.mBkgNotCheckedColor);
        Drawable toggleDrawable = this.mIsChecked ? (this.mToggleCheckedDrawableResource != 0 ? ContextCompat.getDrawable((Context)this.getContext(), (int)this.mToggleCheckedDrawableResource) : null) : (this.mToggleNotCheckedDrawableResource != 0 ? ContextCompat.getDrawable((Context)this.getContext(), (int)this.mToggleNotCheckedDrawableResource) : null);
        Drawable toggleBkgDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.rounded_border_bkg);
        ((GradientDrawable)toggleBkgDrawable).setColor(this.mIsChecked ? this.mToggleCheckedColor : this.mToggleNotCheckedColor);
        if (this.mImgBkg.getDrawable() != null) {
            TransitionDrawable bkgTransitionDrawable = new TransitionDrawable(new Drawable[]{this.mImgBkg.getDrawable() instanceof TransitionDrawable ? ((TransitionDrawable)this.mImgBkg.getDrawable()).getDrawable(1) : this.mImgBkg.getDrawable(), bkgDrawable});
            bkgTransitionDrawable.setCrossFadeEnabled(true);
            this.mImgBkg.setImageDrawable((Drawable)bkgTransitionDrawable);
            bkgTransitionDrawable.startTransition(150);
        } else {
            this.mImgBkg.setImageDrawable(bkgDrawable);
        }
        if (this.mImgToggle.getBackground() != null) {
            TransitionDrawable toggleBkgTransitionDrawable = new TransitionDrawable(new Drawable[]{this.mImgToggle.getBackground() instanceof TransitionDrawable ? ((TransitionDrawable)this.mImgToggle.getBackground()).getDrawable(1) : this.mImgToggle.getBackground(), toggleBkgDrawable});
            toggleBkgTransitionDrawable.setCrossFadeEnabled(true);
            this.mImgToggle.setBackground((Drawable)toggleBkgTransitionDrawable);
            toggleBkgTransitionDrawable.startTransition(150);
        } else {
            this.mImgToggle.setImageDrawable(toggleBkgDrawable);
        }
        if (this.mImgToggle.getDrawable() != null) {
            TransitionDrawable toggleTransitionDrawable = new TransitionDrawable(new Drawable[]{this.mImgToggle.getDrawable() instanceof TransitionDrawable ? ((TransitionDrawable)this.mImgToggle.getDrawable()).getDrawable(1) : this.mImgToggle.getDrawable(), toggleDrawable});
            toggleTransitionDrawable.setCrossFadeEnabled(true);
            this.mImgToggle.setImageDrawable((Drawable)toggleTransitionDrawable);
            toggleTransitionDrawable.startTransition(150);
        } else {
            this.mImgToggle.setImageDrawable(toggleDrawable);
        }
        this.setAlpha(this.mIsEnabled ? 1.0f : 0.6f);
    }

    @Override
    public void setupSwitchCustomAttributes(TypedArray typedArray) {
        this.mIsChecked = typedArray.getBoolean(R.styleable.RMSwitch_checked, false);
        this.mForceAspectRatio = typedArray.getBoolean(R.styleable.RMSwitch_forceAspectRatio, true);
        this.mIsEnabled = typedArray.getBoolean(R.styleable.RMSwitch_enabled, true);
        this.mBkgCheckedColor = typedArray.getColor(R.styleable.RMSwitch_switchBkgCheckedColor, Utils.getDefaultBackgroundColor(this.getContext()));
        this.mBkgNotCheckedColor = typedArray.getColor(R.styleable.RMSwitch_switchBkgNotCheckedColor, this.mBkgCheckedColor);
        this.mToggleCheckedColor = typedArray.getColor(R.styleable.RMSwitch_switchToggleCheckedColor, Utils.getAccentColor(this.getContext()));
        this.mToggleNotCheckedColor = typedArray.getColor(R.styleable.RMSwitch_switchToggleNotCheckedColor, -1);
        this.mToggleCheckedDrawableResource = typedArray.getResourceId(R.styleable.RMSwitch_switchToggleCheckedImage, 0);
        this.mToggleNotCheckedDrawableResource = typedArray.getResourceId(R.styleable.RMSwitch_switchToggleNotCheckedImage, this.mToggleCheckedDrawableResource);
        if (this.mToggleCheckedDrawableResource == 0 && this.mToggleNotCheckedDrawableResource != 0) {
            this.mToggleCheckedDrawableResource = this.mToggleNotCheckedDrawableResource;
        }
        this.setChecked(this.mIsChecked);
    }

    @Override
    protected void changeToggleGravity() {
        RelativeLayout.LayoutParams toggleParams = (RelativeLayout.LayoutParams)this.mImgToggle.getLayoutParams();
        toggleParams.addRule(this.getCurrentLayoutRule());
        this.removeRule(toggleParams, this.getPreviousLayoutRule());
        this.mImgToggle.setLayoutParams((ViewGroup.LayoutParams)toggleParams);
    }

    private int getCurrentLayoutRule() {
        return this.mIsChecked ? 11 : 9;
    }

    private int getPreviousLayoutRule() {
        return this.mIsChecked ? 9 : 11;
    }

    @Override
    public void setChecked(boolean checked) {
        this.mIsChecked = checked;
        this.setupSwitchAppearance();
        this.changeToggleGravity();
    }

    @Override
    public boolean isChecked() {
        return this.mIsChecked;
    }

    @Override
    public float getSwitchAspectRatio() {
        return 2.2f;
    }

    @Override
    public int getSwitchStandardWidth() {
        return R.dimen.rm_switch_standard_width;
    }

    @Override
    public int getSwitchStandardHeight() {
        return R.dimen.rm_switch_standard_height;
    }

    @Override
    public void toggle() {
        this.setChecked(!this.mIsChecked);
        this.notifyObservers();
    }

    @Override
    public int[] getTypedArrayResource() {
        return R.styleable.RMSwitch;
    }

    public static interface RMSwitchObserver {
        public void onCheckStateChange(boolean var1);
    }
}

