/*
 * Decompiled with CFR 0.152.
 */
package com.rm.rmswitch;

import android.animation.LayoutTransition;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.os.Build;
import android.support.annotation.DimenRes;
import android.support.annotation.StyleableRes;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.Checkable;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.rm.rmswitch.R;
import com.rm.rmswitch.RMTristateSwitch;
import com.rm.rmswitch.SquareImageView;
import com.rm.rmswitch.TristateCheckable;
import com.rm.rmswitch.Utils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class RMAbstractSwitch
extends RelativeLayout
implements Checkable,
View.OnClickListener,
TristateCheckable,
View.OnLayoutChangeListener {
    public static final int STATE_LEFT = 0;
    public static final int STATE_MIDDLE = 1;
    public static final int STATE_RIGHT = 2;
    protected boolean mForceAspectRatio;
    protected boolean mIsEnabled;
    protected SquareImageView mImgToggle;
    protected ImageView mImgBkg;
    protected boolean mIsSlimDesign;
    protected RelativeLayout mContainerLayout;
    protected static LayoutTransition sLayoutTransition;
    protected static final int ANIMATION_DURATION = 150;

    public RMAbstractSwitch(Context context) {
        this(context, null);
    }

    public RMAbstractSwitch(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMAbstractSwitch(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, this.getTypedArrayResource(), defStyleAttr, 0);
        this.mIsSlimDesign = typedArray.getBoolean(R.styleable.RMSwitch_slimDesign, false);
        if (!this.mIsSlimDesign) {
            this.mIsSlimDesign = typedArray.getBoolean(R.styleable.RMTristateSwitch_slimDesign, false);
        }
        this.setupLayout();
        try {
            this.setupSwitchCustomAttributes(typedArray);
        }
        finally {
            typedArray.recycle();
        }
        this.setOnClickListener(this);
    }

    public void setEnabled(boolean enabled) {
        if (this.mIsEnabled != enabled) {
            this.mIsEnabled = enabled;
            this.setupSwitchAppearance();
        }
    }

    public void setForceAspectRatio(boolean forceAspectRatio) {
        if (forceAspectRatio != this.mForceAspectRatio) {
            this.mForceAspectRatio = forceAspectRatio;
            this.setupSwitchAppearance();
        }
    }

    public void setSlimDesign(boolean slimDesign) {
        if (slimDesign != this.mIsSlimDesign) {
            this.mIsSlimDesign = slimDesign;
            this.setupLayout();
            this.setupSwitchAppearance();
            this.addOnLayoutChangeListener(this);
        }
    }

    public boolean isForceAspectRatio() {
        return this.mForceAspectRatio;
    }

    public boolean isForceAspectRation() {
        return this.isForceAspectRatio();
    }

    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    public boolean isSlimDesign() {
        return this.mIsSlimDesign;
    }

    protected void setupLayout() {
        this.removeAllViews();
        if (sLayoutTransition == null) {
            sLayoutTransition = new LayoutTransition();
            sLayoutTransition.setDuration(150L);
            sLayoutTransition.enableTransitionType(4);
            sLayoutTransition.setInterpolator(4, (TimeInterpolator)new DecelerateInterpolator());
        }
        ((LayoutInflater)this.getContext().getSystemService("layout_inflater")).inflate(this.mIsSlimDesign ? R.layout.switch_view_slim : R.layout.switch_view, (ViewGroup)this, true);
        this.mImgToggle = (SquareImageView)this.findViewById(R.id.rm_switch_view_toggle);
        this.mImgBkg = (ImageView)this.findViewById(R.id.rm_switch_view_bkg);
        this.mContainerLayout = (RelativeLayout)this.findViewById(R.id.rm_switch_view_container);
        this.setLayoutTransition(sLayoutTransition);
        this.mContainerLayout.setLayoutTransition(sLayoutTransition);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (widthMode != 0x40000000) {
            int standardWith = (int)Utils.convertDpToPixel(this.getContext(), this.getResources().getDimension(this.getSwitchStandardWidth()));
            if (widthMode == 0 || widthMode == Integer.MIN_VALUE && standardWith < View.MeasureSpec.getSize((int)widthMeasureSpec)) {
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)standardWith, (int)0x40000000);
            }
        }
        if (heightMode != 0x40000000) {
            int standardHeight = (int)Utils.convertDpToPixel(this.getContext(), this.getResources().getDimension(this.getSwitchStandardHeight()));
            if (heightMode == 0 || heightMode == Integer.MIN_VALUE && standardHeight < View.MeasureSpec.getSize((int)heightMeasureSpec)) {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)standardHeight, (int)0x40000000);
            }
        }
        if (this.mForceAspectRatio) {
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)((int)((float)View.MeasureSpec.getSize((int)widthMeasureSpec) / this.getSwitchAspectRatio())), (int)View.MeasureSpec.getMode((int)heightMeasureSpec));
        } else if (View.MeasureSpec.getSize((int)widthMeasureSpec) < View.MeasureSpec.getSize((int)heightMeasureSpec)) {
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)widthMeasureSpec), (int)View.MeasureSpec.getMode((int)heightMeasureSpec));
        }
        this.setBkgMargins(heightMeasureSpec);
        this.setToggleMargins(heightMeasureSpec);
        this.setToggleImagePadding();
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private void setBkgMargins(int heightMeasureSpec) {
        int calculatedBackgroundMargin = !this.mIsSlimDesign ? 0 : View.MeasureSpec.getSize((int)heightMeasureSpec) / 6;
        ((RelativeLayout.LayoutParams)this.mImgBkg.getLayoutParams()).setMargins(calculatedBackgroundMargin, 0, calculatedBackgroundMargin, 0);
    }

    private void setToggleMargins(int heightMeasureSpec) {
        int calculatedToggleMargin = !this.mIsSlimDesign ? (View.MeasureSpec.getSize((int)heightMeasureSpec) > 0 ? View.MeasureSpec.getSize((int)heightMeasureSpec) / 6 : (int)Utils.convertDpToPixel(this.getContext(), 2.0f)) : 0;
        ((RelativeLayout.LayoutParams)this.mImgToggle.getLayoutParams()).setMargins(calculatedToggleMargin, calculatedToggleMargin, calculatedToggleMargin, calculatedToggleMargin);
    }

    private void setToggleImagePadding() {
        int padding = this.mIsSlimDesign ? this.mImgToggle.getHeight() / 6 : 0;
        try {
            if (((RMTristateSwitch)this).getSwitchBkgLeftColor() == Color.parseColor((String)"#616161")) {
                Log.w((String)"PADDING", (String)("Set to " + padding));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mImgToggle.setPadding(padding, padding, padding, padding);
    }

    protected void removeRules(RelativeLayout.LayoutParams toggleParams, int[] rules) {
        for (int rule : rules) {
            this.removeRule(toggleParams, rule);
        }
    }

    protected void removeRule(RelativeLayout.LayoutParams toggleParams, int rule) {
        if (Build.VERSION.SDK_INT >= 17) {
            toggleParams.removeRule(rule);
        } else {
            toggleParams.addRule(rule, 0);
        }
    }

    @Override
    public void toggle() {
    }

    @Override
    public void setState(int state) {
    }

    @Override
    public int getState() {
        return 0;
    }

    public void setChecked(boolean b) {
    }

    public boolean isChecked() {
        return false;
    }

    public void onClick(View view) {
        if (this.mIsEnabled) {
            this.toggle();
        }
    }

    public abstract float getSwitchAspectRatio();

    @DimenRes
    public abstract int getSwitchStandardWidth();

    @DimenRes
    public abstract int getSwitchStandardHeight();

    @StyleableRes
    public abstract int[] getTypedArrayResource();

    public abstract void setupSwitchAppearance();

    protected abstract void changeToggleGravity();

    public abstract void setupSwitchCustomAttributes(TypedArray var1);

    public void onLayoutChange(View view, int i, int i1, int i2, int i3, int i4, int i5, int i6, int i7) {
        this.removeOnLayoutChangeListener(this);
        this.measure(this.getMeasuredWidth(), this.getMeasuredHeight());
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }
}

