/*
 * Decompiled with CFR 0.152.
 */
package com.rm.rmswitch;

import android.animation.LayoutTransition;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.TransitionDrawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.Checkable;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.rm.rmswitch.R;
import com.rm.rmswitch.SquareImageView;
import com.rm.rmswitch.Utils;
import java.util.ArrayList;
import java.util.List;

public class RMSwitch
extends RelativeLayout
implements Checkable,
View.OnClickListener {
    private static final String BUNDLE_KEY_CHECKED = "bundle_key_checked";
    private static final String BUNDLE_KEY_SUPER_DATA = "bundle_key_super_data";
    private static final String BUNDLE_KEY_ENABLED = "bundle_key_enabled";
    private static final String BUNDLE_KEY_FORCE_ASPECT_RATIO = "bundle_key_force_aspect_ratio";
    private static final String BUNDLE_KEY_BKG_CHECKED_COLOR = "bundle_key_bkg_checked_color";
    private static final String BUNDLE_KEY_BKG_NOT_CHECKED_COLOR = "bundle_key_bkg_not_checked_color";
    private static final String BUNDLE_KEY_TOGGLE_CHECKED_COLOR = "bundle_key_toggle_checked_color";
    private static final String BUNDLE_KEY_TOGGLE_NOT_CHECKED_COLOR = "bundle_key_toggle_not_checked_color";
    private static final String BUNDLE_KEY_TOGGLE_CHECKED_DRAWABLE_RES = "bundle_key_toggle_checked_drawable_res";
    private static final String BUNDLE_KEY_TOGGLE_NOT_CHECKED_DRAWABLE_RES = "bundle_key_toggle_not_checked_drawable_res";
    private static final int ANIMATION_DURATION = 150;
    private static final float SWITCH_STANDARD_ASPECT_RATIO = 2.2f;
    private SquareImageView mImgToggle;
    private ImageView mImgBkg;
    private RelativeLayout mContainerLayout;
    private List<RMSwitchObserver> mObservers;
    private boolean mIsChecked;
    private boolean mForceAspectRatio;
    private boolean mIsEnabled;
    private int mBkgCheckedColor;
    private int mBkgNotCheckedColor;
    private int mToggleCheckedColor;
    private int mToggleNotCheckedColor;
    private int mToggleCheckedDrawableResource;
    private int mToggleNotCheckedDrawableResource;
    private static LayoutTransition sLayoutTransition;

    public RMSwitch(Context context) {
        this(context, null);
    }

    public RMSwitch(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMSwitch(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (sLayoutTransition == null) {
            sLayoutTransition = new LayoutTransition();
            sLayoutTransition.setDuration(150L);
            sLayoutTransition.enableTransitionType(4);
            sLayoutTransition.setInterpolator(4, (TimeInterpolator)new DecelerateInterpolator());
        }
        ((LayoutInflater)this.getContext().getSystemService("layout_inflater")).inflate(R.layout.switch_view, (ViewGroup)this, true);
        this.mImgToggle = (SquareImageView)this.findViewById(R.id.rm_switch_view_toggle);
        this.mImgBkg = (ImageView)this.findViewById(R.id.rm_switch_view_bkgd);
        this.mContainerLayout = (RelativeLayout)this.findViewById(R.id.rm_switch_view_container);
        this.setLayoutTransition(sLayoutTransition);
        this.mContainerLayout.setLayoutTransition(sLayoutTransition);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.RMSwitch, defStyleAttr, 0);
        try {
            this.mIsChecked = typedArray.getBoolean(R.styleable.RMSwitch_checked, false);
            this.mForceAspectRatio = typedArray.getBoolean(R.styleable.RMSwitch_forceAspectRatio, true);
            this.mIsEnabled = typedArray.getBoolean(R.styleable.RMSwitch_enabled, true);
            this.mBkgCheckedColor = typedArray.getColor(R.styleable.RMSwitch_switchBkgCheckedColor, Utils.getDefaultBackgroundColor(context));
            this.mBkgNotCheckedColor = typedArray.getColor(R.styleable.RMSwitch_switchBkgNotCheckedColor, this.mBkgCheckedColor);
            this.mToggleCheckedColor = typedArray.getColor(R.styleable.RMSwitch_switchToggleCheckedColor, Utils.getAccentColor(context));
            this.mToggleNotCheckedColor = typedArray.getColor(R.styleable.RMSwitch_switchToggleNotCheckedColor, -1);
            this.mToggleCheckedDrawableResource = typedArray.getResourceId(R.styleable.RMSwitch_switchToggleCheckedImage, 0);
            this.mToggleNotCheckedDrawableResource = typedArray.getResourceId(R.styleable.RMSwitch_switchToggleNotCheckedImage, this.mToggleCheckedDrawableResource);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            typedArray.recycle();
        }
        this.setOnClickListener(this);
        this.setChecked(this.mIsChecked);
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(BUNDLE_KEY_SUPER_DATA, super.onSaveInstanceState());
        bundle.putBoolean(BUNDLE_KEY_CHECKED, this.mIsChecked);
        bundle.putBoolean(BUNDLE_KEY_ENABLED, this.mIsEnabled);
        bundle.putBoolean(BUNDLE_KEY_FORCE_ASPECT_RATIO, this.mForceAspectRatio);
        bundle.putInt(BUNDLE_KEY_BKG_CHECKED_COLOR, this.mBkgCheckedColor);
        bundle.putInt(BUNDLE_KEY_BKG_NOT_CHECKED_COLOR, this.mBkgNotCheckedColor);
        bundle.putInt(BUNDLE_KEY_TOGGLE_CHECKED_COLOR, this.mToggleCheckedColor);
        bundle.putInt(BUNDLE_KEY_TOGGLE_NOT_CHECKED_COLOR, this.mToggleNotCheckedColor);
        bundle.putInt(BUNDLE_KEY_TOGGLE_CHECKED_DRAWABLE_RES, this.mToggleCheckedDrawableResource);
        bundle.putInt(BUNDLE_KEY_TOGGLE_NOT_CHECKED_DRAWABLE_RES, this.mToggleNotCheckedDrawableResource);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        Bundle prevState = (Bundle)state;
        super.onRestoreInstanceState(prevState.getParcelable(BUNDLE_KEY_SUPER_DATA));
        this.mIsEnabled = prevState.getBoolean(BUNDLE_KEY_ENABLED, true);
        this.mForceAspectRatio = prevState.getBoolean(BUNDLE_KEY_FORCE_ASPECT_RATIO, true);
        this.mBkgCheckedColor = prevState.getInt(BUNDLE_KEY_BKG_CHECKED_COLOR, Utils.getDefaultBackgroundColor(this.getContext()));
        this.mBkgNotCheckedColor = prevState.getInt(BUNDLE_KEY_BKG_NOT_CHECKED_COLOR, this.mBkgCheckedColor);
        this.mToggleCheckedColor = prevState.getInt(BUNDLE_KEY_TOGGLE_CHECKED_COLOR, Utils.getAccentColor(this.getContext()));
        this.mToggleNotCheckedColor = prevState.getInt(BUNDLE_KEY_TOGGLE_NOT_CHECKED_COLOR, -1);
        this.mToggleCheckedDrawableResource = prevState.getInt(BUNDLE_KEY_TOGGLE_CHECKED_DRAWABLE_RES, 0);
        this.mToggleNotCheckedDrawableResource = prevState.getInt(BUNDLE_KEY_TOGGLE_NOT_CHECKED_DRAWABLE_RES, this.mToggleCheckedDrawableResource);
        this.setChecked(prevState.getBoolean(BUNDLE_KEY_CHECKED, false));
        this.notifyObservers();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mForceAspectRatio) {
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)((int)((float)View.MeasureSpec.getSize((int)widthMeasureSpec) / 2.2f)), (int)View.MeasureSpec.getMode((int)heightMeasureSpec));
        } else if (View.MeasureSpec.getSize((int)widthMeasureSpec) < View.MeasureSpec.getSize((int)heightMeasureSpec)) {
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)widthMeasureSpec), (int)View.MeasureSpec.getMode((int)heightMeasureSpec));
        }
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (widthMode != 0x40000000) {
            int standardWith = (int)Utils.convertDpToPixel(this.getContext(), this.getResources().getDimension(R.dimen.rm_switch_standard_width));
            if (widthMode == 0 || widthMode == Integer.MIN_VALUE && standardWith < View.MeasureSpec.getSize((int)widthMeasureSpec)) {
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)standardWith, (int)0x40000000);
            }
        }
        if (heightMode != 0x40000000) {
            int standardHeight = (int)Utils.convertDpToPixel(this.getContext(), this.getResources().getDimension(R.dimen.rm_switch_standard_height));
            if (heightMode == 0 || heightMode == Integer.MIN_VALUE && standardHeight < View.MeasureSpec.getSize((int)heightMeasureSpec)) {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)standardHeight, (int)0x40000000);
            }
        }
        int calculatedMargin = View.MeasureSpec.getSize((int)heightMeasureSpec) > 0 ? View.MeasureSpec.getSize((int)heightMeasureSpec) / 8 : (int)Utils.convertDpToPixel(this.getContext(), 2.0f);
        ((RelativeLayout.LayoutParams)this.mImgToggle.getLayoutParams()).setMargins(calculatedMargin, calculatedMargin, calculatedMargin, calculatedMargin);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public void setEnabled(boolean enabled) {
        this.mIsEnabled = enabled;
        this.setupSwitchAppearance();
    }

    public void setSwitchBkgCheckedColor(@ColorInt int color) {
        this.mBkgCheckedColor = color;
        this.setupSwitchAppearance();
    }

    public void setSwitchBkgNotCheckedColor(@ColorInt int color) {
        this.mBkgNotCheckedColor = color;
        this.setupSwitchAppearance();
    }

    public void setSwitchToggleCheckedColor(@ColorInt int color) {
        this.mToggleCheckedColor = color;
        this.setupSwitchAppearance();
    }

    public void setSwitchToggleNotCheckedColor(@ColorInt int color) {
        this.mToggleNotCheckedColor = color;
        this.setupSwitchAppearance();
    }

    public void setSwitchToggleCheckedDrawableRes(@DrawableRes int drawable2) {
        this.mToggleCheckedDrawableResource = drawable2;
        this.setupSwitchAppearance();
    }

    public void setSwitchToggleNotCheckedDrawableRes(@DrawableRes int drawable2) {
        this.mToggleNotCheckedDrawableResource = drawable2;
        this.setupSwitchAppearance();
    }

    public void setForceAspectRatio(boolean forceAspectRatio) {
        this.mForceAspectRatio = forceAspectRatio;
        this.setupSwitchAppearance();
    }

    @ColorInt
    public int getSwitchBkgCheckedColor() {
        return this.mBkgCheckedColor;
    }

    @ColorInt
    public int getSwitchBkgNotCheckedColor() {
        return this.mBkgNotCheckedColor;
    }

    @ColorInt
    public int getSwitchToggleCheckedColor() {
        return this.mToggleCheckedColor;
    }

    @ColorInt
    public int getSwitchToggleNotCheckedColor() {
        return this.mToggleNotCheckedColor;
    }

    public boolean isForceAspectRation() {
        return this.mForceAspectRatio;
    }

    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    @DrawableRes
    public int getSwitchToggleCheckedDrawableRes() {
        return this.mToggleCheckedDrawableResource;
    }

    @DrawableRes
    public int getSwitchToggleNotCheckedDrawableRes() {
        return this.mToggleNotCheckedDrawableResource;
    }

    public void addSwitchObserver(RMSwitchObserver switchObserver) {
        if (switchObserver == null) {
            return;
        }
        if (this.mObservers == null) {
            this.mObservers = new ArrayList<RMSwitchObserver>();
        }
        this.mObservers.add(switchObserver);
    }

    public void removeSwitchObserver(RMSwitchObserver switchObserver) {
        if (switchObserver != null && this.mObservers != null && this.mObservers.size() > 0 && this.mObservers.indexOf(switchObserver) >= 0) {
            this.mObservers.remove(this.mObservers.indexOf(switchObserver));
        }
    }

    private void notifyObservers() {
        if (this.mObservers != null) {
            for (RMSwitchObserver observer : this.mObservers) {
                observer.onCheckStateChange(this.mIsChecked);
            }
        }
    }

    public void removeSwitchObservers() {
        if (this.mObservers != null && this.mObservers.size() > 0) {
            this.mObservers.clear();
        }
    }

    public void setupSwitchAppearance() {
        Drawable bkgDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.rounded_border_bkg);
        ((GradientDrawable)bkgDrawable).setColor(this.mIsChecked ? this.mBkgCheckedColor : this.mBkgNotCheckedColor);
        Drawable toggleDrawable = this.mIsChecked ? (this.mToggleCheckedDrawableResource != 0 ? ContextCompat.getDrawable((Context)this.getContext(), (int)this.mToggleCheckedDrawableResource) : null) : (this.mToggleNotCheckedDrawableResource != 0 ? ContextCompat.getDrawable((Context)this.getContext(), (int)this.mToggleNotCheckedDrawableResource) : null);
        Drawable toggleBkgDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.rounded_border_bkg);
        ((GradientDrawable)toggleBkgDrawable).setColor(this.mIsChecked ? this.mToggleCheckedColor : this.mToggleNotCheckedColor);
        if (this.mImgBkg.getDrawable() != null) {
            TransitionDrawable bkgdTransitionDrawable = new TransitionDrawable(new Drawable[]{this.mImgBkg.getDrawable() instanceof TransitionDrawable ? ((TransitionDrawable)this.mImgBkg.getDrawable()).getDrawable(1) : this.mImgBkg.getDrawable(), bkgDrawable});
            bkgdTransitionDrawable.setCrossFadeEnabled(true);
            this.mImgBkg.setImageDrawable((Drawable)bkgdTransitionDrawable);
            bkgdTransitionDrawable.startTransition(150);
        } else {
            this.mImgBkg.setImageDrawable(bkgDrawable);
        }
        if (this.mImgToggle.getBackground() != null) {
            TransitionDrawable toggleBkgTransitionDrawable = new TransitionDrawable(new Drawable[]{this.mImgToggle.getBackground() instanceof TransitionDrawable ? ((TransitionDrawable)this.mImgToggle.getBackground()).getDrawable(1) : this.mImgToggle.getBackground(), toggleBkgDrawable});
            toggleBkgTransitionDrawable.setCrossFadeEnabled(true);
            this.mImgToggle.setBackground((Drawable)toggleBkgTransitionDrawable);
            toggleBkgTransitionDrawable.startTransition(150);
        } else {
            this.mImgToggle.setImageDrawable(toggleBkgDrawable);
        }
        if (this.mImgToggle.getDrawable() != null) {
            TransitionDrawable toggleTransitionDrawable = new TransitionDrawable(new Drawable[]{this.mImgToggle.getDrawable() instanceof TransitionDrawable ? ((TransitionDrawable)this.mImgToggle.getDrawable()).getDrawable(1) : this.mImgToggle.getDrawable(), toggleDrawable});
            toggleTransitionDrawable.setCrossFadeEnabled(true);
            this.mImgToggle.setImageDrawable((Drawable)toggleTransitionDrawable);
            toggleTransitionDrawable.startTransition(150);
        } else {
            this.mImgToggle.setImageDrawable(toggleDrawable);
        }
        this.setAlpha(this.mIsEnabled ? 1.0f : 0.6f);
    }

    private void changeToggleGravity() {
        RelativeLayout.LayoutParams toggleParams = (RelativeLayout.LayoutParams)this.mImgToggle.getLayoutParams();
        toggleParams.addRule(this.mIsChecked ? 11 : 9);
        if (Build.VERSION.SDK_INT >= 17) {
            toggleParams.removeRule(this.mIsChecked ? 9 : 11);
        } else if (this.isChecked()) {
            toggleParams.addRule(9, 0);
        } else {
            toggleParams.addRule(11, 0);
        }
        this.mImgToggle.setLayoutParams((ViewGroup.LayoutParams)toggleParams);
    }

    public void setChecked(boolean checked) {
        this.mIsChecked = checked;
        this.setupSwitchAppearance();
        this.changeToggleGravity();
    }

    public boolean isChecked() {
        return this.mIsChecked;
    }

    public void toggle() {
        this.setChecked(!this.mIsChecked);
        this.notifyObservers();
    }

    public void onClick(View v) {
        if (this.isEnabled()) {
            this.toggle();
        }
    }

    public static interface RMSwitchObserver {
        public void onCheckStateChange(boolean var1);
    }
}

