/*
 * Decompiled with CFR 0.152.
 */
package com.rm.freedrawview;

import android.content.res.Resources;
import android.graphics.ComposePathEffect;
import android.graphics.CornerPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.support.annotation.NonNull;
import com.rm.freedrawview.Point;
import java.util.List;

public class FreeDrawHelper {
    static boolean isAPoint(@NonNull List<Point> points) {
        if (points.size() == 0) {
            return false;
        }
        if (points.size() == 1) {
            return true;
        }
        for (int i = 1; i < points.size(); ++i) {
            if (points.get((int)(i - 1)).x == points.get((int)i).x && points.get((int)(i - 1)).y == points.get((int)i).y) continue;
            return false;
        }
        return true;
    }

    static Paint createPaintAndInitialize(int paintColor, int paintAlpha, float paintWidth, boolean fill) {
        Paint paint = FreeDrawHelper.createPaint();
        FreeDrawHelper.initializePaint(paint, paintColor, paintAlpha, paintWidth, fill);
        return paint;
    }

    static Paint createPaint() {
        return new Paint(1);
    }

    static void initializePaint(Paint paint, int paintColor, int paintAlpha, float paintWidth, boolean fill) {
        if (fill) {
            FreeDrawHelper.setupFillPaint(paint);
        } else {
            FreeDrawHelper.setupStrokePaint(paint);
        }
        paint.setStrokeWidth(paintWidth);
        paint.setColor(paintColor);
        paint.setAlpha(paintAlpha);
    }

    static void setupFillPaint(Paint paint) {
        paint.setStyle(Paint.Style.FILL);
    }

    static void setupStrokePaint(Paint paint) {
        paint.setStrokeJoin(Paint.Join.ROUND);
        paint.setStrokeCap(Paint.Cap.ROUND);
        paint.setPathEffect((PathEffect)new ComposePathEffect((PathEffect)new CornerPathEffect(100.0f), (PathEffect)new CornerPathEffect(100.0f)));
        paint.setStyle(Paint.Style.STROKE);
    }

    static void copyFromPaint(Paint from, Paint to, boolean copyWidth) {
        to.setColor(from.getColor());
        to.setAlpha(from.getAlpha());
        if (copyWidth) {
            to.setStrokeWidth(from.getStrokeWidth());
        }
    }

    static void copyFromValues(Paint to, int color, int alpha, float strokeWidth, boolean copyWidth) {
        to.setColor(color);
        to.setAlpha(alpha);
        if (copyWidth) {
            to.setStrokeWidth(strokeWidth);
        }
    }

    public static float convertDpToPixels(float dp) {
        return dp * Resources.getSystem().getDisplayMetrics().density;
    }

    public static float convertPixelsToDp(float px) {
        return px / Resources.getSystem().getDisplayMetrics().density;
    }
}

