/*
 * Decompiled with CFR 0.152.
 */
package com.rm.freedrawview;

import android.graphics.Paint;
import android.graphics.Path;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.rm.freedrawview.FreeDrawHelper;
import com.rm.freedrawview.Point;
import java.io.Serializable;
import java.util.ArrayList;

class HistoryPath
implements Parcelable,
Serializable {
    static final long serialVersionUID = 41L;
    private static final String TAG = HistoryPath.class.getSimpleName();
    private ArrayList<Point> points = new ArrayList();
    private int paintColor;
    private int paintAlpha;
    private float paintWidth;
    private float originX;
    private float originY;
    private boolean isPoint;
    private transient Path path = null;
    private transient Paint paint = null;
    public static final Parcelable.Creator<HistoryPath> CREATOR = new Parcelable.Creator<HistoryPath>(){

        public HistoryPath createFromParcel(Parcel in) {
            return new HistoryPath(in);
        }

        public HistoryPath[] newArray(int size) {
            return new HistoryPath[size];
        }
    };

    HistoryPath(@NonNull ArrayList<Point> points, @NonNull Paint paint) {
        this.points = new ArrayList<Point>(points);
        this.paintColor = paint.getColor();
        this.paintAlpha = paint.getAlpha();
        this.paintWidth = paint.getStrokeWidth();
        this.originX = points.get((int)0).x;
        this.originY = points.get((int)0).y;
        this.isPoint = FreeDrawHelper.isAPoint(points);
        this.generatePath();
        this.generatePaint();
    }

    public void generatePath() {
        this.path = new Path();
        if (this.points != null) {
            boolean first = true;
            for (int i = 0; i < this.points.size(); ++i) {
                Point point = this.points.get(i);
                if (first) {
                    this.path.moveTo(point.x, point.y);
                    first = false;
                    continue;
                }
                this.path.lineTo(point.x, point.y);
            }
        }
    }

    private void generatePaint() {
        this.paint = FreeDrawHelper.createPaintAndInitialize(this.paintColor, this.paintAlpha, this.paintWidth, this.isPoint);
    }

    public Path getPath() {
        if (this.path == null) {
            this.generatePath();
        }
        return this.path;
    }

    public boolean isPoint() {
        return this.isPoint;
    }

    public void setPoint(boolean point) {
        this.isPoint = point;
    }

    public float getOriginX() {
        return this.originX;
    }

    public void setOriginX(float originX) {
        this.originX = originX;
    }

    public float getOriginY() {
        return this.originY;
    }

    public void setOriginY(float originY) {
        this.originY = originY;
    }

    public int getPaintColor() {
        return this.paintColor;
    }

    public void setPaintColor(int paintColor) {
        this.paintColor = paintColor;
    }

    public int getPaintAlpha() {
        return this.paintAlpha;
    }

    public void setPaintAlpha(int paintAlpha) {
        this.paintAlpha = paintAlpha;
    }

    public float getPaintWidth() {
        return this.paintWidth;
    }

    public void setPaintWidth(float paintWidth) {
        this.paintWidth = paintWidth;
    }

    public Paint getPaint() {
        if (this.paint == null) {
            this.generatePaint();
        }
        return this.paint;
    }

    public ArrayList<Point> getPoints() {
        return this.points;
    }

    public void setPoints(ArrayList<Point> points) {
        this.points = points;
    }

    private HistoryPath(Parcel in) {
        in.readTypedList(this.points, Point.CREATOR);
        this.paintColor = in.readInt();
        this.paintAlpha = in.readInt();
        this.paintWidth = in.readFloat();
        this.originX = in.readFloat();
        this.originY = in.readFloat();
        this.isPoint = in.readByte() != 0;
        this.generatePath();
        this.generatePaint();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedList(this.points);
        dest.writeInt(this.paintColor);
        dest.writeInt(this.paintAlpha);
        dest.writeFloat(this.paintWidth);
        dest.writeFloat(this.originX);
        dest.writeFloat(this.originY);
        dest.writeByte((byte)(this.isPoint ? 1 : 0));
    }

    public String toString() {
        return "Point: " + this.isPoint + "\nPoints: " + this.points + "\nColor: " + this.paintColor + "\nAlpha: " + this.paintAlpha + "\nWidth: " + this.paintWidth;
    }
}

