/*
 * Decompiled with CFR 0.152.
 */
package com.rm.freedrawview;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.view.View;
import com.rm.freedrawview.HistoryPath;
import com.rm.freedrawview.ResizeBehaviour;
import com.rm.freedrawview.SerializablePaint;
import java.io.Serializable;
import java.util.ArrayList;

class FreeDrawSavedState
extends View.BaseSavedState {
    private ArrayList<HistoryPath> mCanceledPaths;
    private ArrayList<HistoryPath> mPaths;
    private SerializablePaint mCurrentPaint;
    private int mPaintColor;
    private int mPaintAlpha;
    private ResizeBehaviour mResizeBehaviour;
    private int mLastDimensionW;
    private int mLastDimensionH;
    public static final Parcelable.Creator<FreeDrawSavedState> CREATOR = new Parcelable.Creator<FreeDrawSavedState>(){

        public FreeDrawSavedState createFromParcel(Parcel in) {
            return new FreeDrawSavedState(in);
        }

        public FreeDrawSavedState[] newArray(int size) {
            return new FreeDrawSavedState[size];
        }
    };

    FreeDrawSavedState(Parcelable superState, ArrayList<HistoryPath> paths, ArrayList<HistoryPath> canceledPaths, SerializablePaint currentPaint, int paintColor, int paintAlpha, ResizeBehaviour resizeBehaviour, int lastDimensionW, int lastDimensionH) {
        super(superState);
        this.mPaths = paths;
        this.mCanceledPaths = canceledPaths;
        this.mCurrentPaint = currentPaint;
        this.mPaintColor = paintColor;
        this.mPaintAlpha = paintAlpha;
        this.mResizeBehaviour = resizeBehaviour;
        this.mLastDimensionW = lastDimensionW;
        this.mLastDimensionH = lastDimensionH;
    }

    private FreeDrawSavedState(Parcel in) {
        super(in);
        try {
            this.mPaths = in.readArrayList(HistoryPath.class.getClassLoader());
            this.mCanceledPaths = in.readArrayList(HistoryPath.class.getClassLoader());
            this.mPaintColor = in.readInt();
            this.mPaintAlpha = in.readInt();
            this.mResizeBehaviour = (ResizeBehaviour)((Object)in.readSerializable());
            this.mLastDimensionW = in.readInt();
            this.mLastDimensionH = in.readInt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeToParcel(Parcel out, int flags) {
        super.writeToParcel(out, flags);
        out.writeTypedList(this.mPaths);
        out.writeTypedList(this.mCanceledPaths);
        out.writeInt(this.mPaintColor);
        out.writeInt(this.mPaintAlpha);
        out.writeSerializable((Serializable)((Object)this.mResizeBehaviour));
        out.writeInt(this.mLastDimensionW);
        out.writeInt(this.mLastDimensionH);
    }

    ArrayList<HistoryPath> getPaths() {
        return this.mPaths;
    }

    ArrayList<HistoryPath> getCanceledPaths() {
        return this.mCanceledPaths;
    }

    SerializablePaint getCurrentPaint() {
        return this.mCurrentPaint;
    }

    @ColorInt
    int getPaintColor() {
        return this.mPaintColor;
    }

    @IntRange(from=0L, to=255L)
    int getPaintAlpha() {
        return this.mPaintAlpha;
    }

    ResizeBehaviour getResizeBehaviour() {
        return this.mResizeBehaviour;
    }

    int getLastDimensionW() {
        return this.mLastDimensionW;
    }

    int getLastDimensionH() {
        return this.mLastDimensionH;
    }
}

