/*
 * Decompiled with CFR 0.152.
 */
package com.rm.freedrawview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ComposePathEffect;
import android.graphics.CornerPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.os.AsyncTask;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.rm.freedrawview.FreeDrawHelper;
import com.rm.freedrawview.FreeDrawSavedState;
import com.rm.freedrawview.HistoryPath;
import com.rm.freedrawview.PathDrawnListener;
import com.rm.freedrawview.PathRedoUndoCountChangeListener;
import com.rm.freedrawview.Point;
import com.rm.freedrawview.R;
import com.rm.freedrawview.ResizeBehaviour;
import com.rm.freedrawview.SerializablePaint;
import com.rm.freedrawview.SerializablePath;
import com.rm.freedrawview.TranslateMatrix;
import java.util.ArrayList;
import java.util.Collections;

public class FreeDrawView
extends View
implements View.OnTouchListener {
    private static final String TAG = FreeDrawView.class.getSimpleName();
    private static final float DEFAULT_STROKE_WIDTH = 4.0f;
    private static final int DEFAULT_COLOR = -16777216;
    private static final int DEFAULT_ALPHA = 255;
    private SerializablePaint mCurrentPaint;
    private SerializablePath mCurrentPath;
    private ResizeBehaviour mResizeBehaviour;
    private ArrayList<Point> mPoints = new ArrayList();
    private ArrayList<HistoryPath> mPaths = new ArrayList();
    private ArrayList<HistoryPath> mCanceledPaths = new ArrayList();
    @ColorInt
    private int mPaintColor = -16777216;
    @IntRange(from=0L, to=255L)
    private int mPaintAlpha = 255;
    private int mLastDimensionW = -1;
    private int mLastDimensionH = -1;
    private boolean mFinishPath = false;
    private Paint mFillPaint;
    private PathDrawnListener mPathDrawnListener;
    private PathRedoUndoCountChangeListener mPathRedoUndoCountChangeListener;

    public FreeDrawView(Context context) {
        this(context, null);
    }

    public FreeDrawView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FreeDrawView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOnTouchListener(this);
        TypedArray a = null;
        try {
            a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.FreeDrawView, defStyleAttr, 0);
            this.initPaints(a);
        }
        finally {
            if (a != null) {
                a.recycle();
            }
        }
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        if (this.mPoints.size() > 0) {
            this.createHistoryPathFromPoints();
        }
        return new FreeDrawSavedState(superState, this.mPaths, this.mCanceledPaths, this.mCurrentPaint, this.mPaintColor, this.mPaintAlpha, this.mResizeBehaviour, this.mLastDimensionW, this.mLastDimensionH);
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof FreeDrawSavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        FreeDrawSavedState savedState = (FreeDrawSavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mPaths = savedState.getPaths();
        this.mCanceledPaths = savedState.getCanceledPaths();
        this.mCurrentPaint = savedState.getCurrentPaint();
        this.initFillPaint();
        this.mResizeBehaviour = savedState.getResizeBehaviour();
        this.mPaintColor = savedState.getPaintColor();
        this.mPaintAlpha = savedState.getPaintAlpha();
        this.mLastDimensionW = savedState.getLastDimensionW();
        this.mLastDimensionH = savedState.getLastDimensionH();
        this.notifyRedoUndoCountChanged();
    }

    public void setPaintColor(@ColorInt int color) {
        this.mFinishPath = true;
        this.invalidate();
        this.mPaintColor = color;
        this.mCurrentPaint.setColor(this.mPaintColor);
        this.mCurrentPaint.setAlpha(this.mPaintAlpha);
    }

    @ColorInt
    public int getPaintColor() {
        return this.mPaintColor;
    }

    @ColorInt
    public int getPaintColorWithAlpha() {
        return this.mCurrentPaint.getColor();
    }

    public void setPaintWidthPx(@FloatRange(from=0.0) float widthPx) {
        if (widthPx > 0.0f) {
            this.mFinishPath = true;
            this.invalidate();
            this.mCurrentPaint.setStrokeWidth(widthPx);
        }
    }

    public void setPaintWidthDp(float dp) {
        this.setPaintWidthPx(FreeDrawHelper.convertDpToPixels(dp));
    }

    @FloatRange(from=0.0)
    public float getPaintWidth() {
        return this.getPaintWith(false);
    }

    @FloatRange(from=0.0)
    public float getPaintWith(boolean inDp) {
        if (inDp) {
            return FreeDrawHelper.convertPixelsToDp(this.mCurrentPaint.getStrokeWidth());
        }
        return this.mCurrentPaint.getStrokeWidth();
    }

    public void setPaintAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.mFinishPath = true;
        this.invalidate();
        this.mPaintAlpha = alpha;
        this.mCurrentPaint.setAlpha(this.mPaintAlpha);
    }

    @IntRange(from=0L, to=255L)
    public int getPaintAlpha() {
        return this.mPaintAlpha;
    }

    public void setResizeBehaviour(ResizeBehaviour newBehaviour) {
        this.mResizeBehaviour = newBehaviour;
    }

    public ResizeBehaviour getResizeBehaviour() {
        return this.mResizeBehaviour;
    }

    public void undoLast() {
        if (this.mPaths.size() > 0) {
            this.mFinishPath = true;
            this.invalidate();
            this.mCanceledPaths.add(this.mPaths.get(this.mPaths.size() - 1));
            this.mPaths.remove(this.mPaths.size() - 1);
            this.invalidate();
            this.notifyRedoUndoCountChanged();
        }
    }

    public void redoLast() {
        if (this.mCanceledPaths.size() > 0) {
            this.mPaths.add(this.mCanceledPaths.get(this.mCanceledPaths.size() - 1));
            this.mCanceledPaths.remove(this.mCanceledPaths.size() - 1);
            this.invalidate();
            this.notifyRedoUndoCountChanged();
        }
    }

    public void undoAll() {
        Collections.reverse(this.mPaths);
        this.mCanceledPaths.addAll(this.mPaths);
        this.mPaths.clear();
        this.invalidate();
        this.notifyRedoUndoCountChanged();
    }

    public void redoAll() {
        if (this.mCanceledPaths.size() > 0) {
            this.mPaths.addAll(this.mCanceledPaths);
            this.mCanceledPaths.clear();
            this.invalidate();
            this.notifyRedoUndoCountChanged();
        }
    }

    public int getUndoCount() {
        return this.mPaths.size();
    }

    public int getRedoCount() {
        return this.mCanceledPaths.size();
    }

    public void setOnPathDrawnListener(PathDrawnListener listener) {
        this.mPathDrawnListener = listener;
    }

    public void removePathDrawnListener() {
        this.mPathDrawnListener = null;
    }

    public void setPathRedoUndoCountChangeListener(PathRedoUndoCountChangeListener listener) {
        this.mPathRedoUndoCountChangeListener = listener;
    }

    public void removePathRedoUndoCountChangeListener() {
        this.mPathRedoUndoCountChangeListener = null;
    }

    public void getDrawScreenshot(@NonNull DrawCreatorListener listener) {
        new TakeScreenShotAsyncTask(listener).execute(new Void[0]);
    }

    private void notifyPathDrawn() {
        if (this.mPathDrawnListener != null) {
            this.mPathDrawnListener.onNewPathDrawn();
        }
    }

    private void notifyRedoUndoCountChanged() {
        if (this.mPathRedoUndoCountChangeListener != null) {
            this.mPathRedoUndoCountChangeListener.onRedoCountChanged(this.getRedoCount());
            this.mPathRedoUndoCountChangeListener.onUndoCountChanged(this.getUndoCount());
        }
    }

    private void initPaints(TypedArray a) {
        this.mCurrentPaint = new SerializablePaint(1);
        this.mCurrentPaint.setColor(a != null ? a.getColor(R.styleable.FreeDrawView_paintColor, this.mPaintColor) : this.mPaintColor);
        this.mCurrentPaint.setAlpha(a != null ? a.getInt(R.styleable.FreeDrawView_paintAlpha, this.mPaintAlpha) : this.mPaintAlpha);
        this.mCurrentPaint.setStrokeWidth(a != null ? (float)a.getDimensionPixelSize(R.styleable.FreeDrawView_paintWidth, (int)FreeDrawHelper.convertDpToPixels(4.0f)) : FreeDrawHelper.convertDpToPixels(4.0f));
        this.mCurrentPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mCurrentPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mCurrentPaint.setPathEffect((PathEffect)new ComposePathEffect((PathEffect)new CornerPathEffect(100.0f), (PathEffect)new CornerPathEffect(100.0f)));
        this.mCurrentPaint.setStyle(Paint.Style.STROKE);
        if (a != null) {
            int resizeBehaviour = a.getInt(R.styleable.FreeDrawView_resizeBehaviour, -1);
            this.mResizeBehaviour = resizeBehaviour == 0 ? ResizeBehaviour.CLEAR : (resizeBehaviour == 1 ? ResizeBehaviour.FIT_XY : (resizeBehaviour == 2 ? ResizeBehaviour.CROP : ResizeBehaviour.CROP));
        }
        this.initFillPaint();
    }

    private void initFillPaint() {
        this.mFillPaint = new Paint(1);
        this.mFillPaint.setStyle(Paint.Style.FILL);
    }

    private void setupFillPaint(Paint from) {
        this.mFillPaint.setColor(from.getColor());
        this.mFillPaint.setAlpha(from.getAlpha());
    }

    protected void onDraw(Canvas canvas) {
        if (this.mPaths.size() == 0 && this.mPoints.size() == 0) {
            return;
        }
        boolean finishedPath = this.mFinishPath;
        this.mFinishPath = false;
        for (int i = 0; i < this.mPaths.size(); ++i) {
            HistoryPath currentPath = this.mPaths.get(i);
            if (currentPath.isPoint()) {
                this.setupFillPaint(currentPath.getPaint());
                canvas.drawCircle(currentPath.getOriginX(), currentPath.getOriginY(), currentPath.getPaint().getStrokeWidth() / 2.0f, this.mFillPaint);
                continue;
            }
            canvas.drawPath((Path)currentPath.getPath(), (Paint)currentPath.getPaint());
        }
        if (this.mCurrentPath == null) {
            this.mCurrentPath = new SerializablePath();
        } else {
            this.mCurrentPath.rewind();
        }
        if (this.mPoints.size() == 1 || FreeDrawHelper.isAPoint(this.mPoints)) {
            this.setupFillPaint(this.mCurrentPaint);
            canvas.drawCircle(this.mPoints.get((int)0).x, this.mPoints.get((int)0).y, this.mCurrentPaint.getStrokeWidth() / 2.0f, this.mFillPaint);
        } else if (this.mPoints.size() != 0) {
            boolean first = true;
            for (int i = 0; i < this.mPoints.size(); ++i) {
                Point point = this.mPoints.get(i);
                if (first) {
                    this.mCurrentPath.moveTo(point.x, point.y);
                    first = false;
                    continue;
                }
                this.mCurrentPath.lineTo(point.x, point.y);
            }
            canvas.drawPath((Path)this.mCurrentPath, (Paint)this.mCurrentPaint);
        }
        if (finishedPath && this.mPoints.size() > 0) {
            this.createHistoryPathFromPoints();
        }
    }

    private void createHistoryPathFromPoints() {
        this.mPaths.add(new HistoryPath(new SerializablePath(this.mCurrentPath), new SerializablePaint(this.mCurrentPaint), this.mPoints.get((int)0).x, this.mPoints.get((int)0).y, FreeDrawHelper.isAPoint(this.mPoints)));
        this.mPoints.clear();
        this.notifyPathDrawn();
        this.notifyRedoUndoCountChanged();
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        if (motionEvent.getAction() == 0) {
            this.mPathDrawnListener.onPathStart();
        }
        if (this.getParent() != null) {
            this.getParent().requestDisallowInterceptTouchEvent(true);
        }
        this.mCanceledPaths.clear();
        if (motionEvent.getAction() != 1 && motionEvent.getAction() != 3) {
            Point point;
            for (int i = 0; i < motionEvent.getHistorySize(); ++i) {
                point = new Point();
                point.x = motionEvent.getHistoricalX(i);
                point.y = motionEvent.getHistoricalY(i);
                this.mPoints.add(point);
            }
            point = new Point();
            point.x = motionEvent.getX();
            point.y = motionEvent.getY();
            this.mPoints.add(point);
        } else {
            this.mFinishPath = true;
        }
        this.invalidate();
        return true;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        float xMultiplyFactor = 1.0f;
        float yMultiplyFactor = 1.0f;
        if (this.mLastDimensionW == -1) {
            this.mLastDimensionW = w;
        }
        if (this.mLastDimensionH == -1) {
            this.mLastDimensionH = h;
        }
        if (w >= 0 && w != oldw && w != this.mLastDimensionW) {
            xMultiplyFactor = (float)w / (float)this.mLastDimensionW;
            this.mLastDimensionW = w;
        }
        if (h >= 0 && h != oldh && h != this.mLastDimensionH) {
            yMultiplyFactor = (float)h / (float)this.mLastDimensionH;
            this.mLastDimensionH = h;
        }
        this.multiplyPathsAndPoints(xMultiplyFactor, yMultiplyFactor);
    }

    private void multiplyPathsAndPoints(float xMultiplyFactor, float yMultiplyFactor) {
        if (xMultiplyFactor == 1.0f && yMultiplyFactor == 1.0f || xMultiplyFactor <= 0.0f || yMultiplyFactor <= 0.0f || this.mPaths.size() == 0 && this.mCanceledPaths.size() == 0 && this.mPoints.size() == 0) {
            return;
        }
        if (this.mResizeBehaviour == ResizeBehaviour.CLEAR) {
            this.mPaths.clear();
            this.mCanceledPaths.clear();
            this.mPoints.clear();
            return;
        }
        if (this.mResizeBehaviour == ResizeBehaviour.CROP) {
            yMultiplyFactor = 1.0f;
            xMultiplyFactor = 1.0f;
        }
        for (HistoryPath historyPath : this.mPaths) {
            this.multiplySinglePath(historyPath, xMultiplyFactor, yMultiplyFactor);
        }
        for (HistoryPath historyPath : this.mCanceledPaths) {
            this.multiplySinglePath(historyPath, xMultiplyFactor, yMultiplyFactor);
        }
        for (Point point : this.mPoints) {
            point.x *= xMultiplyFactor;
            point.y *= yMultiplyFactor;
        }
    }

    private void multiplySinglePath(HistoryPath historyPath, float xMultiplyFactor, float yMultiplyFactor) {
        if (historyPath.isPoint()) {
            historyPath.setOriginX(historyPath.getOriginX() * xMultiplyFactor);
            historyPath.setOriginY(historyPath.getOriginY() * yMultiplyFactor);
        } else {
            SerializablePath scaledPath = new SerializablePath();
            scaledPath.addPath(historyPath.getPath(), new TranslateMatrix(xMultiplyFactor, yMultiplyFactor));
            historyPath.getPath().close();
            historyPath.setPath(scaledPath);
        }
    }

    class TakeScreenShotAsyncTask
    extends AsyncTask<Void, Void, Void> {
        private int mWidth;
        private int mHeight;
        private Canvas mCanvas;
        private Bitmap mBitmap;
        private DrawCreatorListener mListener;

        public TakeScreenShotAsyncTask(DrawCreatorListener listener) {
            this.mListener = listener;
        }

        protected void onPreExecute() {
            super.onPreExecute();
            this.mWidth = FreeDrawView.this.getWidth();
            this.mHeight = FreeDrawView.this.getHeight();
        }

        protected Void doInBackground(Void ... params) {
            try {
                this.mBitmap = Bitmap.createBitmap((int)this.mWidth, (int)this.mHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                this.mCanvas = new Canvas(this.mBitmap);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.cancel(true);
            }
            return null;
        }

        protected void onCancelled() {
            super.onCancelled();
            if (this.mListener != null) {
                this.mListener.onDrawCreationError();
            }
        }

        protected void onPostExecute(Void aVoid) {
            super.onPostExecute((Object)aVoid);
            FreeDrawView.this.draw(this.mCanvas);
            if (this.mListener != null) {
                this.mListener.onDrawCreated(this.mBitmap);
            }
        }
    }

    public static interface DrawCreatorListener {
        public void onDrawCreated(Bitmap var1);

        public void onDrawCreationError();
    }
}

