/*
 * Decompiled with CFR 0.152.
 */
package com.rivancic.asyncapi.gradle;

import com.github.gradle.node.npm.task.NpxTask;
import com.rivancic.asyncapi.gradle.AsyncApiExtension;
import java.util.ArrayList;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class AsyncApiGeneratorPlugin
implements Plugin<Project> {
    private static final String GENERATE_TASK_NAME = "asyncApiGenerate";
    private static final String ASYNCAPI_TASK_GROUP = "asyncapi";
    public static final String ASYNCAPI_GENERATOR_COMMAND = "@asyncapi/generator";
    private static final String ASYNCAPI_EXTENSION_NAME = "asyncapi";

    public void apply(Project project) {
        project.getPluginManager().apply("base");
        project.getPluginManager().apply("com.github.node-gradle.node");
        AsyncApiExtension asyncApiExtension = (AsyncApiExtension)project.getExtensions().create("asyncapi", AsyncApiExtension.class, new Object[0]);
        project.getTasks().register(GENERATE_TASK_NAME, NpxTask.class, task -> {
            task.setGroup("asyncapi");
            task.getCommand().set((Object)(ASYNCAPI_GENERATOR_COMMAND + AsyncApiGeneratorPlugin.getAsyncApiVersion(asyncApiExtension)));
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(AsyncApiGeneratorPlugin.getAsyncApiFile(asyncApiExtension));
            parameters.add(AsyncApiGeneratorPlugin.getAsyncApiTemplate(asyncApiExtension));
            parameters.add("-o" + AsyncApiGeneratorPlugin.getAsyncApiOutputDirectory(asyncApiExtension));
            if (Boolean.TRUE.equals(asyncApiExtension.getPrintVersion().getOrElse((Object)false))) {
                parameters.add("-V");
            }
            if (Boolean.TRUE.equals(asyncApiExtension.getDebug().getOrElse((Object)false))) {
                parameters.add("--debug");
            }
            if (Boolean.TRUE.equals(asyncApiExtension.getForceWrite().getOrElse((Object)false))) {
                parameters.add("--force-write");
            }
            if (asyncApiExtension.getParameters().isPresent()) {
                ((Map)asyncApiExtension.getParameters().get()).forEach((key, value) -> parameters.add("-p" + key + "=" + value));
            }
            task.getArgs().addAll(parameters);
            task.getOutputs().dir((Object)AsyncApiGeneratorPlugin.getAsyncApiOutputDirectory(asyncApiExtension));
        });
    }

    private static String getAsyncApiVersion(AsyncApiExtension asyncApiExtension) {
        return (String)asyncApiExtension.getVersion().map(v -> "@" + v).getOrElse((Object)"");
    }

    private static String getAsyncApiOutputDirectory(AsyncApiExtension asyncApiExtension) {
        return (String)asyncApiExtension.getOutput().orElse((Object)"build/asyncapi").get();
    }

    private static String getAsyncApiTemplate(AsyncApiExtension asyncApiExtension) {
        if (!asyncApiExtension.getTemplate().isPresent()) {
            throw new GradleException("Async API Template has to be provided as asyncApiTemplate property");
        }
        String asyncApiTemplate = (String)asyncApiExtension.getTemplate().get();
        return asyncApiTemplate;
    }

    private static String getAsyncApiFile(AsyncApiExtension asyncApiExtension) {
        if (!asyncApiExtension.getAsyncapi().isPresent()) {
            throw new GradleException("Async API File has to be provided as asyncApiFile property");
        }
        String asyncApiFile = (String)asyncApiExtension.getAsyncapi().get();
        return asyncApiFile;
    }
}

