/*
 * Decompiled with CFR 0.152.
 */
package com.risesoftware.utils;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.risesoftware.utils.logging.RSLog;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.Instant;

public class ParcelableUtils {
    public static final String TAG = ParcelableUtils.class.getSimpleName();

    public static void write(Parcel dest, String string) {
        dest.writeByte((byte)(string != null ? 1 : 0));
        if (string != null) {
            dest.writeString(string);
        }
    }

    public static String readString(Parcel source) {
        if (source.readByte() == 1) {
            return source.readString();
        }
        return null;
    }

    public static void write(Parcel dest, Parcelable parcelable, int flags) {
        dest.writeByte((byte)(parcelable != null ? 1 : 0));
        if (parcelable != null) {
            dest.writeParcelable(parcelable, flags);
        }
    }

    public static <T extends Parcelable> T readParcelable(Parcel source) {
        if (source.readByte() == 1) {
            return (T)source.readParcelable(Thread.currentThread().getContextClassLoader());
        }
        return null;
    }

    public static void write(Parcel dest, Map<String, String> strings) {
        if (strings == null) {
            dest.writeInt(-1);
        }
        dest.writeInt(strings.keySet().size());
        for (String key : strings.keySet()) {
            dest.writeString(key);
            dest.writeString(strings.get(key));
        }
    }

    public static Map<String, String> readStringMap(Parcel source) {
        int numKeys = source.readInt();
        if (numKeys == -1) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < numKeys; ++i) {
            String key = source.readString();
            String value = source.readString();
            map.put(key, value);
        }
        return map;
    }

    public static <T extends Parcelable> void write(Parcel dest, Map<String, T> objects, int flags) {
        if (objects == null) {
            dest.writeInt(-1);
        } else {
            dest.writeInt(objects.keySet().size());
            for (String key : objects.keySet()) {
                dest.writeString(key);
                dest.writeParcelable((Parcelable)objects.get(key), flags);
            }
        }
    }

    public static <T extends Parcelable> Map<String, T> readParcelableMap(Parcel source) {
        int numKeys = source.readInt();
        if (numKeys == -1) {
            return null;
        }
        HashMap<String, Parcelable> map = new HashMap<String, Parcelable>();
        for (int i = 0; i < numKeys; ++i) {
            String key = source.readString();
            Parcelable value = source.readParcelable(Thread.currentThread().getContextClassLoader());
            map.put(key, value);
        }
        return map;
    }

    public static void write(Parcel dest, URL url) {
        dest.writeString(url.toExternalForm());
    }

    public static URL readURL(Parcel source) {
        try {
            return new URL(source.readString());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void write(Parcel dest, Uri uri) {
        dest.writeByte((byte)(uri != null ? 1 : 0));
        if (null != uri) {
            dest.writeString(uri.toString());
        }
    }

    public static Uri readUri(Parcel source) {
        if (source.readByte() == 1) {
            return Uri.parse((String)source.readString());
        }
        return null;
    }

    public static void write(Parcel dest, UUID uuid) {
        dest.writeByte((byte)(uuid != null ? 1 : 0));
        if (null != uuid) {
            dest.writeString(uuid.toString());
        }
    }

    public static UUID readUUID(Parcel source) {
        if (source.readByte() == 1) {
            return UUID.fromString(source.readString());
        }
        return null;
    }

    public static void write(Parcel dest, DateTime dateTime) {
        dest.writeByte((byte)(dateTime != null ? 1 : 0));
        if (dateTime != null) {
            dest.writeLong(dateTime.getMillis());
        }
    }

    public static DateTime readDateTime(Parcel source) {
        if (source.readByte() == 1) {
            return new DateTime(source.readLong());
        }
        return null;
    }

    public static void write(Parcel dest, Instant instant) {
        dest.writeByte((byte)(instant != null ? 1 : 0));
        if (instant != null) {
            dest.writeLong(instant.getMillis());
        }
    }

    public static Instant readInstant(Parcel source) {
        if (source.readByte() == 1) {
            return new Instant(source.readLong());
        }
        return null;
    }

    public static <T extends Enum<T>> void write(Parcel dest, Enum<T> enu) {
        if (enu == null) {
            dest.writeString("");
        } else {
            dest.writeString(enu.name());
        }
    }

    public static <T extends Enum<T>> T readEnum(Parcel in, Class<T> clazz) {
        String name = in.readString();
        if ("".equals(name)) {
            return null;
        }
        return Enum.valueOf(clazz, name);
    }

    public static void write(Parcel dest, boolean bool) {
        dest.writeByte((byte)(bool ? 1 : 0));
    }

    public static boolean readBoolean(Parcel source) {
        return source.readByte() == 1;
    }

    public static <T extends Parcelable> void write(Parcel dest, List<T> fields, int flags) {
        if (fields == null) {
            dest.writeInt(-1);
        } else {
            dest.writeInt(fields.size());
            for (Parcelable field : fields) {
                dest.writeParcelable(field, flags);
            }
        }
    }

    public static <T extends Parcelable> List<T> readParcelableList(Parcel source) {
        int size = source.readInt();
        if (size == -1) {
            return null;
        }
        ArrayList<Parcelable> list = new ArrayList<Parcelable>();
        for (int i = 0; i < size; ++i) {
            list.add(source.readParcelable(Thread.currentThread().getContextClassLoader()));
        }
        return list;
    }

    static {
        RSLog.LOG_LEVELS.put(TAG, 5);
    }
}

