/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2016, 2017 Michael Wallace, Rise Software
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package com.risesoftware.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.support.annotation.NonNull;
import com.risesoftware.utils.logging.RSLog;


/**
 * Simple utilities needed for the Activity class
 *
 * @author :  Mike Wallace (+MikeWallaceDev) <mike.wallace@risesoftware.com> on 2017-01-15.
 */
public class ActivityUtils
{
	@SuppressWarnings({"FieldNameHidesFieldInSuperclass", "unused"})
	public static final String TAG = ActivityUtils.class.getSimpleName();

	static {
		RSLog.LOG_LEVELS.put(TAG, RSLog.WARN);
	}

	@TargetApi(11)
	public static Activity getActivity(@NonNull Object object) {
		if (object instanceof Activity) {
			return ((Activity) object);
		}
		else if (object instanceof android.support.v4.app.Fragment) {
			return ((android.support.v4.app.Fragment) object).getActivity();
		}
		else if (object instanceof android.app.Fragment) {
			return ((android.app.Fragment) object).getActivity();
		}
		else {
			return null;
		}
	}
}
