/*
 * Decompiled with CFR 0.152.
 */
package com.risesoftware.utils;

import com.risesoftware.utils.exceptions.Exception_RequiredParameter;
import com.risesoftware.utils.logging.RSLog;
import java.security.SecureRandom;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    public static final String TAG = Utils.class.getSimpleName();
    public static final String EMAIL_PATTERN = "^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    static final Random m_random;

    public static int randInt(int min, int max) {
        return m_random.nextInt(max - min + 1) + min;
    }

    public static boolean checkValidEmail(CharSequence email) {
        if (null == email) {
            throw new Exception_RequiredParameter("email must not be null");
        }
        Pattern pattern = Pattern.compile(EMAIL_PATTERN);
        Matcher matcher = pattern.matcher(email);
        return matcher.matches();
    }

    public static String padDigitForDate(int number) {
        return Utils.padNumber(number, 2, '0', false);
    }

    public static String padNumber(int number, int desiredWidth, char c, boolean countSign) {
        StringBuilder strNumber = new StringBuilder(String.valueOf(number));
        int missing = desiredWidth - Utils.numDigits(number, countSign);
        for (int i = 0; i < missing; ++i) {
            strNumber.append(c);
        }
        return strNumber.toString();
    }

    public static <T extends Number> int numDigits(T number, boolean countSign) {
        int digits = 0;
        double value = number.doubleValue();
        if (countSign && 0.0 > value) {
            digits = 1;
        }
        while (0.0 < value) {
            value /= 10.0;
            ++digits;
        }
        return digits;
    }

    static {
        RSLog.LOG_LEVELS.put(TAG, 5);
        m_random = new SecureRandom();
    }
}

