/*
 * Decompiled with CFR 0.152.
 */
package com.risesoftware.ui.widget.layoutmanager;

import android.content.Context;
import android.graphics.Rect;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import java.lang.reflect.Field;

public class RSLinearLayoutManager
extends LinearLayoutManager {
    public final String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private static boolean canMakeInsetsDirty = true;
    private static Field insetsDirtyField = null;
    private static final int CHILD_WIDTH = 0;
    private static final int CHILD_HEIGHT = 1;
    private static final int DEFAULT_CHILD_SIZE = 100;
    private final int[] childDimensions = new int[2];
    private final RecyclerView view;
    private int childSize = 100;
    private boolean hasChildSize;
    private int overScrollMode = 0;
    private final Rect tmpRect = new Rect();

    public RSLinearLayoutManager(Context context) {
        super(context);
        this.view = null;
    }

    public RSLinearLayoutManager(Context context, int orientation, boolean reverseLayout) {
        super(context, orientation, reverseLayout);
        this.view = null;
    }

    public RSLinearLayoutManager(RecyclerView view) {
        super(view.getContext());
        this.view = view;
        this.overScrollMode = ViewCompat.getOverScrollMode((View)view);
    }

    public RSLinearLayoutManager(RecyclerView view, int orientation, boolean reverseLayout) {
        super(view.getContext(), orientation, reverseLayout);
        this.view = view;
        this.overScrollMode = ViewCompat.getOverScrollMode((View)view);
    }

    public void setOverScrollMode(int overScrollMode) {
        if (overScrollMode < 0 || overScrollMode > 2) {
            throw new IllegalArgumentException("Unknown overscroll mode: " + overScrollMode);
        }
        if (this.view == null) {
            throw new IllegalStateException("view == null");
        }
        this.overScrollMode = overScrollMode;
        ViewCompat.setOverScrollMode((View)this.view, (int)overScrollMode);
    }

    public static int makeUnspecifiedSpec() {
        return View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
    }

    public void onMeasure(RecyclerView.Recycler recycler, RecyclerView.State state, int widthSpec, int heightSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightSpec);
        boolean hasWidthSize = widthMode != 0;
        boolean hasHeightSize = heightMode != 0;
        boolean exactWidth = widthMode == 0x40000000;
        boolean exactHeight = heightMode == 0x40000000;
        int unspecified = RSLinearLayoutManager.makeUnspecifiedSpec();
        if (exactWidth && exactHeight) {
            super.onMeasure(recycler, state, widthSpec, heightSpec);
            return;
        }
        boolean vertical = this.getOrientation() == 1;
        this.initChildDimensions(widthSize, heightSize, vertical);
        int width = 0;
        int height = 0;
        recycler.clear();
        int stateItemCount = state.getItemCount();
        int adapterItemCount = this.getItemCount();
        for (int i = 0; i < adapterItemCount; ++i) {
            if (vertical) {
                if (!this.hasChildSize) {
                    if (i < stateItemCount) {
                        this.measureChild(recycler, i, widthSize, unspecified, this.childDimensions);
                    } else {
                        this.logMeasureWarning(i);
                    }
                }
                height += this.childDimensions[1];
                if (i == 0) {
                    width = this.childDimensions[0];
                }
                if (!hasHeightSize || height < heightSize) continue;
                break;
            }
            if (!this.hasChildSize) {
                if (i < stateItemCount) {
                    this.measureChild(recycler, i, unspecified, heightSize, this.childDimensions);
                } else {
                    this.logMeasureWarning(i);
                }
            }
            width += this.childDimensions[0];
            if (i == 0) {
                height = this.childDimensions[1];
            }
            if (hasWidthSize && width >= widthSize) break;
        }
        if (exactWidth) {
            width = widthSize;
        } else {
            width += this.getPaddingLeft() + this.getPaddingRight();
            if (hasWidthSize) {
                width = Math.min(width, widthSize);
            }
        }
        if (exactHeight) {
            height = heightSize;
        } else {
            height += this.getPaddingTop() + this.getPaddingBottom();
            if (hasHeightSize) {
                height = Math.min(height, heightSize);
            }
        }
        this.setMeasuredDimension(width, height);
        if (this.view != null && this.overScrollMode == 1) {
            boolean fit = vertical && (!hasHeightSize || height < heightSize) || !vertical && (!hasWidthSize || width < widthSize);
            ViewCompat.setOverScrollMode((View)this.view, (int)(fit ? 2 : 0));
        }
    }

    private void logMeasureWarning(int child) {
    }

    private void initChildDimensions(int width, int height, boolean vertical) {
        if (this.childDimensions[0] != 0 || this.childDimensions[1] != 0) {
            return;
        }
        if (vertical) {
            this.childDimensions[0] = width;
            this.childDimensions[1] = this.childSize;
        } else {
            this.childDimensions[0] = this.childSize;
            this.childDimensions[1] = height;
        }
    }

    public void setOrientation(int orientation) {
        if (this.childDimensions != null && this.getOrientation() != orientation) {
            this.childDimensions[0] = 0;
            this.childDimensions[1] = 0;
        }
        super.setOrientation(orientation);
    }

    public void clearChildSize() {
        this.hasChildSize = false;
        this.setChildSize(100);
    }

    public void setChildSize(int childSize) {
        this.hasChildSize = true;
        if (this.childSize != childSize) {
            this.childSize = childSize;
            this.requestLayout();
        }
    }

    private void measureChild(RecyclerView.Recycler recycler, int position, int widthSize, int heightSize, int[] dimensions) {
        View child;
        try {
            child = recycler.getViewForPosition(position);
        }
        catch (IndexOutOfBoundsException e) {
            return;
        }
        RecyclerView.LayoutParams p = (RecyclerView.LayoutParams)child.getLayoutParams();
        int hPadding = this.getPaddingLeft() + this.getPaddingRight();
        int vPadding = this.getPaddingTop() + this.getPaddingBottom();
        int hMargin = p.leftMargin + p.rightMargin;
        int vMargin = p.topMargin + p.bottomMargin;
        RSLinearLayoutManager.makeInsetsDirty(p);
        this.calculateItemDecorationsForChild(child, this.tmpRect);
        int hDecoration = this.getRightDecorationWidth(child) + this.getLeftDecorationWidth(child);
        int vDecoration = this.getTopDecorationHeight(child) + this.getBottomDecorationHeight(child);
        int childWidthSpec = RSLinearLayoutManager.getChildMeasureSpec((int)widthSize, (int)(hPadding + hMargin + hDecoration), (int)p.width, (boolean)this.canScrollHorizontally());
        int childHeightSpec = RSLinearLayoutManager.getChildMeasureSpec((int)heightSize, (int)(vPadding + vMargin + vDecoration), (int)p.height, (boolean)this.canScrollVertically());
        child.measure(childWidthSpec, childHeightSpec);
        dimensions[0] = this.getDecoratedMeasuredWidth(child) + p.leftMargin + p.rightMargin;
        dimensions[1] = this.getDecoratedMeasuredHeight(child) + p.bottomMargin + p.topMargin;
        RSLinearLayoutManager.makeInsetsDirty(p);
        recycler.recycleView(child);
    }

    private static void makeInsetsDirty(RecyclerView.LayoutParams p) {
        if (!canMakeInsetsDirty) {
            return;
        }
        try {
            if (insetsDirtyField == null) {
                insetsDirtyField = RecyclerView.LayoutParams.class.getDeclaredField("mInsetsDirty");
                insetsDirtyField.setAccessible(true);
            }
            insetsDirtyField.set(p, true);
        }
        catch (NoSuchFieldException e) {
            RSLinearLayoutManager.onMakeInsertDirtyFailed();
        }
        catch (IllegalAccessException e) {
            RSLinearLayoutManager.onMakeInsertDirtyFailed();
        }
    }

    private static void onMakeInsertDirtyFailed() {
        canMakeInsetsDirty = false;
    }
}

